/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.models;

import com.openshift.restclient.model.IBuild;
import com.openshift.restclient.model.IPod;
import com.openshift.restclient.model.IResource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.jboss.tools.common.ui.databinding.ObservableUIPojo;
import org.jboss.tools.openshift.common.core.utils.StringUtils;
import org.jboss.tools.openshift.internal.ui.models.IResourceUIModel;
import org.jboss.tools.openshift.internal.ui.models.IResourcesUIModel;
import org.jboss.tools.openshift.internal.ui.models.OpenShiftResourceUIModel;

public abstract class ResourcesUIModel
extends ObservableUIPojo
implements IResourcesUIModel {
    protected Map<String, List<IResourceUIModel>> resources = new ConcurrentHashMap<String, List<IResourceUIModel>>();
    private final Object parent;

    protected ResourcesUIModel(Object parent) {
        this.parent = parent;
        Arrays.asList(KINDS).forEach(k -> {
            List list = this.resources.put((String)k, Collections.synchronizedList(new ArrayList()));
        });
    }

    private <T extends IResource> List<IResourceUIModel> init(Collection<T> resources) {
        if (resources != null) {
            return resources.stream().map(r -> new OpenShiftResourceUIModel((IResource)r, this)).collect(Collectors.toList());
        }
        return new ArrayList<IResourceUIModel>();
    }

    @Override
    public Object getParent() {
        return this.parent;
    }

    @Override
    public Collection<IResourceUIModel> getImageStreams() {
        return this.resources.get("ImageStream");
    }

    @Override
    public void setImageStreams(Collection<IResourceUIModel> models) {
        this.firePropertyChange("imageStreams", this.resources.get("ImageStream"), this.resources.put("ImageStream", new ArrayList<IResourceUIModel>(models)));
    }

    @Override
    public void setImageStreamResources(Collection<IResource> streams) {
        this.firePropertyChange("imageStreams", this.resources.get("ImageStream"), this.resources.put("ImageStream", this.init(streams)));
    }

    @Override
    public Collection<IResourceUIModel> getDeploymentConfigs() {
        return this.resources.get("DeploymentConfig");
    }

    @Override
    public void setDeploymentConfigs(Collection<IResourceUIModel> models) {
        this.firePropertyChange("deploymentConfigs", this.resources.get("DeploymentConfig"), this.resources.put("DeploymentConfig", new ArrayList<IResourceUIModel>(models)));
    }

    @Override
    public void setDeploymentConfigResources(Collection<IResource> dcs) {
        this.firePropertyChange("deploymentConfigs", this.resources.get("DeploymentConfig"), this.resources.put("DeploymentConfig", this.init(dcs)));
    }

    public Collection<IResourceUIModel> getImageStreamTags() {
        return this.resources.get("ImageStreamTag");
    }

    public void setImageStreamTags(Collection<IResourceUIModel> models) {
        this.firePropertyChange("imageStreamTags", this.resources.get("ImageStreamTag"), this.resources.put("ImageStreamTag", new ArrayList<IResourceUIModel>(models)));
    }

    public void setImageStreamTagResources(Collection<IResource> istags) {
        this.firePropertyChange("imageStreamTags", this.resources.get("ImageStreamTag"), this.resources.put("ImageStreamTag", this.init(istags)));
    }

    @Override
    public Collection<IResourceUIModel> getBuilds() {
        return this.resources.get("Build");
    }

    @Override
    public void setBuilds(Collection<IResourceUIModel> builds) {
        this.firePropertyChange("builds", this.resources.get("Build"), this.resources.put("Build", new ArrayList<IResourceUIModel>(builds)));
    }

    @Override
    public void setBuildResources(Collection<IBuild> builds) {
        this.firePropertyChange("builds", this.resources.get("Build"), this.resources.put("Build", this.init(builds)));
    }

    @Override
    public Collection<IResourceUIModel> getPods() {
        return this.resources.get("Pod");
    }

    @Override
    public void setPods(Collection<IResourceUIModel> pods) {
        this.firePropertyChange("pods", this.resources.get("Pod"), this.resources.put("Pod", new ArrayList<IResourceUIModel>(pods)));
    }

    @Override
    public void setPodResources(Collection<IPod> pods) {
        this.firePropertyChange("pods", this.resources.get("Pod"), this.resources.put("Pod", this.init(pods)));
    }

    @Override
    public Collection<IResourceUIModel> getRoutes() {
        return this.resources.get("Route");
    }

    @Override
    public void setRoutes(Collection<IResourceUIModel> routes) {
        this.firePropertyChange("routes", this.resources.get("Route"), this.resources.put("Route", new ArrayList<IResourceUIModel>(routes)));
    }

    @Override
    public void setRouteResources(Collection<IResource> routes) {
        this.firePropertyChange("routes", this.resources.get("Route"), this.resources.put("Route", this.init(routes)));
    }

    @Override
    public Collection<IResourceUIModel> getReplicationControllers() {
        return this.resources.get("ReplicationController");
    }

    @Override
    public void setReplicationControllers(Collection<IResourceUIModel> rcs) {
        this.firePropertyChange("replicationControllers", this.resources.get("ReplicationController"), this.resources.put("ReplicationController", new ArrayList<IResourceUIModel>(rcs)));
    }

    @Override
    public void setReplicationControllerResources(Collection<IResource> rcs) {
        this.firePropertyChange("replicationControllers", this.resources.get("ReplicationController"), this.resources.put("ReplicationController", this.init(rcs)));
    }

    @Override
    public Collection<IResourceUIModel> getBuildConfigs() {
        return this.resources.get("BuildConfig");
    }

    @Override
    public void setBuildConfigs(Collection<IResourceUIModel> buildConfigs) {
        this.firePropertyChange("buildConfigs", this.resources.get("BuildConfig"), this.resources.put("BuildConfig", new ArrayList<IResourceUIModel>(buildConfigs)));
    }

    @Override
    public void setBuildConfigResources(Collection<IResource> buildConfigs) {
        this.firePropertyChange("buildConfigs", this.resources.get("BuildConfig"), this.resources.put("BuildConfig", this.init(buildConfigs)));
    }

    @Override
    public Collection<IResourceUIModel> getServices() {
        return this.resources.get("Service");
    }

    @Override
    public void setServices(Collection<IResourceUIModel> services) {
        this.firePropertyChange("services", this.resources.get("Service"), this.resources.put("Service", new ArrayList<IResourceUIModel>(services)));
    }

    @Override
    public void setServiceResources(Collection<IResource> services) {
        this.firePropertyChange("services", this.resources.get("Service"), this.resources.put("Service", this.init(services)));
    }

    @Override
    public void add(IResource resource) {
        String property = ResourcesUIModel.getProperty(resource.getKind());
        List<IResourceUIModel> models = this.resources.get(resource.getKind());
        if (models != null) {
            ArrayList<IResourceUIModel> old = new ArrayList<IResourceUIModel>(models);
            models.add(new OpenShiftResourceUIModel(resource, this));
            int index = models.size() - 1;
            this.fireIndexedPropertyChange(property, index, old, Collections.unmodifiableList(models));
        }
    }

    @Override
    public void remove(IResource resource) {
        int index;
        String property = ResourcesUIModel.getProperty(resource.getKind());
        List<IResourceUIModel> models = this.resources.get(resource.getKind());
        if (models != null && (index = this.indexOf(models, resource)) > -1) {
            ArrayList<IResourceUIModel> old = new ArrayList<IResourceUIModel>(models);
            models.remove(index);
            this.fireIndexedPropertyChange(property, index, old, Collections.unmodifiableList(models));
        }
    }

    @Override
    public void update(IResource resource) {
        int index;
        String property = ResourcesUIModel.getProperty(resource.getKind());
        List<IResourceUIModel> models = this.resources.get(resource.getKind());
        if (models != null && (index = this.indexOf(models, resource)) > -1) {
            ArrayList<IResourceUIModel> old = new ArrayList<IResourceUIModel>(models);
            models.set(index, new OpenShiftResourceUIModel(resource, this));
            this.fireIndexedPropertyChange(property, index, old, Collections.unmodifiableList(models));
        }
    }

    private int indexOf(List<IResourceUIModel> models, IResource resource) {
        int i = 0;
        while (i < models.size()) {
            IResource old;
            IResourceUIModel model = models.get(i);
            if (model != null && (old = model.getResource()).equals(resource)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static String getProperty(String kind) {
        return StringUtils.pluralize((String)kind.toLowerCase());
    }

    public Collection<IResource> getResources(String kind) {
        if (!this.resources.containsKey(kind)) {
            return Collections.emptyList();
        }
        return this.resources.get(kind).stream().map(r -> r.getResource()).collect(Collectors.toList());
    }
}

