/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.models;

import com.openshift.restclient.OpenShiftException;
import com.openshift.restclient.model.IResource;
import org.jboss.tools.common.ui.databinding.ObservableUIPojo;
import org.jboss.tools.openshift.internal.ui.models.IResourceUIModel;
import org.jboss.tools.openshift.internal.ui.models.IResourcesUIModel;

public class OpenShiftResourceUIModel
extends ObservableUIPojo
implements IResourceUIModel {
    private final IResource resource;
    private final String tostring;
    private final Object parent;

    public OpenShiftResourceUIModel(IResource resource, IResourcesUIModel parent) {
        if (resource == null) {
            throw new OpenShiftException("A null resource was passed while trying to create a display model", new Object[0]);
        }
        if (parent == null) {
            throw new OpenShiftException("A null parent was passed while trying to create a display model", new Object[0]);
        }
        this.parent = parent;
        this.resource = resource;
        this.tostring = String.valueOf(resource.getNamespace()) + "/" + resource.getKind() + "/" + resource.getName() + "/" + resource.getResourceVersion();
    }

    @Override
    public Object getParent() {
        return this.parent;
    }

    @Override
    public IResource getResource() {
        return this.resource;
    }

    public int hashCode() {
        int result = 1;
        String resourceVersion = this.resource == null ? "" : this.resource.getResourceVersion();
        result = 31 * result + (this.resource == null ? 0 : this.resource.hashCode());
        result = 31 * result + (this.parent == null ? 0 : this.parent.hashCode());
        result = 31 * result + (resourceVersion == null ? 0 : resourceVersion.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OpenShiftResourceUIModel other = (OpenShiftResourceUIModel)obj;
        if (this.resource == null ? other.resource != null : !this.resource.equals(other.resource)) {
            return false;
        }
        if (this.parent == null ? other.parent != null : !this.parent.equals(other.parent)) {
            return false;
        }
        String resourceVersion = this.resource.getResourceVersion();
        return !(resourceVersion == null ? other.getResource().getResourceVersion() != null : !resourceVersion.equals(other.getResource().getResourceVersion()));
    }

    public String toString() {
        return this.tostring;
    }
}

