/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.models;

import com.openshift.restclient.model.IProject;
import com.openshift.restclient.model.IResource;
import java.beans.IndexedPropertyChangeEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import org.jboss.tools.openshift.common.core.IRefreshable;
import org.jboss.tools.openshift.core.connection.Connection;
import org.jboss.tools.openshift.internal.ui.models.Deployment;
import org.jboss.tools.openshift.internal.ui.models.DeploymentResourceMapper;
import org.jboss.tools.openshift.internal.ui.models.IProjectAdapter;
import org.jboss.tools.openshift.internal.ui.models.IResourceUIModel;
import org.jboss.tools.openshift.internal.ui.models.ResourcesUIModel;

public class OpenShiftProjectUIModel
extends ResourcesUIModel
implements IProjectAdapter,
IResourceUIModel,
IRefreshable,
PropertyChangeListener {
    public static final String PROP_LOADING = "loading";
    private final DeploymentResourceMapper mapper;
    private final IProject project;

    public OpenShiftProjectUIModel(Connection conn, IProject project) {
        super(conn);
        this.project = project;
        this.mapper = new DeploymentResourceMapper(conn, this);
        this.mapper.addPropertyChangeListener("deployments", this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt instanceof IndexedPropertyChangeEvent) {
            this.fireIndexedPropertyChange(evt.getPropertyName(), ((IndexedPropertyChangeEvent)evt).getIndex(), evt.getOldValue(), evt.getNewValue());
        } else {
            this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
        }
    }

    @Override
    public Collection<Deployment> getDeployments() {
        return this.mapper.getDeployments();
    }

    @Override
    public void setDeployments(Collection<Deployment> deployment) {
    }

    public void refresh() {
        this.mapper.refresh();
    }

    @Override
    public IProject getProject() {
        return this.project;
    }

    @Override
    public IResource getResource() {
        return this.getProject();
    }

    public boolean isLoading() {
        return false;
    }

    @Override
    public <T extends IResource> void setResources(Collection<T> resources, String kind) {
        switch (kind) {
            case "Build": {
                this.setBuildResources(resources);
                break;
            }
            case "BuildConfig": {
                this.setBuildConfigResources(resources);
                break;
            }
            case "DeploymentConfig": {
                this.setDeploymentConfigResources(resources);
                break;
            }
            case "ImageStream": {
                this.setImageStreamResources(resources);
                break;
            }
            case "Pod": {
                this.setPodResources(resources);
                break;
            }
            case "Route": {
                this.setRouteResources(resources);
                break;
            }
            case "ReplicationController": {
                this.setReplicationControllerResources(resources);
                break;
            }
            case "Service": {
                this.setServiceResources(resources);
            }
        }
    }
}

