/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.models;

import com.openshift.restclient.images.DockerImageURI;
import com.openshift.restclient.model.IBuild;
import com.openshift.restclient.model.IBuildConfig;
import com.openshift.restclient.model.IDeploymentConfig;
import com.openshift.restclient.model.IImageStream;
import com.openshift.restclient.model.IObjectReference;
import com.openshift.restclient.model.IPod;
import com.openshift.restclient.model.IProject;
import com.openshift.restclient.model.IReplicationController;
import com.openshift.restclient.model.IResource;
import com.openshift.restclient.model.IService;
import com.openshift.restclient.model.deploy.IDeploymentImageChangeTrigger;
import com.openshift.restclient.model.deploy.IDeploymentTrigger;
import com.openshift.restclient.model.route.IRoute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.common.databinding.ObservablePojo;
import org.jboss.tools.openshift.common.core.IRefreshable;
import org.jboss.tools.openshift.common.core.connection.ConnectionsRegistryAdapter;
import org.jboss.tools.openshift.common.core.connection.ConnectionsRegistrySingleton;
import org.jboss.tools.openshift.common.core.connection.IConnection;
import org.jboss.tools.openshift.common.core.connection.IConnectionsRegistryListener;
import org.jboss.tools.openshift.core.OpenShiftAPIAnnotations;
import org.jboss.tools.openshift.core.connection.Connection;
import org.jboss.tools.openshift.internal.core.Trace;
import org.jboss.tools.openshift.internal.core.WatchManager;
import org.jboss.tools.openshift.internal.core.util.ResourceUtils;
import org.jboss.tools.openshift.internal.ui.OpenShiftUIActivator;
import org.jboss.tools.openshift.internal.ui.models.Deployment;
import org.jboss.tools.openshift.internal.ui.models.IProjectAdapter;
import org.jboss.tools.openshift.internal.ui.models.IRelationCache;
import org.jboss.tools.openshift.internal.ui.models.IResourceUIModel;

public class DeploymentResourceMapper
extends ObservablePojo
implements OpenShiftAPIAnnotations,
IRefreshable,
IRelationCache {
    private static final String DOCKER_IMAGE_KIND = "DockerImage";
    private static final String IMAGE_STREAM_IMAGE_KIND = "ImageStreamImage";
    private static final String IMAGE_STREAM_TAG_KIND = "ImageStreamTag";
    private static final String RELATION_DELIMITER = "->";
    private static final Map<String, String[]> RELATIONSHIP_TYPE_MAP = new HashMap<String, String[]>();
    private final IProjectAdapter projectAdapter;
    private final IProject project;
    private final Connection conn;
    private Set<Deployment> deployments = Collections.synchronizedSet(new HashSet());
    private Map<IResource, Collection<Deployment>> resourceToDeployments = new ConcurrentHashMap<IResource, Collection<Deployment>>();
    private Map<String, Collection<IDeploymentConfig>> imageRefToDeployConfigs = new ConcurrentHashMap<String, Collection<IDeploymentConfig>>();
    private Map<String, Collection<IResource>> relationMap = new ConcurrentHashMap<String, Collection<IResource>>();
    private Map<String, IResource> cache = new ConcurrentHashMap<String, IResource>();
    private AtomicReference<State> state = new AtomicReference<State>(State.UNINITIALIZED);
    private IConnectionsRegistryListener connectionListener = new ConnectionListener();

    static {
        RELATIONSHIP_TYPE_MAP.put("Build", new String[]{"BuildConfig", "DeploymentConfig", "Pod"});
        RELATIONSHIP_TYPE_MAP.put("Service", new String[]{"Route", "Pod"});
    }

    public DeploymentResourceMapper(Connection conn, IProjectAdapter projectAdapter) {
        this.projectAdapter = projectAdapter;
        this.project = projectAdapter.getProject();
        this.conn = conn;
        WatchManager.getInstance().startWatch(this.project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void refresh() {
        Set<Deployment> set = this.deployments;
        synchronized (set) {
            this.deployments.clear();
        }
        Map[] mapArray = new Map[]{this.resourceToDeployments, this.imageRefToDeployConfigs, this.relationMap, this.cache};
        int n = mapArray.length;
        int n2 = 0;
        while (n2 < n) {
            Map map = mapArray[n2];
            map.clear();
            ++n2;
        }
        this.state.set(State.UNINITIALIZED);
        this.buildDeployments();
    }

    private void buildDeployments() {
        if (this.state.compareAndSet(State.UNINITIALIZED, State.LOADING)) {
            try {
                ConnectionsRegistrySingleton.getInstance().removeListener(this.connectionListener);
                List<IReplicationController> rcs = this.load("ReplicationController");
                List<IService> services = this.load("Service");
                List<IRoute> routes = this.load("Route");
                List<IBuild> builds = this.load("Build");
                List<IPod> pods = this.load("Pod");
                List<IDeploymentConfig> deployConfigs = this.load("DeploymentConfig");
                List<IBuildConfig> buildConfigs = this.load("BuildConfig");
                List<IImageStream> imageStreams = this.load("ImageStream");
                List<IResource> imageStreamTags = this.load(IMAGE_STREAM_TAG_KIND);
                this.imageRefToDeployConfigs = this.mapImageRefToDeployConfigs(deployConfigs);
                this.mapPods(pods, rcs, deployConfigs, builds);
                this.mapChildToParent(rcs, deployConfigs, "openshift.io/deployment-config.name");
                this.mapChildToParent(builds, buildConfigs, "openshift.io/build-config.name", true);
                this.mapBuildConfigsToImageStreams(buildConfigs, imageStreams);
                this.mapBuildConfigsToImageStreamTags(buildConfigs, imageStreamTags);
                this.mapBuildsToDeploymentConfigs(builds);
                this.mapServices(services, rcs, deployConfigs, routes);
                services.forEach(service -> this.buildDeploymentFor((IService)service, (Collection<IPod>)pods, (Collection<IBuild>)builds));
                ConnectionsRegistrySingleton.getInstance().addListener(this.connectionListener);
            }
            finally {
                this.state.set(State.LOADED);
            }
        }
    }

    private void mapServices(Collection<IService> services, Collection<IReplicationController> rcs, Collection<IDeploymentConfig> deployConfigs, Collection<IRoute> routes) {
        this.mapServicesToRepControllers(services, rcs);
        this.mapServicesToDeploymentConfigs(services, deployConfigs);
        this.mapServicesToRoutes(services, routes);
    }

    private void mapPods(Collection<IPod> pods, Collection<IReplicationController> rcs, Collection<IDeploymentConfig> deployConfigs, Collection<IBuild> builds) {
        this.mapChildToParent(pods, rcs, "openshift.io/deployment.name");
        this.mapChildToParent(pods, deployConfigs, "openshift.io/deployment-config.name");
        this.mapChildToParent(pods, builds, "openshift.io/build.name");
    }

    private void buildDeploymentFor(IService service, Collection<IPod> pods, Collection<IBuild> builds) {
        Deployment deployment = new Deployment(service, this.projectAdapter);
        this.initDeployment(deployment, pods, builds);
        this.addDeployment(deployment);
    }

    private void initDeployment(Deployment deployment, Collection<IPod> pods, Collection<IBuild> builds) {
        IService service = deployment.getService();
        Collection<IPod> appPods = this.getPodsForService(service, pods);
        Collection<IResource> appRcs = this.getResourcesFor((IResource)service, "ReplicationController");
        Collection<IBuild> appBuilds = this.getBuildsForPods(appPods, builds);
        Collection<IResource> appBuildConfigs = this.getResourcesFor(appBuilds, "BuildConfig");
        Collection<IResource> appImageStreamTags = this.getResourcesFor(appBuildConfigs, IMAGE_STREAM_TAG_KIND);
        appPods.forEach(p -> this.createRelation((IResource)p, (IResource)service));
        deployment.setBuildResources(appBuilds);
        deployment.setPodResources(appPods);
        deployment.setRouteResources(this.getResourcesFor((IResource)service, "Route"));
        deployment.setBuildConfigResources(appBuildConfigs);
        deployment.setReplicationControllerResources(appRcs);
        deployment.setImageStreamResources(this.getResourcesFor(appBuildConfigs, "ImageStream"));
        deployment.setDeploymentConfigResources(this.getResourcesFor((IResource)service, "DeploymentConfig"));
        deployment.setImageStreamTagResources(appImageStreamTags);
        this.mapResourcesFor(deployment);
    }

    public boolean isLoading() {
        return State.LOADING == this.state.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void addDeployment(Deployment deployment) {
        Set<Deployment> set = this.deployments;
        synchronized (set) {
            ArrayList<Deployment> old = new ArrayList<Deployment>(this.deployments);
            this.deployments.add(deployment);
            int index = this.deployments.size() - 1;
            this.fireIndexedPropertyChange("deployments", index, old, new ArrayList<Deployment>(this.deployments));
        }
    }

    private void mapResourcesFor(Deployment deployment) {
        this.mapResourceToDeployment((IResource)deployment.getService(), deployment);
        this.mapResourcesToDeployment(deployment.getBuilds(), deployment);
        this.mapResourcesToDeployment(deployment.getPods(), deployment);
        this.mapResourcesToDeployment(deployment.getRoutes(), deployment);
        this.mapResourcesToDeployment(deployment.getBuildConfigs(), deployment);
        this.mapResourcesToDeployment(deployment.getReplicationControllers(), deployment);
        this.mapResourcesToDeployment(deployment.getImageStreams(), deployment);
        this.mapResourcesToDeployment(deployment.getImageStreamTags(), deployment);
        this.mapResourcesToDeployment(deployment.getDeploymentConfigs(), deployment);
    }

    private void mapResourcesToDeployment(Collection<IResourceUIModel> resources, Deployment deployment) {
        for (IResourceUIModel model : resources) {
            this.mapResourceToDeployment(model.getResource(), deployment);
        }
    }

    private void mapBuildConfigsToImageStreams(Collection<IBuildConfig> buildConfigs, Collection<IImageStream> is) {
        HashMap<String, IImageStream> tagsToStreams = new HashMap<String, IImageStream>();
        for (IImageStream stream : is) {
            String name = stream.getName();
            Collection tags = stream.getTagNames();
            for (String tag : tags) {
                String key = String.valueOf(name) + ":" + tag;
                tagsToStreams.put(key, stream);
            }
        }
        buildConfigs.forEach(bc -> this.createRelation((IResource)bc, (IResource)tagsToStreams.get(bc.getBuildOutputReference().getName())));
    }

    private void mapBuildConfigsToImageStreamTags(List<IBuildConfig> buildConfigs, List<IResource> istags) {
        Map istagnames = istags.stream().collect(Collectors.toMap(IResource::getName, Function.identity()));
        for (IBuildConfig buildConfig : buildConfigs) {
            IObjectReference reference = buildConfig.getBuildOutputReference();
            if (!IMAGE_STREAM_TAG_KIND.equals(reference.getKind()) || !istagnames.containsKey(reference.getName())) continue;
            this.createRelation((IResource)buildConfig, (IResource)istagnames.get(reference.getName()));
        }
    }

    @Override
    public Collection<IResource> getResourcesFor(IResource resource, String targetKind) {
        return this.getResourcesFor(Arrays.asList(resource), targetKind);
    }

    public Collection<IResource> getResourcesFor(Collection<? extends IResource> resources, String targetKind) {
        HashSet<IResource> set = new HashSet<IResource>();
        for (IResource iResource : resources) {
            Collection<IResource> targets = this.relationMap.get(this.getRelationKey(iResource, targetKind));
            if (targets == null) continue;
            set.addAll(targets);
        }
        return set;
    }

    private <T extends IResource> List<T> load(String kind) {
        List resources = this.conn.getResources(kind, this.project.getName());
        this.projectAdapter.setResources(new HashSet(resources), kind);
        resources.forEach(r -> {
            IResource iResource = this.cache.put(this.getCacheKey((IResource)r), (IResource)r);
        });
        return resources;
    }

    private void mapBuildsToDeploymentConfigs(Collection<IBuild> builds) {
        builds.forEach(build -> this.mapBuildToDeploymentConfig((IBuild)build));
    }

    private void mapBuildToDeploymentConfig(IBuild build) {
        String imageRef = this.imageRef(build, this.project);
        Collection<IDeploymentConfig> deploymentConfigs = this.imageRefToDeployConfigs.get(imageRef);
        if (deploymentConfigs != null) {
            deploymentConfigs.forEach(dc -> this.createRelation((IResource)build, (IResource)dc));
        }
    }

    private void mapChildToParent(Collection<? extends IResource> manys, Collection<? extends IResource> ones, String annotation) {
        this.mapChildToParent(manys, ones, annotation, false);
    }

    private void mapChildToParent(Collection<? extends IResource> manys, Collection<? extends IResource> ones, String annotation, boolean annotationKeyIsLabel) {
        Map parents = ones.stream().collect(Collectors.toMap(IResource::getName, Function.identity()));
        for (IResource iResource : manys) {
            String parentName;
            String string = parentName = annotationKeyIsLabel ? (String)iResource.getLabels().get(annotation) : iResource.getAnnotation(annotation);
            if (!parents.containsKey(parentName)) continue;
            IResource parent = (IResource)parents.get(parentName);
            this.createRelation(iResource, parent);
        }
    }

    private String getCacheKey(IResource resource) {
        return this.getCacheKey(resource.getName(), resource.getKind());
    }

    private String getCacheKey(String name, String kind) {
        return NLS.bind((String)"{0}::{1}", (Object)name, (Object)kind);
    }

    private String getRelationKey(IResource resource, String targetKind) {
        return this.getKey(resource.getName(), resource.getKind(), targetKind);
    }

    private String getKey(String name, String sourceKind, String targetKind) {
        return NLS.bind((String)"{0}::{1}{2}{3}", (Object[])new Object[]{name, sourceKind, RELATION_DELIMITER, targetKind});
    }

    private void createRelation(IResource start, IResource end) {
        if (start == null || end == null) {
            return;
        }
        String startKey = this.getRelationKey(start, end.getKind());
        if (!this.relationMap.containsKey(startKey)) {
            this.relationMap.put(startKey, Collections.synchronizedSet(new HashSet()));
        }
        this.relationMap.get(startKey).add(end);
        String endKey = this.getRelationKey(end, start.getKind());
        if (!this.relationMap.containsKey(endKey)) {
            this.relationMap.put(endKey, Collections.synchronizedSet(new HashSet()));
        }
        this.relationMap.get(endKey).add(start);
    }

    private Collection<IPod> getPodsForService(IService service, Collection<IPod> pods) {
        Map serviceSelector = service.getSelector();
        return pods.stream().filter(p -> ResourceUtils.selectorsOverlap((Map)serviceSelector, (Map)p.getLabels())).collect(Collectors.toSet());
    }

    private void mapResourceToDeployment(IResource resource, Deployment deployment) {
        if (!this.resourceToDeployments.containsKey(resource)) {
            this.resourceToDeployments.put(resource, Collections.synchronizedSet(new HashSet()));
        }
        this.resourceToDeployments.get(resource).add(deployment);
    }

    public boolean isLoaded() {
        return State.LOADED == this.state.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Deployment> getDeployments() {
        this.buildDeployments();
        Set<Deployment> set = this.deployments;
        synchronized (set) {
            return new HashSet<Deployment>(this.deployments);
        }
    }

    private void mapServicesToRoutes(Collection<IService> services, Collection<IRoute> routes) {
        Map serviceToRoute = routes.stream().collect(Collectors.toMap(IRoute::getServiceName, Function.identity()));
        services.forEach(s -> this.createRelation((IResource)s, (IResource)serviceToRoute.get(s.getName())));
    }

    private void mapServicesToRepControllers(Collection<IService> services, Collection<IReplicationController> rcs) {
        for (IReplicationController rc : rcs) {
            Map deploymentSelector = rc.getReplicaSelector();
            for (IService service : services) {
                Map serviceSelector = service.getSelector();
                if (!ResourceUtils.selectorsOverlap((Map)serviceSelector, (Map)deploymentSelector)) continue;
                this.createRelation((IResource)service, (IResource)rc);
            }
        }
    }

    private void mapServicesToDeploymentConfigs(Collection<IService> services, Collection<IDeploymentConfig> dcs) {
        for (IDeploymentConfig dc : dcs) {
            Map deploymentSelector = dc.getReplicaSelector();
            for (IService service : services) {
                Map serviceSelector = service.getSelector();
                if (!ResourceUtils.selectorsOverlap((Map)serviceSelector, (Map)deploymentSelector)) continue;
                this.createRelation((IResource)service, (IResource)dc);
            }
        }
    }

    private Collection<IBuild> getBuildsForPods(Collection<IPod> pods, Collection<IBuild> builds) {
        HashSet<IBuild> buildsForDeployment = new HashSet<IBuild>();
        List<IDeploymentConfig> dcs = pods.stream().map(p -> this.getResourcesFor((IResource)p, "DeploymentConfig")).flatMap(l -> l.stream()).map(r -> (IDeploymentConfig)r).collect(Collectors.toList());
        Map<String, Collection<IDeploymentConfig>> imageRefToDeployConfigs = this.mapImageRefToDeployConfigs(dcs);
        for (IBuild build : builds) {
            String buildImageRef = this.imageRef(build, this.project);
            if (!imageRefToDeployConfigs.containsKey(buildImageRef)) continue;
            buildsForDeployment.add(build);
        }
        return buildsForDeployment;
    }

    private Map<String, Collection<IDeploymentConfig>> mapImageRefToDeployConfigs(Collection<IDeploymentConfig> configs) {
        return this.mapImageRefToDeployConfigs(new ConcurrentHashMap<String, Collection<IDeploymentConfig>>(), configs);
    }

    private Map<String, Collection<IDeploymentConfig>> mapImageRefToDeployConfigs(Map<String, Collection<IDeploymentConfig>> map, Collection<IDeploymentConfig> configs) {
        for (IDeploymentConfig dc : configs) {
            List<IDeploymentTrigger> imageChangeTriggers = this.filterImageChangeTriggers(dc);
            for (IDeploymentTrigger trigger : imageChangeTriggers) {
                String imageRef = this.imageRef((IDeploymentImageChangeTrigger)trigger, this.project);
                if (!map.containsKey(imageRef)) {
                    map.put(imageRef, Collections.synchronizedSet(new HashSet()));
                }
                map.get(imageRef).add(dc);
            }
        }
        return map;
    }

    private String imageRef(IBuild build, IProject project) {
        String kind = build.getOutputKind();
        if (IMAGE_STREAM_TAG_KIND.equals(kind) || IMAGE_STREAM_IMAGE_KIND.equals(kind)) {
            return new DockerImageURI("", project.getName(), build.getOutputTo().getNameAndTag()).toString();
        }
        if (DOCKER_IMAGE_KIND.equals(kind)) {
            return build.getOutputTo().getNameAndTag().toString();
        }
        return "";
    }

    private String imageRef(IDeploymentImageChangeTrigger trigger, IProject project) {
        String kind = trigger.getKind();
        if (IMAGE_STREAM_TAG_KIND.equals(kind) || IMAGE_STREAM_IMAGE_KIND.equals(kind)) {
            return new DockerImageURI("", project.getName(), trigger.getFrom().getNameAndTag()).toString();
        }
        if (DOCKER_IMAGE_KIND.equals(kind)) {
            return trigger.getFrom().getNameAndTag().toString();
        }
        return "";
    }

    private List<IDeploymentTrigger> filterImageChangeTriggers(IDeploymentConfig dc) {
        return dc.getTriggers().stream().filter(t -> t.getType().equals("ImageChange")).collect(Collectors.toList());
    }

    private <T extends IResource> Collection<T> getResourcesOf(String kind) {
        return this.cache.values().stream().filter(r -> kind.equals(r.getKind())).map(r -> r).collect(Collectors.toList());
    }

    public synchronized void add(IResource resource) {
        try {
            Trace.debug((String)"Trying to add resource to deployment {0}", (Object[])new Object[]{resource});
            if (this.cache.containsKey(this.getCacheKey(resource))) {
                Trace.debug((String)"-->Returning early since already processed {0}", (Object[])new Object[]{resource});
                return;
            }
            this.cache.put(this.getCacheKey(resource), resource);
            this.projectAdapter.add(resource);
            switch (resource.getKind()) {
                case "Build": {
                    IBuild build = (IBuild)resource;
                    List<IBuild> builds = Arrays.asList(build);
                    this.mapBuildsToDeploymentConfigs(builds);
                    this.mapChildToParent(builds, this.getResourcesOf("BuildConfig"), "openshift.io/build-config.name", true);
                    this.mapChildToParent(this.getResourcesOf("Pod"), builds, "openshift.io/build.name");
                    break;
                }
                case "BuildConfig": {
                    IBuildConfig bc = (IBuildConfig)resource;
                    List<IBuildConfig> bcs = Arrays.asList(bc);
                    this.mapChildToParent(this.getResourcesOf("Build"), bcs, "openshift.io/build-config.name", true);
                    this.mapBuildConfigsToImageStreams(bcs, this.getResourcesOf("ImageStream"));
                    break;
                }
                case "DeploymentConfig": {
                    IDeploymentConfig dc = (IDeploymentConfig)resource;
                    List<IDeploymentConfig> dcs = Arrays.asList(dc);
                    this.mapImageRefToDeployConfigs(this.imageRefToDeployConfigs, dcs);
                    this.mapBuildsToDeploymentConfigs(this.getResourcesOf("Build"));
                    this.mapServicesToDeploymentConfigs(this.getResourcesOf("Service"), dcs);
                    this.mapChildToParent(this.getResourcesOf("Pod"), dcs, "openshift.io/deployment-config.name");
                    this.mapChildToParent(this.getResourcesOf("ReplicationController"), dcs, "openshift.io/deployment-config.name");
                    break;
                }
                case "ImageStream": {
                    IImageStream is = (IImageStream)resource;
                    this.mapBuildConfigsToImageStreams(this.getResourcesOf("BuildConfig"), Arrays.asList(is));
                    break;
                }
                case "ReplicationController": {
                    IReplicationController rc = (IReplicationController)resource;
                    List<IReplicationController> rcs = Arrays.asList(rc);
                    Collection deployConfigs = this.getResourcesOf("DeploymentConfig");
                    this.mapChildToParent(this.getResourcesOf("Pod"), rcs, "openshift.io/deployment.name");
                    this.mapChildToParent(rcs, deployConfigs, "openshift.io/deployment-config.name");
                    this.mapServicesToRepControllers(this.getResourcesOf("Service"), rcs);
                    break;
                }
                case "Service": {
                    IService service = (IService)resource;
                    this.mapServices(Arrays.asList(service), this.getResourcesOf("ReplicationController"), this.getResourcesOf("DeploymentConfig"), this.getResourcesOf("Route"));
                    Collection<IPod> pods = this.getResourcesOf("Pod");
                    Collection<IBuild> builds = this.getResourcesOf("Build");
                    this.buildDeploymentFor(service, pods, builds);
                    break;
                }
                case "Route": {
                    IRoute route = (IRoute)resource;
                    this.mapServicesToRoutes(this.getResourcesOf("Service"), Arrays.asList(route));
                    break;
                }
                case "Pod": {
                    IPod pod = (IPod)resource;
                    List<IPod> pods = Arrays.asList(pod);
                    Collection<IReplicationController> rcs = this.getResourcesOf("ReplicationController");
                    Collection<IDeploymentConfig> deployConfigs = this.getResourcesOf("DeploymentConfig");
                    Collection<IBuild> builds = this.getResourcesOf("Build");
                    this.mapPods(pods, rcs, deployConfigs, builds);
                    Map podLabels = pod.getLabels();
                    this.getResourcesOf("Service").stream().filter(s -> ResourceUtils.selectorsOverlap((Map)((IService)s).getSelector(), (Map)podLabels)).forEach(s -> this.createRelation((IResource)s, (IResource)pod));
                }
            }
            Collection<Deployment> deployments = this.findDeploymentsFor(resource);
            if (deployments != null && !deployments.isEmpty()) {
                for (Deployment deployment : deployments) {
                    deployment.add(resource);
                    this.mapResourceToDeployment(resource, deployment);
                }
            }
        }
        catch (Exception e) {
            OpenShiftUIActivator.getDefault().getLogger().logError((Throwable)e);
        }
    }

    public synchronized void remove(IResource resource) {
        try {
            Trace.debug((String)"Trying to remove resource to deployment {0}", (Object[])new Object[]{resource});
            if (!this.cache.containsKey(this.getCacheKey(resource))) {
                Trace.debug((String)"-->Returning early since dont know about {0}", (Object[])new Object[]{resource});
                return;
            }
            this.cache.put(this.getCacheKey(resource), resource);
            this.projectAdapter.remove(resource);
            String resourceKind = resource.getKind();
            Collection<Deployment> deployments = this.findDeploymentsFor(resource);
            if (deployments != null && !deployments.isEmpty()) {
                for (Deployment deployment : deployments) {
                    this.resourceToDeployments.remove(resource);
                    deployment.remove(resource);
                }
                if ("Service".equals(resourceKind)) {
                    deployments.forEach(d -> this.removeDeployment((Deployment)d));
                }
            }
            if (RELATIONSHIP_TYPE_MAP.containsKey(resourceKind)) {
                String[] stringArray = RELATIONSHIP_TYPE_MAP.get(resourceKind);
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String kind = stringArray[n2];
                    String left = this.getRelationKey(resource, kind);
                    if (this.relationMap.containsKey(left)) {
                        for (IResource target : this.relationMap.get(left)) {
                            String right = this.getRelationKey(target, resourceKind);
                            if (!this.relationMap.containsKey(right)) continue;
                            this.relationMap.get(right).remove(resource);
                        }
                        this.relationMap.remove(left);
                    }
                    ++n2;
                }
            }
            this.cache.remove(this.getCacheKey(resource));
        }
        catch (Exception e) {
            OpenShiftUIActivator.getDefault().getLogger().logError((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeDeployment(Deployment deployment) {
        Set<Deployment> set = this.deployments;
        synchronized (set) {
            if (this.deployments.contains(deployment)) {
                ArrayList<Deployment> old = new ArrayList<Deployment>(this.deployments);
                this.deployments.remove(deployment);
                this.firePropertyChange("deployments", old, new ArrayList<Deployment>(this.deployments));
            }
        }
    }

    public synchronized void update(IResource resource) {
        try {
            Trace.debug((String)"Trying to update resource for a deployment {0}", (Object[])new Object[]{resource});
            if (this.alreadyProcessedResource(resource)) {
                Trace.debug((String)"-->Returning early since already have this change: {0}", (Object[])new Object[]{resource});
            }
            this.projectAdapter.update(resource);
            this.cache.put(this.getCacheKey(resource), resource);
            Collection<Deployment> deployments = this.findDeploymentsFor(resource);
            if (deployments != null && !deployments.isEmpty()) {
                for (Deployment deployment : deployments) {
                    deployment.update(resource);
                    deployment.reconcile(resource, this);
                }
            }
        }
        catch (Exception e) {
            OpenShiftUIActivator.getDefault().getLogger().logError((Throwable)e);
        }
    }

    private boolean alreadyProcessedResource(IResource resource) {
        String cacheKey = this.getCacheKey(resource);
        return this.cache.containsKey(cacheKey) && Integer.parseInt(this.cache.get(cacheKey).getResourceVersion()) >= Integer.parseInt(resource.getResourceVersion());
    }

    public Deployment getDeploymentFor(IService service) {
        for (Deployment deployment : this.deployments) {
            IService deploymentService = deployment.getService();
            if (deploymentService == null || !deploymentService.equals(service)) continue;
            return deployment;
        }
        return null;
    }

    private Collection<Deployment> findDeploymentsFor(IResource resource) {
        block26: {
            String key;
            if (resource == null) break block26;
            Trace.debug((String)"Looking for deployment associated with: {0}", (Object[])new Object[]{resource});
            Collection<Deployment> deployments = this.getDeploymentsFor(resource);
            if (!deployments.isEmpty()) {
                return deployments;
            }
            String path = null;
            switch (resource.getKind()) {
                case "Build": {
                    path = "DeploymentConfig";
                    break;
                }
                case "BuildConfig": {
                    path = "Build";
                    break;
                }
                case "DeploymentConfig": {
                    path = "Service";
                    break;
                }
                case "ImageStream": {
                    path = "BuildConfig";
                    break;
                }
                case "ReplicationController": {
                    path = "Service";
                    break;
                }
                case "Pod": {
                    String cacheKey;
                    IPod pod = (IPod)resource;
                    if (pod.isAnnotatedWith("openshift.io/build.name")) {
                        cacheKey = this.getCacheKey(pod.getAnnotation("openshift.io/build.name"), "Build");
                        if (!this.cache.containsKey(cacheKey)) break;
                        return this.getDeploymentsFor(this.cache.get(cacheKey));
                    }
                    if (!pod.isAnnotatedWith("openshift.io/deployment.name") || !this.cache.containsKey(cacheKey = this.getCacheKey(pod.getAnnotation("openshift.io/deployment.name"), "ReplicationController"))) break;
                    return this.getDeploymentsFor(this.cache.get(cacheKey));
                }
            }
            if (path != null && this.relationMap.containsKey(key = this.getRelationKey(resource, path)) && this.relationMap.get(key) != null) {
                deployments = new HashSet<Deployment>();
                for (IResource relation : this.relationMap.get(key)) {
                    deployments.addAll(this.findDeploymentsFor(relation));
                }
                return deployments;
            }
        }
        return Collections.emptySet();
    }

    private Collection<Deployment> getDeploymentsFor(IResource resource) {
        if (this.resourceToDeployments.containsKey(resource)) {
            return new HashSet<Deployment>(this.resourceToDeployments.get(resource));
        }
        return Collections.emptySet();
    }

    private class ConnectionListener
    extends ConnectionsRegistryAdapter {
        private ConnectionListener() {
        }

        public void connectionChanged(IConnection connection, String property, Object oldValue, Object newValue) {
            if (!DeploymentResourceMapper.this.conn.equals((Object)connection)) {
                return;
            }
            if ("openshift.resource".equals(property)) {
                if (oldValue == null && newValue != null) {
                    this.handleChange((IResource)newValue, mapper -> DeploymentResourceMapper.this.add((IResource)mapper));
                } else if (oldValue != null && newValue == null) {
                    this.handleChange((IResource)oldValue, mapper -> DeploymentResourceMapper.this.remove((IResource)mapper));
                } else {
                    this.handleChange((IResource)newValue, mapper -> DeploymentResourceMapper.this.update((IResource)mapper));
                }
            }
        }

        private void handleChange(IResource resource, Consumer<IResource> action) {
            if (!DeploymentResourceMapper.this.project.getName().equals(resource.getNamespace())) {
                return;
            }
            action.accept(resource);
        }
    }

    private static enum State {
        UNINITIALIZED,
        LOADING,
        LOADED;

    }
}

