/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.models;

import com.openshift.restclient.model.IBuildConfig;
import com.openshift.restclient.model.IProject;
import com.openshift.restclient.model.IResource;
import com.openshift.restclient.model.IService;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IAdaptable;
import org.jboss.tools.openshift.internal.ui.models.IProjectAdapter;
import org.jboss.tools.openshift.internal.ui.models.IRelationCache;
import org.jboss.tools.openshift.internal.ui.models.IResourceUIModel;
import org.jboss.tools.openshift.internal.ui.models.ResourcesUIModel;

public class Deployment
extends ResourcesUIModel
implements IResourceUIModel,
IAdaptable {
    private final IService service;
    private final IProject project;
    private final Object grandParent;

    public Deployment(IService service, IProjectAdapter parent) {
        super(parent);
        this.service = service;
        this.project = parent.getProject();
        this.grandParent = parent.getParent();
    }

    public IService getService() {
        return this.service;
    }

    @Override
    public IResource getResource() {
        return this.getService();
    }

    @Override
    public Collection<IResourceUIModel> getServices() {
        return Collections.emptyList();
    }

    @Override
    public void setServices(Collection<IResourceUIModel> services) {
    }

    @Override
    public void setServiceResources(Collection<IResource> services) {
    }

    public void reconcile(IResource resource, IRelationCache cache) {
        Map labels;
        if ("Build".equals(resource.getKind()) && (labels = resource.getLabels()).containsKey("openshift.io/build-config.name")) {
            List names = this.getBuildConfigs().stream().map(bc -> bc.getResource().getName()).collect(Collectors.toList());
            Collection<IResource> buildConfigs = cache.getResourcesFor(resource, "BuildConfig");
            for (IResource bc2 : buildConfigs) {
                if (names.contains(bc2.getName())) continue;
                this.add(bc2);
            }
        }
    }

    public String toString() {
        return String.valueOf(this.service.getNamespace()) + "/" + this.service.getName();
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (IBuildConfig.class.equals(adapter)) {
            Collection<IResourceUIModel> buildConfigs = this.getBuildConfigs();
            if (buildConfigs.size() == 1) {
                return (T)buildConfigs.iterator().next().getResource();
            }
        } else if (IService.class.equals(adapter) || IResource.class.equals(adapter)) {
            return (T)this.getService();
        }
        return null;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.grandParent == null ? 0 : this.grandParent.hashCode());
        result = 31 * result + (this.project == null ? 0 : this.project.hashCode());
        result = 31 * result + (this.service == null ? 0 : this.service.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Deployment other = (Deployment)obj;
        if (this.grandParent == null ? other.grandParent != null : !this.grandParent.equals(other.grandParent)) {
            return false;
        }
        if (this.project == null ? other.project != null : !this.project.equals(other.project)) {
            return false;
        }
        return !(this.service == null ? other.service != null : !this.service.equals(other.service));
    }
}

