/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.job;

import com.openshift.restclient.OpenShiftException;
import com.openshift.restclient.model.IResource;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.jboss.tools.openshift.core.connection.Connection;

public class ResourceCreationJobUtils {
    private ResourceCreationJobUtils() {
    }

    public static IStatus createErrorStatusForExistingResources(Collection<IResource> resources) {
        final StringBuilder b = new StringBuilder("\nThe following resource names already exist:\n");
        for (IResource r : resources) {
            b.append("\n\"").append(r.getName()).append("\" ").append(r.getKind());
        }
        b.append("\n\nYou need to use different names or create this application in a different OpenShift project.");
        String message = String.valueOf(String.valueOf(resources.size())) + " resource name collisions found. ";
        return new Status(4, "org.jboss.tools.openshift.ui", message, new Throwable(){

            @Override
            public String getMessage() {
                return b.toString();
            }
        });
    }

    public static Collection<IResource> findExistingResources(Connection connection, Collection<IResource> resources) {
        ArrayList<IResource> existing = new ArrayList<IResource>(resources.size());
        for (IResource resource : resources) {
            try {
                IResource found = connection.getResource(resource);
                existing.add(found);
            }
            catch (OpenShiftException openShiftException) {}
        }
        return existing;
    }
}

