/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.job;

import com.openshift.restclient.OpenShiftException;
import com.openshift.restclient.capability.CapabilityVisitor;
import com.openshift.restclient.capability.resources.IPodLogRetrieval;
import com.openshift.restclient.model.IPod;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleListener;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import org.jboss.tools.openshift.internal.common.core.job.AbstractDelegatingMonitorJob;
import org.jboss.tools.openshift.internal.common.ui.OpenShiftCommonUIActivator;
import org.jboss.tools.openshift.internal.common.ui.console.ConsoleUtils;

public class PodLogsJob
extends AbstractDelegatingMonitorJob {
    private static final String DOCUMENT_IS_CLOSED = "Document is closed";
    private static final Map<IPod, ConsoleStreamPipe> REGISTRY = new HashMap<IPod, ConsoleStreamPipe>();
    private IPod pod;

    public PodLogsJob(IPod pod) {
        super("FollowPodLogsJob");
        this.pod = pod;
    }

    protected IStatus doRun(IProgressMonitor monitor) {
        try {
            monitor.worked(-1);
            if (REGISTRY.containsKey(this.pod)) {
                this.showConsole();
            } else {
                ConsoleStreamPipe pipe = (ConsoleStreamPipe)this.pod.accept((CapabilityVisitor)new CapabilityVisitor<IPodLogRetrieval, ConsoleStreamPipe>(){

                    public ConsoleStreamPipe visit(IPodLogRetrieval capability) {
                        ConsoleStreamPipe consoleStream = new ConsoleStreamPipe(capability);
                        new Thread(consoleStream).start();
                        return consoleStream;
                    }
                }, null);
                if (pipe != null) {
                    REGISTRY.put(this.pod, pipe);
                }
            }
        }
        finally {
            monitor.done();
        }
        return Status.OK_STATUS;
    }

    private MessageConsole showConsole() {
        MessageConsole console = ConsoleUtils.findMessageConsole((String)this.getMessageConsoleName());
        ConsoleUtils.displayConsoleView((IConsole)console);
        return console;
    }

    private String getMessageConsoleName() {
        return NLS.bind((String)"{0}\\{1} log", (Object)this.pod.getNamespace(), (Object)this.pod.getName());
    }

    private class ConsoleListener
    implements IConsoleListener {
        private ConsoleStreamPipe pipe;

        protected ConsoleListener(ConsoleStreamPipe pipe) {
            this.pipe = pipe;
        }

        public void consolesRemoved(IConsole[] consoles) {
            String messageConsoleName = PodLogsJob.this.getMessageConsoleName();
            IConsole[] iConsoleArray = consoles;
            int n = consoles.length;
            int n2 = 0;
            while (n2 < n) {
                IConsole console = iConsoleArray[n2];
                if (console.getName().equals(messageConsoleName)) {
                    try {
                        this.pipe.stop();
                        REGISTRY.remove(PodLogsJob.this.pod);
                        return;
                    }
                    finally {
                        ConsoleUtils.deregisterConsoleListener((IConsoleListener)this);
                    }
                }
                ++n2;
            }
        }

        public void consolesAdded(IConsole[] consoles) {
        }
    }

    private class ConsoleStreamPipe
    implements Runnable {
        private IPodLogRetrieval capability;
        private boolean running = true;

        ConsoleStreamPipe(IPodLogRetrieval capability) {
            this.capability = capability;
        }

        public void stop() {
            this.running = false;
            this.capability.stop();
        }

        @Override
        public void run() {
            block4: {
                ConsoleUtils.registerConsoleListener((IConsoleListener)new ConsoleListener(this));
                MessageConsole console = PodLogsJob.this.showConsole();
                MessageConsoleStream stream = console.newMessageStream();
                try {
                    int c;
                    BufferedInputStream logs = new BufferedInputStream(this.capability.getLogs(true));
                    while (this.running && (c = ((InputStream)logs).read()) != -1) {
                        if (stream.isClosed()) continue;
                        stream.write(c);
                    }
                }
                catch (OpenShiftException e) {
                    stream.println(e.getMessage());
                }
                catch (IOException e) {
                    if (PodLogsJob.DOCUMENT_IS_CLOSED.equals(e.getMessage())) break block4;
                    OpenShiftCommonUIActivator.log((String)"Exception reading pod log inputstream", (Throwable)e);
                }
            }
        }
    }
}

