/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.job;

import com.openshift.restclient.model.IProject;
import com.openshift.restclient.model.IResource;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.jboss.tools.openshift.common.core.connection.ConnectionsRegistrySingleton;
import org.jboss.tools.openshift.common.core.connection.IConnection;
import org.jboss.tools.openshift.core.connection.Connection;
import org.jboss.tools.openshift.core.connection.ConnectionsRegistryUtil;
import org.jboss.tools.openshift.internal.core.WatchManager;
import org.jboss.tools.openshift.internal.ui.job.DeleteResourceJob;

public class OpenShiftJobs {
    private OpenShiftJobs() {
    }

    public static DeleteResourceJob createDeleteProjectJob(final IProject project) {
        Assert.isNotNull((Object)project, (String)"A project must not be null");
        DeleteResourceJob deleteProjectJob = new DeleteResourceJob((IResource)project){

            @Override
            protected IStatus doRun(IProgressMonitor monitor) {
                Connection connection = ConnectionsRegistryUtil.getConnectionFor((IResource)project);
                WatchManager.getInstance().stopWatch(project);
                List oldProjects = connection.getResources("Project");
                IStatus status = super.doRun(monitor);
                if (status.isOK()) {
                    ArrayList newProjects = new ArrayList(oldProjects);
                    newProjects.remove(project);
                    ConnectionsRegistrySingleton.getInstance().fireConnectionChanged((IConnection)connection, "openshift.projects", (Object)oldProjects, newProjects);
                }
                return status;
            }
        };
        return deleteProjectJob;
    }
}

