/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.job;

import com.openshift.restclient.IResourceFactory;
import com.openshift.restclient.OpenShiftException;
import com.openshift.restclient.images.DockerImageURI;
import com.openshift.restclient.model.IDeploymentConfig;
import com.openshift.restclient.model.IImageStream;
import com.openshift.restclient.model.IProject;
import com.openshift.restclient.model.IResource;
import com.openshift.restclient.model.IService;
import com.openshift.restclient.model.deploy.IDeploymentImageChangeTrigger;
import com.openshift.restclient.model.route.IRoute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.openshift.core.connection.Connection;
import org.jboss.tools.openshift.internal.common.core.job.AbstractDelegatingMonitorJob;
import org.jboss.tools.openshift.internal.ui.OpenShiftUIActivator;
import org.jboss.tools.openshift.internal.ui.job.IResourcesModel;
import org.jboss.tools.openshift.internal.ui.job.ResourceCreationJobUtils;
import org.jboss.tools.openshift.internal.ui.wizard.common.EnvironmentVariable;
import org.jboss.tools.openshift.internal.ui.wizard.common.IResourceLabelsPageModel;
import org.jboss.tools.openshift.internal.ui.wizard.deployimage.IDeployImageParameters;

public class DeployImageJob
extends AbstractDelegatingMonitorJob
implements IResourcesModel {
    private static final String SELECTOR_KEY = "deploymentconfig";
    private IDeployImageParameters parameters;
    private Collection<IResource> created = Collections.emptyList();

    public DeployImageJob(IDeployImageParameters parameters) {
        super("Deploy Image Job");
        this.parameters = parameters;
    }

    @Override
    public Collection<IResource> getResources() {
        return this.created;
    }

    protected IStatus doRun(IProgressMonitor monitor) {
        try {
            Connection connection = (Connection)this.parameters.getConnection();
            IResourceFactory factory = connection.getResourceFactory();
            String name = this.parameters.getName();
            Map<String, IResource> resources = this.generateResources(factory, name);
            Collection<IResource> existing = ResourceCreationJobUtils.findExistingResources(connection, resources.values());
            if (!existing.isEmpty()) {
                return ResourceCreationJobUtils.createErrorStatusForExistingResources(existing);
            }
            this.created = this.createResources(connection, resources.values());
        }
        catch (Exception e) {
            return new Status(4, "org.jboss.tools.openshift.ui", NLS.bind((String)"Unable to create resources to deploy image '{0}'", (Object)this.parameters.getImage()), (Throwable)e);
        }
        return Status.OK_STATUS;
    }

    private Collection<IResource> createResources(Connection connection, Collection<IResource> resources) {
        ArrayList<IResource> created = new ArrayList<IResource>();
        for (IResource resource : resources) {
            OpenShiftUIActivator.getDefault().getLogger().logInfo(NLS.bind((String)"Trying to create resource: {0}", (Object)resource.toJson()));
            try {
                created.add(connection.createResource(resource));
            }
            catch (OpenShiftException e) {
                if (e.getStatus() != null) {
                    created.add((IResource)e.getStatus());
                    OpenShiftUIActivator.getDefault().getLogger().logError(NLS.bind((String)"Error creating resource: {0}", (Object)e.getStatus().toJson()));
                    continue;
                }
                throw e;
            }
        }
        return created;
    }

    private Map<String, IResource> generateResources(IResourceFactory factory, String name) {
        IProject project = this.parameters.getProject();
        DockerImageURI sourceImage = new DockerImageURI(this.parameters.getImage());
        DockerImageURI imageUri = new DockerImageURI(sourceImage.getUriWithoutHost());
        HashMap<String, IResource> resources = new HashMap<String, IResource>(4);
        resources.put("ImageStream", (IResource)this.stubImageStream(factory, name, project, imageUri));
        resources.put("Service", (IResource)this.stubService(factory, name, SELECTOR_KEY, name));
        if (this.parameters.isAddRoute()) {
            resources.put("Route", this.stubRoute(factory, name, ((IResource)resources.get("Service")).getName()));
        }
        resources.put("DeploymentConfig", this.stubDeploymentConfig(factory, name, imageUri));
        for (IResource resource : resources.values()) {
            this.addLabelsToResource(resource);
            resource.setAnnotation("openshift.io/generated-by", "jbosstools-openshift");
        }
        return resources;
    }

    private IResource stubDeploymentConfig(IResourceFactory factory, String name, DockerImageURI imageUri) {
        IDeploymentConfig dc = (IDeploymentConfig)factory.stub("DeploymentConfig", name, this.parameters.getProject().getName());
        dc.addLabel(SELECTOR_KEY, name);
        dc.addTemplateLabel(SELECTOR_KEY, name);
        for (IResourceLabelsPageModel.Label label : this.parameters.getLabels()) {
            dc.addTemplateLabel(label.getName(), label.getValue());
        }
        dc.setReplicas(this.parameters.getReplicas());
        dc.setReplicaSelector(SELECTOR_KEY, name);
        Map<String, String> envs = this.getModifiedEnvVars(this.parameters.getEnvironmentVariables(), this.parameters.getImageEnvVars());
        dc.addContainer(dc.getName(), new DockerImageURI(imageUri.getNameAndTag()), new HashSet(this.parameters.getPortSpecs()), envs, this.parameters.getVolumes());
        dc.addTrigger("ConfigChange");
        IDeploymentImageChangeTrigger imageChangeTrigger = (IDeploymentImageChangeTrigger)dc.addTrigger("ImageChange");
        imageChangeTrigger.setAutomatic(true);
        imageChangeTrigger.setContainerName(imageUri.getName());
        imageChangeTrigger.setFrom(new DockerImageURI(imageUri.getNameAndTag()));
        return dc;
    }

    private Map<String, String> getModifiedEnvVars(Collection<EnvironmentVariable> envVars, Map<String, String> dockerEnvVars) {
        HashMap<String, String> envs = new HashMap<String, String>();
        for (EnvironmentVariable var : this.parameters.getEnvironmentVariables()) {
            if (StringUtils.defaultIfEmpty((String)dockerEnvVars.get(var.getKey()), (String)"").equals(var.getValue())) continue;
            envs.put(var.getKey(), var.getValue());
        }
        return envs;
    }

    private IImageStream stubImageStream(IResourceFactory factory, String name, IProject project, DockerImageURI imageUri) {
        IImageStream imageStream = (IImageStream)factory.stub("ImageStream", name, this.parameters.getProject().getName());
        return imageStream;
    }

    private IResource stubRoute(IResourceFactory factory, String name, String serviceName) {
        IRoute route = (IRoute)factory.stub("Route", name, this.parameters.getProject().getName());
        route.setServiceName(serviceName);
        return route;
    }

    private IService stubService(IResourceFactory factory, String name, String selectorKey, String selectorValue) {
        IService service = (IService)factory.stub("Service", name, this.parameters.getProject().getName());
        service.setPorts(this.parameters.getServicePorts());
        service.setSelector(selectorKey, selectorValue);
        return service;
    }

    private void addLabelsToResource(IResource resource) {
        for (IResourceLabelsPageModel.Label label : this.parameters.getLabels()) {
            resource.addLabel(label.getName(), label.getValue());
        }
    }
}

