/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.job;

import com.openshift.restclient.IClient;
import com.openshift.restclient.OpenShiftException;
import com.openshift.restclient.capability.CapabilityVisitor;
import com.openshift.restclient.capability.resources.IClientCapability;
import com.openshift.restclient.capability.resources.IProjectTemplateProcessing;
import com.openshift.restclient.model.IProject;
import com.openshift.restclient.model.IResource;
import com.openshift.restclient.model.template.IParameter;
import com.openshift.restclient.model.template.ITemplate;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.jboss.tools.openshift.internal.common.core.job.AbstractDelegatingMonitorJob;
import org.jboss.tools.openshift.internal.ui.job.IResourcesModel;
import org.jboss.tools.openshift.internal.ui.job.ResourceCreationJobUtils;
import org.jboss.tools.openshift.internal.ui.wizard.common.IResourceLabelsPageModel;

public class CreateApplicationFromTemplateJob
extends AbstractDelegatingMonitorJob
implements IResourcesModel {
    private IProject project;
    private ITemplate template;
    private Collection<IResourceLabelsPageModel.Label> labels;
    private Collection<IParameter> parameters;
    private Collection<IResource> resources;

    public CreateApplicationFromTemplateJob(IProject project, ITemplate template, Collection<IParameter> parameters, Collection<IResourceLabelsPageModel.Label> labels) {
        super("Create Application From Template Job");
        this.project = project;
        this.template = template;
        this.labels = labels;
        this.parameters = parameters;
    }

    protected IStatus doRun(IProgressMonitor monitor) {
        this.template.updateParameterValues(this.parameters);
        for (IResourceLabelsPageModel.Label label : this.labels) {
            this.template.addObjectLabel(label.getName(), label.getValue());
        }
        IStatus status = (IStatus)this.project.accept((CapabilityVisitor)new CapabilityVisitor<IProjectTemplateProcessing, IStatus>(){

            public IStatus visit(IProjectTemplateProcessing capability) {
                try {
                    ITemplate processed = capability.process(CreateApplicationFromTemplateJob.this.template);
                    Collection existing = CreateApplicationFromTemplateJob.this.findExistingResources(CreateApplicationFromTemplateJob.this.project, processed);
                    if (!existing.isEmpty()) {
                        return ResourceCreationJobUtils.createErrorStatusForExistingResources(existing);
                    }
                    CreateApplicationFromTemplateJob.this.parameters = processed.getParameters().values();
                    CreateApplicationFromTemplateJob.this.resources = capability.apply(processed);
                    return CreateApplicationFromTemplateJob.this.handleResponse(CreateApplicationFromTemplateJob.this.resources);
                }
                catch (OpenShiftException e) {
                    String message = e.getMessage();
                    if (e.getStatus() != null) {
                        message = e.getStatus().getMessage();
                    }
                    return new Status(4, "org.jboss.tools.openshift.ui", -1, message, (Throwable)e);
                }
            }
        }, (Object)new Status(4, "org.jboss.tools.openshift.ui", "Template processing is unsupported for this client and server combination.", null));
        return status;
    }

    private Collection<IResource> findExistingResources(final IProject project, final ITemplate template) {
        return (Collection)project.accept((CapabilityVisitor)new CapabilityVisitor<IClientCapability, Collection<IResource>>(){

            public Collection<IResource> visit(IClientCapability capability) {
                IClient client = capability.getClient();
                ArrayList<IResource> existing = new ArrayList<IResource>(template.getItems().size());
                for (IResource resource : template.getItems()) {
                    try {
                        IResource found = client.get(resource.getKind(), resource.getName(), project.getName());
                        existing.add(found);
                    }
                    catch (OpenShiftException openShiftException) {}
                }
                return existing;
            }
        }, new ArrayList());
    }

    public Collection<IParameter> getParameters() {
        return this.parameters;
    }

    @Override
    public Collection<IResource> getResources() {
        return this.resources;
    }

    private IStatus handleResponse(Collection<IResource> resources) {
        int severity = 0;
        for (IResource resource : resources) {
            if (resource.getKind() != "Status") continue;
            severity = 2;
            break;
        }
        return new Status(severity, "org.jboss.tools.openshift.ui", 0, "Resources created from template.", null);
    }
}

