/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.handler;

import com.openshift.restclient.model.IBuild;
import com.openshift.restclient.model.IBuildConfig;
import com.openshift.restclient.model.IResource;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jboss.tools.openshift.core.connection.Connection;
import org.jboss.tools.openshift.core.connection.ConnectionsRegistryUtil;
import org.jboss.tools.openshift.internal.common.ui.utils.UIUtils;
import org.jboss.tools.openshift.internal.ui.OpenShiftUIActivator;
import org.jboss.tools.openshift.internal.ui.job.StartBuildJob;
import org.jboss.tools.openshift.internal.ui.models.IResourceUIModel;

public class StartBuildHandler
extends AbstractHandler {
    private static final String SOURCE = "org.jboss.tools.openshift.ui.command.startbuild.source";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getActivePart((ExecutionEvent)event).getSite().getWorkbenchWindow().getSelectionService().getSelection();
        IResource buildAble = this.getBuildableResource(selection, event.getParameter(SOURCE));
        if (buildAble == null) {
            MessageDialog.openInformation((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)"Trigger Build", (String)"A build or build config must be selected in order to trigger a build.");
            return null;
        }
        new StartBuildJob(buildAble).schedule();
        return null;
    }

    public IResource getBuildableResource(ISelection selection, String source) {
        IResource buildAble = null;
        IAdaptable adaptable = (IAdaptable)UIUtils.getFirstElement((ISelection)selection, IAdaptable.class);
        if (adaptable != null && (buildAble = (IResource)adaptable.getAdapter(IBuildConfig.class)) == null) {
            buildAble = (IResource)adaptable.getAdapter(IBuild.class);
        }
        if (buildAble == null && adaptable instanceof IResourceUIModel) {
            buildAble = ((IResourceUIModel)adaptable).getResource();
        }
        if (buildAble == null) {
            buildAble = (IResource)UIUtils.getFirstElement((ISelection)selection, IResource.class);
        }
        if (this.isStartingFromABuild(buildAble, source)) {
            buildAble = this.loadBuildConfig(buildAble);
        }
        return buildAble;
    }

    private boolean isStartingFromABuild(IResource resource, String source) {
        return resource != null && "BuildConfig".equals(source) && "Build".equals(resource.getKind());
    }

    private IResource loadBuildConfig(IResource build) {
        Connection connection = ConnectionsRegistryUtil.safeGetConnectionFor((IResource)build);
        String buildConfigName = (String)build.getLabels().get("openshift.io/build-config.name");
        if (!buildConfigName.isEmpty()) {
            IResource proto = connection.getResourceFactory().stub("BuildConfig", buildConfigName, build.getNamespace());
            return connection.getResource(proto);
        }
        OpenShiftUIActivator.getDefault().getLogger().logInfo("Unable to determine associated BuildConfig from Build: " + build.toJson());
        return null;
    }
}

