/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.handler;

import com.openshift.restclient.model.IProject;
import com.openshift.restclient.model.route.IRoute;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jboss.tools.foundation.ui.util.BrowserUtility;
import org.jboss.tools.openshift.common.core.connection.IConnection;
import org.jboss.tools.openshift.internal.common.ui.job.UIUpdatingJob;
import org.jboss.tools.openshift.internal.common.ui.utils.UIUtils;
import org.jboss.tools.openshift.internal.ui.OpenShiftUIActivator;
import org.jboss.tools.openshift.internal.ui.dialog.SelectRouteDialog;
import org.jboss.tools.openshift.internal.ui.models.Deployment;

public class OpenInWebBrowserHandler
extends AbstractHandler {
    private static final String NO_ROUTE_MSG = "Could not find a route that points to an url to show in a browser.";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        ISelection currentSelection = HandlerUtil.getActivePart((ExecutionEvent)event).getSite().getWorkbenchWindow().getSelectionService().getSelection();
        IRoute route = (IRoute)UIUtils.getFirstElement((ISelection)currentSelection, IRoute.class);
        if (route != null) {
            return this.openBrowser(shell, route);
        }
        final Deployment deployment = (Deployment)UIUtils.getFirstElement((ISelection)currentSelection, Deployment.class);
        if (deployment != null) {
            new RouteOpenerJob(this, deployment.getService().getNamespace(), shell){

                protected IStatus run(IProgressMonitor monitor) {
                    this.routes = deployment.getRoutes().stream().map(r -> (IRoute)r.getResource()).collect(Collectors.toList());
                    return Status.OK_STATUS;
                }
            }.schedule();
            return Status.OK_STATUS;
        }
        final IProject project = (IProject)UIUtils.getFirstElement((ISelection)currentSelection, IProject.class);
        if (project != null) {
            new RouteOpenerJob(this, project.getName(), shell){

                protected IStatus run(IProgressMonitor monitor) {
                    this.routes = project.getResources("Route");
                    return Status.OK_STATUS;
                }
            }.schedule();
            return Status.OK_STATUS;
        }
        IConnection connection = (IConnection)UIUtils.getFirstElement((ISelection)currentSelection, IConnection.class);
        if (connection != null) {
            return this.openBrowser(shell, connection.getHost());
        }
        return this.nothingToOpenDialog(shell);
    }

    private IStatus nothingToOpenDialog(Shell shell) {
        MessageDialog.openWarning((Shell)shell, (String)"No Route", (String)NO_ROUTE_MSG);
        return OpenShiftUIActivator.statusFactory().cancelStatus(NO_ROUTE_MSG);
    }

    protected IStatus openBrowser(Shell shell, IRoute route) {
        if (route == null) {
            return this.nothingToOpenDialog(shell);
        }
        return this.openBrowser(shell, route.getURL());
    }

    protected IStatus openBrowser(Shell shell, String url) {
        if (StringUtils.isBlank((String)url)) {
            return this.nothingToOpenDialog(shell);
        }
        new BrowserUtility().checkedCreateInternalBrowser(url, "", "org.jboss.tools.openshift.ui", OpenShiftUIActivator.getDefault().getLog());
        return Status.OK_STATUS;
    }

    private abstract class RouteOpenerJob
    extends UIUpdatingJob {
        protected List<IRoute> routes;
        private Shell shell;

        public RouteOpenerJob(String projectName, Shell shell) {
            super(NLS.bind((String)"Loading routes for project {0}", (Object)projectName));
            this.shell = shell;
        }

        protected IStatus updateUI(IProgressMonitor monitor) {
            if (this.routes == null || this.routes.isEmpty()) {
                return OpenInWebBrowserHandler.this.nothingToOpenDialog(this.shell);
            }
            if (this.routes.size() == 1) {
                return OpenInWebBrowserHandler.this.openBrowser(this.shell, this.routes.get(0));
            }
            SelectRouteDialog routeDialog = new SelectRouteDialog(this.routes, this.shell);
            if (routeDialog.open() == 0) {
                return OpenInWebBrowserHandler.this.openBrowser(this.shell, routeDialog.getSelectedRoute());
            }
            return Status.OK_STATUS;
        }
    }
}

