/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.handler;

import com.openshift.restclient.model.IProject;
import com.openshift.restclient.model.IResource;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jboss.tools.common.ui.WizardUtils;
import org.jboss.tools.openshift.core.connection.Connection;
import org.jboss.tools.openshift.core.connection.ConnectionsRegistryUtil;
import org.jboss.tools.openshift.internal.common.ui.utils.UIUtils;
import org.jboss.tools.openshift.internal.ui.OpenShiftUIActivator;
import org.jboss.tools.openshift.internal.ui.wizard.project.NewProjectWizard;

public class NewProjectHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IProject project;
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        Connection connection = (Connection)UIUtils.getFirstElement((ISelection)selection, Connection.class);
        if (connection == null && (project = (IProject)UIUtils.getFirstElement((ISelection)selection, IProject.class)) != null) {
            connection = ConnectionsRegistryUtil.getConnectionFor((IResource)project);
        }
        if (connection == null) {
            return OpenShiftUIActivator.statusFactory().cancelStatus("No connection selected");
        }
        this.openNewProjectDialog(connection, HandlerUtil.getActiveShell((ExecutionEvent)event));
        return null;
    }

    private void openNewProjectDialog(final Connection connection, final Shell shell) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                List oldProjects = connection.getResources("Project");
                WizardUtils.openWizardDialog((IWizard)new NewProjectWizard(connection, oldProjects), (Shell)shell);
            }
        });
    }
}

