/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.handler;

import com.openshift.restclient.model.IProject;
import com.openshift.restclient.model.IResource;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerImage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jboss.tools.common.ui.WizardUtils;
import org.jboss.tools.openshift.core.connection.Connection;
import org.jboss.tools.openshift.core.connection.ConnectionsRegistryUtil;
import org.jboss.tools.openshift.internal.common.ui.utils.UIUtils;
import org.jboss.tools.openshift.internal.ui.wizard.deployimage.DeployImageWizard;
import org.jboss.tools.openshift.internal.ui.wizard.deployimage.DeployImageWizardModel;

public class DeployImageHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        DeployImageWizardModel model = new DeployImageWizardModel();
        ISelection selection = HandlerUtil.getActivePart((ExecutionEvent)event).getSite().getWorkbenchWindow().getSelectionService().getSelection();
        IDockerImage image = (IDockerImage)UIUtils.getFirstElement((ISelection)selection, IDockerImage.class);
        if (image != null) {
            IDockerConnection dockerConnection = image.getConnection();
            model.setOriginatedFromDockerExplorer(true);
            model.setDockerConnection(dockerConnection);
            model.setImage(image.repo());
        } else {
            IProject project = (IProject)UIUtils.getFirstElement((ISelection)selection, IProject.class);
            if (project != null) {
                model.initModel(ConnectionsRegistryUtil.getConnectionFor((IResource)project), project);
            } else {
                Connection osConnection = (Connection)UIUtils.getFirstElement((ISelection)selection, Connection.class);
                if (osConnection != null) {
                    model.setConnection(osConnection);
                }
            }
        }
        WizardUtils.openWizardDialog((int)600, (int)1500, (IWizard)new DeployImageWizard(model), (Shell)HandlerUtil.getActiveShell((ExecutionEvent)event));
        return null;
    }
}

