/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.handler;

import com.openshift.restclient.model.IResource;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jboss.tools.openshift.internal.common.ui.utils.UIUtils;
import org.jboss.tools.openshift.internal.ui.job.DeleteResourceJob;
import org.jboss.tools.openshift.internal.ui.models.IResourceUIModel;

public class DeleteResourceHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IResourceUIModel model;
        ISelection selection = HandlerUtil.getActivePart((ExecutionEvent)event).getSite().getWorkbenchWindow().getSelectionService().getSelection();
        IResource resource = (IResource)UIUtils.getFirstElement((ISelection)selection, IResource.class);
        if (resource == null && (model = (IResourceUIModel)UIUtils.getFirstElement((ISelection)selection, IResourceUIModel.class)) != null) {
            resource = model.getResource();
        }
        if (resource == null) {
            return Status.OK_STATUS;
        }
        if (MessageDialog.openQuestion((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)"Delete Resource", (String)NLS.bind((String)"Are you certain you want to delete the {0} resource named {1}?", (Object)resource.getKind(), (Object)resource.getName()))) {
            new DeleteResourceJob(resource).schedule();
            return Status.OK_STATUS;
        }
        return Status.CANCEL_STATUS;
    }
}

