/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.explorer;

import com.openshift.restclient.OpenShiftException;
import com.openshift.restclient.model.IBuild;
import com.openshift.restclient.model.IProject;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.list.ListDiff;
import org.eclipse.core.databinding.observable.list.ListDiffVisitor;
import org.jboss.tools.openshift.common.core.connection.ConnectionsRegistry;
import org.jboss.tools.openshift.common.core.connection.IConnection;
import org.jboss.tools.openshift.core.connection.Connection;
import org.jboss.tools.openshift.internal.common.ui.explorer.BaseExplorerContentProvider;
import org.jboss.tools.openshift.internal.core.Trace;
import org.jboss.tools.openshift.internal.ui.models.Deployment;
import org.jboss.tools.openshift.internal.ui.models.IAncestorable;
import org.jboss.tools.openshift.internal.ui.models.IProjectAdapter;
import org.jboss.tools.openshift.internal.ui.models.IResourceUIModel;
import org.jboss.tools.openshift.internal.ui.models.OpenShiftProjectUIModel;

public class OpenShiftExplorerContentProvider
extends BaseExplorerContentProvider
implements PropertyChangeListener {
    private static final List<String> TERMINATED_STATUS = Arrays.asList("Complete", "Failed", "Error", "Cancelled");
    private Map<String, IProjectAdapter> projectCache = new HashMap<String, IProjectAdapter>();

    protected void handleConnectionChanged(IConnection connection, String property, Object oldValue, Object newValue) {
        if (!(connection instanceof Connection)) {
            return;
        }
        if ("openshift.projects".equals(property)) {
            this.handleProjectChanges((Connection)connection, oldValue, newValue);
        } else if ("openshift.resource.refresh".equals(property)) {
            this.refreshViewer(newValue);
        }
    }

    private void handleProjectChanges(final Connection connection, Object oldValue, Object newValue) {
        List newProjects = (List)newValue;
        List oldProjects = (List)oldValue;
        final ArrayList added = new ArrayList();
        final ArrayList removed = new ArrayList();
        ListDiff diffs = Diffs.computeListDiff((List)oldProjects, (List)newProjects);
        diffs.accept(new ListDiffVisitor(){

            public void handleRemove(int index, Object element) {
                IProject project = (IProject)element;
                if (project != null) {
                    String key = OpenShiftExplorerContentProvider.this.getCacheKey(connection, project);
                    if (OpenShiftExplorerContentProvider.this.projectCache.containsKey(key)) {
                        removed.add((IProjectAdapter)OpenShiftExplorerContentProvider.this.projectCache.remove(key));
                    }
                }
            }

            public void handleAdd(int index, Object element) {
                added.add(OpenShiftExplorerContentProvider.this.newProjectAdapter(connection, (IProject)element));
            }
        });
        removed.forEach(r -> this.removeChildrenFromViewer(connection, new Object[]{r}));
        added.forEach(a -> this.addChildrenToViewer(connection, new Object[]{a}));
    }

    protected void handleConnectionRemoved(IConnection connection) {
        super.handleConnectionRemoved(connection);
    }

    public Object[] getExplorerElements(Object parentElement) {
        if (parentElement instanceof ConnectionsRegistry) {
            ConnectionsRegistry registry = (ConnectionsRegistry)parentElement;
            return registry.getAll(Connection.class).toArray();
        }
        if (parentElement instanceof Connection) {
            return ((Connection)parentElement).getResources("Project").toArray();
        }
        return new Object[0];
    }

    public Object[] getChildrenFor(Object parentElement) {
        try {
            if (parentElement instanceof Connection) {
                Connection connection = (Connection)parentElement;
                List projects = connection.getResources("Project");
                ArrayList<IProjectAdapter> children = new ArrayList<IProjectAdapter>();
                for (IProject project : projects) {
                    children.add(this.newProjectAdapter(connection, project));
                }
                return children.toArray();
            }
            if (parentElement instanceof IProjectAdapter) {
                IProjectAdapter adapter = (IProjectAdapter)parentElement;
                Connection conn = (Connection)adapter.getParent();
                IProject project = adapter.getProject();
                ArrayList<Deployment> deployments = new ArrayList<Deployment>(this.projectCache.get(this.getCacheKey(conn, project)).getDeployments());
                for (Deployment deployment : deployments) {
                    this.addDeploymentListeners(deployment);
                }
                return deployments.toArray();
            }
            if (parentElement instanceof Deployment) {
                Deployment deployment = (Deployment)parentElement;
                return this.handleDeployment(deployment).toArray();
            }
        }
        catch (OpenShiftException e) {
            this.addException(parentElement, (Exception)((Object)e));
        }
        return new Object[0];
    }

    private Collection<IResourceUIModel> handleDeployment(Deployment deployment) {
        Collection models = deployment.getBuilds().stream().filter(b -> !this.isTerminatedBuild((IBuild)b.getResource())).collect(Collectors.toList());
        models.addAll(deployment.getPods().stream().filter(p -> !this.isBuildPod((IResourceUIModel)p)).collect(Collectors.toList()));
        return models;
    }

    private boolean isTerminatedBuild(IBuild build) {
        String phase = build.getStatus();
        return TERMINATED_STATUS.contains(phase);
    }

    private boolean isBuildPod(IResourceUIModel pod) {
        return pod.getResource().isAnnotatedWith("openshift.io/build.name");
    }

    private IProjectAdapter newProjectAdapter(Connection connection, IProject project) {
        OpenShiftProjectUIModel model = new OpenShiftProjectUIModel(connection, project);
        model.addPropertyChangeListener("deployments", this);
        this.projectCache.put(this.getCacheKey(connection, project), model);
        return model;
    }

    private String getCacheKey(Connection connection, IProject project) {
        return String.valueOf(connection.toString()) + "/" + project.getName();
    }

    public Object getParent(Object element) {
        if (element instanceof IAncestorable) {
            return ((IAncestorable)element).getParent();
        }
        return null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        Object oldValue = event.getOldValue();
        Object newValue = event.getNewValue();
        if (oldValue instanceof List && newValue instanceof List) {
            Object parent;
            List oldList = (List)oldValue;
            List newList = (List)newValue;
            ListDiff diffs = Diffs.computeListDiff((List)oldList, (List)newList);
            final ArrayList removed = new ArrayList();
            final ArrayList added = new ArrayList();
            diffs.accept(new ListDiffVisitor(){

                public void handleRemove(int index, Object element) {
                    removed.add(element);
                }

                public void handleAdd(int index, Object element) {
                    if (element instanceof IResourceUIModel) {
                        IResourceUIModel model = (IResourceUIModel)element;
                        if ("Build".equals(model.getResource().getKind()) && OpenShiftExplorerContentProvider.this.isTerminatedBuild((IBuild)model.getResource())) {
                            return;
                        }
                        if ("Pod".equals(model.getResource().getKind()) && OpenShiftExplorerContentProvider.this.isBuildPod(model)) {
                            return;
                        }
                    }
                    added.add(element);
                }
            });
            for (Object child : removed) {
                parent = this.getParent(child);
                Trace.debug((String)"Explorer remove: parent: {0} / child: {1}", (Object[])new Object[]{parent, child});
                this.removeChildrenFromViewer(parent, new Object[]{child});
                if (child instanceof Deployment) {
                    this.removeDeploymentListeners((Deployment)child);
                }
                if (!(child instanceof IResourceUIModel) || !"Route".equals(((IResourceUIModel)child).getResource().getKind())) continue;
                this.updateChildrenFromViewer(new Object[]{parent});
            }
            for (Object child : added) {
                parent = this.getParent(child);
                Trace.debug((String)"Explorer add: parent: {0} / child: {1}", (Object[])new Object[]{parent, child});
                if (child instanceof Deployment) {
                    Deployment deployment = (Deployment)child;
                    this.addDeploymentListeners(deployment);
                }
                if (child instanceof IResourceUIModel && "Route".equals(((IResourceUIModel)child).getResource().getKind())) {
                    this.updateChildrenFromViewer(new Object[]{parent});
                }
                if (parent instanceof IProjectAdapter && oldList.size() == 0 && newList.size() > 0) {
                    IProjectAdapter project = (IProjectAdapter)parent;
                    this.refreshViewer(project);
                    continue;
                }
                this.addChildrenToViewer(parent, new Object[]{child});
            }
        }
    }

    private void addDeploymentListeners(Deployment deployment) {
        deployment.addPropertyChangeListener("pods", this);
        deployment.addPropertyChangeListener("builds", this);
        deployment.addPropertyChangeListener("routes", this);
    }

    private void removeDeploymentListeners(Deployment deployment) {
        deployment.removePropertyChangeListener("pods", this);
        deployment.removePropertyChangeListener("builds", this);
        deployment.removePropertyChangeListener("routes", this);
    }

    public boolean hasChildren(Object element) {
        return element instanceof ConnectionsRegistry || element instanceof IConnection || element instanceof IProjectAdapter || element instanceof Deployment;
    }
}

