/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.dialog;

import com.openshift.restclient.model.IResource;
import com.openshift.restclient.model.route.IRoute;
import java.util.List;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.jboss.tools.openshift.common.core.utils.StringUtils;
import org.jboss.tools.openshift.core.connection.Connection;
import org.jboss.tools.openshift.core.connection.ConnectionsRegistryUtil;
import org.jboss.tools.openshift.internal.common.ui.OpenShiftCommonImages;

public class SelectRouteDialog
extends ElementListSelectionDialog {
    public SelectRouteDialog(List<IRoute> routes, Shell shell) {
        super(shell, (ILabelProvider)new RouteLabelProvider());
        this.setTitle("Select Route");
        this.setMessage(this.createMessage(routes));
        this.setMultipleSelection(false);
        this.setAllowDuplicates(false);
        this.setElements(routes.toArray());
    }

    private String createMessage(List<IRoute> routes) {
        StringBuilder message = new StringBuilder();
        if (!routes.isEmpty()) {
            IRoute route = routes.get(0);
            Connection connection = ConnectionsRegistryUtil.safeGetConnectionFor((IResource)route);
            if (connection != null) {
                message.append("Server: ").append(connection.getUsername()).append(" ").append(connection.getHost()).append(StringUtils.getLineSeparator());
            }
            message.append("Project: ").append(route.getNamespace()).append(StringUtils.getLineSeparator());
            message.append(StringUtils.getLineSeparator());
        }
        message.append("Select the route to open in a browser.");
        return message.toString();
    }

    public IRoute getSelectedRoute() {
        Object[] results = this.getResult();
        if (results == null || results.length < 1) {
            return null;
        }
        return (IRoute)results[0];
    }

    private static class RouteLabelProvider
    extends LabelProvider {
        private RouteLabelProvider() {
        }

        public Image getImage(Object element) {
            return OpenShiftCommonImages.FILE;
        }

        public String getText(Object element) {
            if (!(element instanceof IRoute)) {
                return null;
            }
            IRoute route = (IRoute)element;
            return route.getName() + " (" + route.getHost() + route.getPath() + ")";
        }
    }
}

