/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.dialog;

import com.openshift.restclient.model.IResource;
import java.util.Collection;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.jboss.tools.openshift.internal.common.ui.OpenShiftCommonImages;
import org.jboss.tools.openshift.internal.ui.dialog.ResourceSummaryContentProvider;
import org.jboss.tools.openshift.internal.ui.dialog.ResourceSummaryLabelProvider;

public class ResourceSummaryDialog
extends TitleAreaDialog {
    private Collection<IResource> resources;
    private String message;
    private String dialogTitle;
    private DelegatingStyledCellLabelProvider.IStyledLabelProvider labelProvider;
    private ITreeContentProvider contentProvider;

    public ResourceSummaryDialog(Shell parentShell, Collection<IResource> resources, String dialogTitle, String message) {
        this(parentShell, resources, dialogTitle, message, new ResourceSummaryLabelProvider(), new ResourceSummaryContentProvider());
    }

    public ResourceSummaryDialog(Shell parentShell, Collection<IResource> resources, String dialogTitle, String message, DelegatingStyledCellLabelProvider.IStyledLabelProvider labelProvider, ITreeContentProvider contetProvider) {
        super(parentShell);
        this.dialogTitle = dialogTitle;
        this.resources = resources;
        this.message = message;
        this.labelProvider = labelProvider;
        this.contentProvider = contetProvider;
        this.setHelpAvailable(false);
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.setupDialog(parent);
        return control;
    }

    protected Control createDialogArea(Composite parent) {
        Label titleSeparator = new Label(parent, 258);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)titleSeparator);
        Composite dialogArea = new Composite(parent, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)dialogArea);
        GridLayoutFactory.fillDefaults().margins(10, 10).applyTo(dialogArea);
        TreeViewer viewer = this.createTable(dialogArea);
        viewer.setInput(this.resources);
        this.createAreaAfterResourceSummary(parent);
        Label buttonsSeparator = new Label(parent, 258);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)buttonsSeparator);
        return dialogArea;
    }

    protected void createAreaAfterResourceSummary(Composite parent) {
    }

    private TreeViewer createTable(Composite parent) {
        Composite tableContainer = new Composite(parent, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).hint(400, 150).applyTo((Control)tableContainer);
        TreeColumnLayout treeLayout = new TreeColumnLayout();
        tableContainer.setLayout((Layout)treeLayout);
        TreeViewer viewer = new TreeViewer(tableContainer, 2816);
        viewer.setContentProvider((IContentProvider)this.contentProvider);
        viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        return viewer;
    }

    private void setupDialog(Composite parent) {
        parent.getShell().setText(this.dialogTitle);
        this.setTitle(this.message);
        this.setTitleImage(OpenShiftCommonImages.OPENSHIFT_LOGO_WHITE_MEDIUM_IMG);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }
}

