/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ui.utils;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Throwables;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closeables;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.google.common.io.InputSupplier;
import com.google.common.io.OutputSupplier;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.FileFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jdt.annotation.Nullable;

public class Zips {
    public static ZipFile NULL() {
        try {
            File tmp = File.createTempFile("recommenders_null_zip", ".zip");
            ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(tmp));
            zos.putNextEntry(new ZipEntry("/"));
            zos.closeEntry();
            zos.close();
            return new ZipFile(tmp);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static void unzip(File zipFile, File destFolder) throws IOException {
        ZipInputStream zis = null;
        try {
            ZipEntry entry;
            zis = new ZipInputStream(new FileInputStream(zipFile));
            while ((entry = zis.getNextEntry()) != null) {
                if (entry.isDirectory()) continue;
                File file = new File(destFolder, entry.getName());
                Files.createParentDirs((File)file);
                Files.asByteSink((File)file, (FileWriteMode[])new FileWriteMode[]{FileWriteMode.APPEND}).writeFrom((InputStream)zis);
            }
        }
        catch (Throwable throwable) {
            Closeables.close(zis, (boolean)true);
            throw throwable;
        }
        Closeables.close((Closeable)zis, (boolean)true);
    }

    public static void zip(File directory, File out) throws IOException {
        ZipOutputStream zos = null;
        try {
            OutputSupplier s = Files.newOutputStreamSupplier((File)out);
            zos = new ZipOutputStream((OutputStream)s.getOutput());
            for (File f : FileUtils.listFiles((File)directory, (IOFileFilter)FileFileFilter.FILE, (IOFileFilter)DirectoryFileFilter.DIRECTORY)) {
                String path = StringUtils.removeStart((String)f.getPath(), (String)(String.valueOf(directory.getAbsolutePath()) + File.separator));
                path = path.replace(File.separatorChar, '/');
                ZipEntry e = new ZipEntry(path);
                zos.putNextEntry(e);
                Files.asByteSource((File)f).copyTo((OutputStream)zos);
                zos.closeEntry();
            }
        }
        catch (Throwable throwable) {
            Closeables.close(zos, (boolean)false);
            throw throwable;
        }
        Closeables.close((Closeable)zos, (boolean)false);
    }

    public static byte[] readFully(File file) throws IOException {
        return ByteStreams.toByteArray((InputSupplier)Files.newInputStreamSupplier((File)file));
    }

    public static boolean closeQuietly(@Nullable ZipFile z) {
        if (z == null) {
            return true;
        }
        try {
            z.close();
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static class DefaultJarFileConverter
    implements IFileToJarFileConverter {
        @Override
        public Optional<JarFile> createJarFile(File file) {
            try {
                return Optional.of((Object)new JarFile(file));
            }
            catch (IOException iOException) {
                return Optional.absent();
            }
        }
    }

    @VisibleForTesting
    public static interface IFileToJarFileConverter {
        public Optional<JarFile> createJarFile(File var1);
    }
}

