/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ui.utils;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.epp.internal.logging.aeri.ui.model.IServer;
import org.eclipse.epp.internal.logging.aeri.ui.model.ProblemStatus;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.window.DefaultToolTip;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class UI {
    private static final Point TOOLTIP_DISPLACEMENT = new Point(5, 20);
    private static final int TOOLTIP_HIDE_DELAY = (int)TimeUnit.SECONDS.toMillis(20L);

    public static Image decorate(@Nullable IServer server, @Nullable ProblemStatus status, @Nullable ImageRegistry registry) {
        if (UI.isAnyNull(new Object[]{server, status, registry})) {
            return ImageDescriptor.getMissingImageDescriptor().createImage();
        }
        String decoImageId = null;
        switch (status) {
            case NEW: {
                decoImageId = "icons/ovr16/bllt-grn-pls.png";
                break;
            }
            case UNCONFIRMED: {
                decoImageId = "icons/ovr16/qstn-mrk.png";
                break;
            }
            case CONFIRMED: {
                decoImageId = "icons/ovr16/tck-bl.png";
                break;
            }
            case NEEDINFO: {
                decoImageId = "icons/ovr16/wrnng.png";
                break;
            }
            case FIXED: {
                decoImageId = "icons/ovr16/tck-grn.png";
                break;
            }
            case IGNORED: {
                decoImageId = "icons/ovr16/tck-grn.png";
                break;
            }
            case INVALID: {
                decoImageId = "icons/ovr16/bllt-gr.png";
                break;
            }
            case FAILURE: {
                decoImageId = "icons/ovr16/xclmtn-mrk.png";
            }
        }
        String imageId = String.valueOf(server.getId()) + "-" + decoImageId;
        Image image = registry.get(imageId);
        if (image == null) {
            Image baseImage = server.getImage16();
            ImageDescriptor overlayDesc = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.epp.logging.aeri.ui", (String)decoImageId);
            ImageDescriptor[] imageDescriptorArray = new ImageDescriptor[5];
            imageDescriptorArray[1] = overlayDesc;
            DecorationOverlayIcon decoratedImage = new DecorationOverlayIcon(baseImage, imageDescriptorArray, new Point(16, 16));
            registry.put(imageId, (ImageDescriptor)decoratedImage);
            image = registry.get(imageId);
        }
        return (Image)Preconditions.checkNotNull((Object)image);
    }

    private static boolean isAnyNull(Object ... arguments) {
        Object[] objectArray = arguments;
        int n = arguments.length;
        int n2 = 0;
        while (n2 < n) {
            Object argument = objectArray[n2];
            if (argument == null) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static Image decorate(@Nullable IServer server, @Nullable IStatus status, @Nullable ImageRegistry registry) {
        if (UI.isAnyNull(server, status, registry)) {
            return ImageDescriptor.getMissingImageDescriptor().createImage();
        }
        ISharedImages shared = PlatformUI.getWorkbench().getSharedImages();
        Image baseImage = server.getImage16();
        ImageDescriptor overlay = null;
        switch (status.getSeverity()) {
            case 4: {
                overlay = shared.getImageDescriptor("IMG_DEC_FIELD_ERROR");
                break;
            }
            case 2: {
                overlay = shared.getImageDescriptor("IMG_DEC_FIELD_WARNING");
                break;
            }
            case 8: {
                overlay = shared.getImageDescriptor("IMG_ETOOL_CLEAR");
                break;
            }
            case 0: 
            case 1: {
                overlay = shared.getImageDescriptor("IMG_OBJS_INFO_TSK");
            }
            default: {
                return baseImage;
            }
        }
        String imageId = String.valueOf(server.getId()) + "-status-code-16x16-" + status.getCode();
        Image image = registry.get(imageId);
        if (image == null) {
            ImageDescriptor[] imageDescriptorArray = new ImageDescriptor[5];
            imageDescriptorArray[0] = overlay;
            DecorationOverlayIcon decoratedImage = new DecorationOverlayIcon(baseImage, imageDescriptorArray, new Point(16, 16)){};
            registry.put(imageId, (ImageDescriptor)decoratedImage);
            image = registry.get(imageId);
        }
        return image;
    }

    public static GridDataFactory gd() {
        return GridDataFactory.fillDefaults();
    }

    public static void gd(Control control) {
        GridDataFactory.defaultsFor((Control)control).applyTo(control);
    }

    public static GridDataFactory gdGrabHV() {
        return GridDataFactory.fillDefaults().grab(true, true);
    }

    public static GridDataFactory gdGrabH() {
        return GridDataFactory.fillDefaults().grab(true, false);
    }

    public static GridDataFactory gdGrabV() {
        return GridDataFactory.fillDefaults().grab(false, true);
    }

    public static void gdGrabH(Control control) {
        UI.gdGrabH().applyTo(control);
    }

    public static GridLayoutFactory gl() {
        return GridLayoutFactory.fillDefaults();
    }

    public static Optional<Shell> getWorkbenchWindowShell() {
        Shell shell;
        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (workbenchWindow != null && (shell = workbenchWindow.getShell()) != null) {
            return Optional.of((Object)shell);
        }
        return Optional.absent();
    }

    public static boolean isUIThread() {
        return Display.getCurrent() != null;
    }

    public static Optional<Display> getDisplay() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null || workbench.isClosing()) {
            return Optional.absent();
        }
        Display display = workbench.getDisplay();
        if (display == null || display.isDisposed()) {
            return Optional.absent();
        }
        return Optional.of((Object)display);
    }

    public static Button createCheckButton(Composite parent, String text, String toolTip) {
        Button button = new Button(parent, 32);
        button.setText(text);
        UI.calibrateToolTip(new DefaultToolTip((Control)button), toolTip);
        return button;
    }

    public static Text createLabelWithText(Composite parent, String labelText, String textMessage, String toolTip) {
        Label label = new Label(parent, 0);
        label.setText(labelText);
        UI.calibrateToolTip(new DefaultToolTip((Control)label), toolTip);
        Text text = new Text(parent, 2048);
        text.setMessage(textMessage);
        UI.calibrateToolTip(new DefaultToolTip((Control)text), toolTip);
        UI.gdGrabH().applyTo((Control)text);
        return text;
    }

    public static void calibrateToolTip(DefaultToolTip toolTip, String toolTipText) {
        toolTip.setText(toolTipText);
        toolTip.setFont(JFaceResources.getDialogFont());
        toolTip.setShift(TOOLTIP_DISPLACEMENT);
        toolTip.setHideDelay(TOOLTIP_HIDE_DELAY);
    }
}

