/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ui.utils;

import com.google.common.base.Charsets;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.hash.Hasher;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.epp.internal.logging.aeri.ui.utils.Reports;
import org.eclipse.jdt.annotation.Nullable;

public class Statuses {
    private static final String NAME_DISPLAY = "org.eclipse.swt.widgets.Display";
    private static final String NAME_EVENT_TABLE = "org.eclipse.swt.widgets.EventTable";
    private static final String NAME_WIDGET = "org.eclipse.swt.widgets.Widget";
    private static final String NAME_MAIN = "org.eclipse.equinox.launcher.Main";
    private static final String NAME_WINDOW = "org.eclipse.jface.window.Window";
    private static final String NAME_WORKSPACE = "org.eclipse.core.internal.resources.Workspace";
    private static final String NAME_METHOD_REQUESTOR = "org.eclipse.e4.core.internal.di.MethodRequestor";
    private static final StackTraceElement DISPLAY__FILTER_EVENT = new StackTraceElement("org.eclipse.swt.widgets.Display", "filterEvent", null, -1);
    private static final StackTraceElement DISPLAY__READ_AND_DISPATCH = new StackTraceElement("org.eclipse.swt.widgets.Display", "readAndDispatch", null, -1);
    private static final StackTraceElement DISPLAY__RUN_DEFERRED_EVENTS = new StackTraceElement("org.eclipse.swt.widgets.Display", "runDeferredEvents", null, -1);
    private static final StackTraceElement DISPLAY__RUN_ASYNC_MESSAGES = new StackTraceElement("org.eclipse.swt.widgets.Display", "runAsyncMessages", null, -1);
    private static final StackTraceElement DISPLAY__RUN_SETTINGS = new StackTraceElement("org.eclipse.swt.widgets.Display", "runSettings", null, -1);
    private static final StackTraceElement DISPLAY__RUN_POPUPS = new StackTraceElement("org.eclipse.swt.widgets.Display", "runPopups", null, -1);
    private static final StackTraceElement MAIN__RUN = new StackTraceElement("org.eclipse.equinox.launcher.Main", "run", null, -1);
    private static final StackTraceElement DISPLAY__SEND_EVENT = new StackTraceElement("org.eclipse.swt.widgets.Display", "sendEvent", null, -1);
    private static final StackTraceElement EVENT_TABLE__SEND_EVENT = new StackTraceElement("org.eclipse.swt.widgets.EventTable", "sendEvent", null, -1);
    private static final StackTraceElement WIDGET__SEND_EVENT = new StackTraceElement("org.eclipse.swt.widgets.Widget", "sendEvent", null, -1);
    private static final StackTraceElement WINDOW__RUN_EVENT_LOOP = new StackTraceElement("org.eclipse.jface.window.Window", "runEventLoop", null, -1);
    private static final StackTraceElement WINDOW__OPEN = new StackTraceElement("org.eclipse.jface.window.Window", "open", null, -1);
    private static final StackTraceElement NOT_WINDOW__OPEN = new StackTraceElement("!org.eclipse.jface.window.Window", "open", null, -1);
    private static final StackTraceElement WORKSPACE__BUILD = new StackTraceElement("org.eclipse.core.internal.resources.Workspace", "build", null, -1);
    private static final StackTraceElement METHOD_REQUESTOR_EXECUTE = new StackTraceElement("org.eclipse.e4.core.internal.di.MethodRequestor", "execute", null, -1);

    private static StackTraceElement[] rule(StackTraceElement ... sequence) {
        return sequence;
    }

    public static StackTraceElement[] removeClassesFromTop(StackTraceElement[] trace, Set<String> classNames) {
        Preconditions.checkNotNull((Object)trace);
        Preconditions.checkNotNull(classNames);
        int index = Statuses.findStart(trace, classNames);
        StackTraceElement[] res = (StackTraceElement[])ArrayUtils.subarray((Object[])trace, (int)index, (int)trace.length);
        return res;
    }

    private static int findStart(StackTraceElement[] trace, Set<String> ignoredClasses) {
        int i = 0;
        while (i < trace.length) {
            StackTraceElement frame = trace[i];
            if (!ignoredClasses.contains(frame.getClassName())) {
                return i;
            }
            ++i;
        }
        return trace.length;
    }

    public static Throwable[] getCausalChain(Throwable throwable) {
        Preconditions.checkNotNull((Object)throwable);
        return Throwables.getCausalChain((Throwable)throwable).toArray(new Throwable[0]);
    }

    public static StackTraceElement[] normalize(Throwable throwable) {
        Preconditions.checkNotNull((Object)throwable);
        Throwable[] chain = Statuses.getCausalChain(throwable);
        LinkedList normalized = Lists.newLinkedList();
        int i = chain.length;
        while (i-- > 0) {
            Object[] causeTrace = chain[i].getStackTrace();
            if (i == 0) {
                normalized.addAll(Arrays.asList(causeTrace));
                break;
            }
            StackTraceElement[] parentTrace = chain[i - 1].getStackTrace();
            int ci = causeTrace.length - 1;
            int ei = parentTrace.length - 1;
            while (ci >= 0 && ei >= 0 && Objects.equal((Object)causeTrace[ci], (Object)parentTrace[ei])) {
                --ci;
                --ei;
            }
            StackTraceElement[] cfr_ignored_0 = (StackTraceElement[])ArrayUtils.subarray((Object[])causeTrace, (int)0, (int)Math.max(0, ci + 1));
            normalized.addAll(Arrays.asList(causeTrace));
        }
        StackTraceElement[] res = normalized.toArray(new StackTraceElement[0]);
        return res;
    }

    public static StackTraceElement[] truncate(StackTraceElement[] trace) {
        Preconditions.checkNotNull((Object)trace);
        int index = Statuses.findCutOffIndexForRelevantFrames(trace);
        return (StackTraceElement[])ArrayUtils.subarray((Object[])trace, (int)0, (int)index);
    }

    private static int findCutOffIndexForRelevantFrames(StackTraceElement[] trace) {
        int i = 0;
        while (i < trace.length) {
            StackTraceElement frame = trace[i];
            if (Statuses.isSameFrame(trace, i, WIDGET__SEND_EVENT, WIDGET__SEND_EVENT, WIDGET__SEND_EVENT)) {
                return i + 3;
            }
            if (Statuses.isSameFrame(trace, i, EVENT_TABLE__SEND_EVENT, DISPLAY__SEND_EVENT, WIDGET__SEND_EVENT)) {
                return i + 3;
            }
            if (Statuses.isSameFrame(frame, DISPLAY__READ_AND_DISPATCH)) {
                if (!Statuses.isSameFrame(trace, i + 1, WINDOW__RUN_EVENT_LOOP, WINDOW__OPEN)) {
                    return i + 1;
                }
            } else {
                if (Statuses.isSameFrame(frame, DISPLAY__RUN_ASYNC_MESSAGES)) {
                    return i + 1;
                }
                if (Statuses.isSameFrame(frame, DISPLAY__RUN_DEFERRED_EVENTS)) {
                    return i + 1;
                }
                if (Statuses.isSameFrame(frame, DISPLAY__RUN_POPUPS)) {
                    return i + 1;
                }
                if (Statuses.isSameFrame(frame, DISPLAY__RUN_SETTINGS)) {
                    return i + 1;
                }
                if (Statuses.isSameFrame(frame, DISPLAY__FILTER_EVENT)) {
                    return i + 1;
                }
                if (Statuses.isSameFrame(frame, WORKSPACE__BUILD)) {
                    return i + 1;
                }
                if (Statuses.isSameFrame(frame, METHOD_REQUESTOR_EXECUTE)) {
                    return i + 1;
                }
            }
            ++i;
        }
        return trace.length;
    }

    private static boolean isMain(StackTraceElement[] trace) {
        if (ArrayUtils.isEmpty((Object[])trace)) {
            return false;
        }
        StackTraceElement last = trace[trace.length - 1];
        return Statuses.isSameFrame(last, MAIN__RUN, true);
    }

    private static boolean isSameFrame(StackTraceElement frame, StackTraceElement test) {
        return Statuses.isSameFrame(frame, test, true);
    }

    private static boolean isSameFrame(StackTraceElement last, StackTraceElement test, boolean ignoreLineNumber) {
        return Objects.equal((Object)last.getClassName(), (Object)test.getClassName()) && Objects.equal((Object)last.getMethodName(), (Object)test.getMethodName()) && (ignoreLineNumber || last.getLineNumber() == test.getLineNumber());
    }

    private static boolean isSameFrame(StackTraceElement[] trace, int index, StackTraceElement test) {
        if (index >= trace.length) {
            return false;
        }
        StackTraceElement frame = trace[index];
        return Statuses.isSameFrame(frame, test);
    }

    private static boolean isSameFrame(StackTraceElement[] trace, int index, StackTraceElement ... test) {
        if (test.length > trace.length - index) {
            return false;
        }
        int i = 0;
        while (i < test.length) {
            if (!Statuses.isSameFrame(trace[index + i], test[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isEmptyJobStatus(IStatus status) {
        return Statuses.isEmptyJobThrowable(status.getException());
    }

    public static boolean isEmptyJobThrowable(Throwable throwable) {
        return Statuses.isEmptyJobStackTrace(throwable.getStackTrace()) && throwable.getCause() == null;
    }

    public static boolean isEmptyJobStackTrace(StackTraceElement[] trace) {
        StackTraceElement[] stackTraceElementArray = trace;
        int n = trace.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement frame = stackTraceElementArray[n2];
            if (!StringUtils.startsWith((CharSequence)frame.getClassName(), (CharSequence)"org.eclipse.core.internal.jobs.")) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static String newFingerprint(Throwable input, final boolean includeMessages, final boolean includeLineNumbers) {
        final Hasher hasher = Reports.newHasher();
        new StatusSwitch<Hasher>(){

            @Override
            public Hasher caseStackTraceElement(StackTraceElement object) {
                hasher.putString((CharSequence)StringUtils.stripToEmpty((String)object.getClassName()), Charsets.UTF_8);
                hasher.putString((CharSequence)StringUtils.stripToEmpty((String)object.getMethodName()), Charsets.UTF_8);
                if (includeLineNumbers) {
                    hasher.putInt(object.getLineNumber());
                }
                return null;
            }

            @Override
            public Hasher caseThrowable(Throwable object) {
                hasher.putString((CharSequence)StringUtils.stripToEmpty((String)object.getClass().getName()), Charsets.UTF_8);
                if (includeMessages) {
                    hasher.putString((CharSequence)StringUtils.stripToEmpty((String)object.getMessage()), Charsets.UTF_8);
                }
                return null;
            }
        }.doSwitch(input);
        return hasher.hash().toString();
    }

    public static String newFingerprint(StackTraceElement[] trace, boolean includeLineNumbers) {
        Hasher hasher = Reports.newHasher();
        StackTraceElement[] stackTraceElementArray = trace;
        int n = trace.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement frame = stackTraceElementArray[n2];
            hasher.putString((CharSequence)StringUtils.stripToEmpty((String)frame.getClassName()), Charsets.UTF_8);
            hasher.putString((CharSequence)StringUtils.stripToEmpty((String)frame.getMethodName()), Charsets.UTF_8);
            if (includeLineNumbers) {
                hasher.putInt(frame.getLineNumber());
            }
            ++n2;
        }
        return hasher.hash().toString();
    }

    public static IStatus findRelevantStatus(IStatus status) {
        if (Statuses.isEmptyJobStatus(status)) {
            LinkedList bsf = Lists.newLinkedList();
            bsf.addAll(Arrays.asList(status.getChildren()));
            while (!bsf.isEmpty()) {
                IStatus poll = (IStatus)bsf.poll();
                if (poll.getException() != null) {
                    return poll;
                }
                bsf.addAll(Arrays.asList(poll.getChildren()));
            }
        }
        return status;
    }

    public static boolean isUiFreeze(IStatus status) {
        return Objects.equal((Object)"org.eclipse.ui.monitoring", (Object)status.getPlugin());
    }

    public static class StatusSwitch<T> {
        @Nullable
        public T doSwitch(@Nullable IStatus status) {
            if (status == null) {
                return null;
            }
            T res = this.caseStatus(status);
            if (res != null) {
                return res;
            }
            Throwable exception = status.getException();
            if (exception != null && (res = this.doSwitch(exception)) != null) {
                return res;
            }
            IStatus[] iStatusArray = status.getChildren();
            int n = iStatusArray.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus child = iStatusArray[n2];
                res = this.doSwitch(child);
                if (res != null) {
                    return res;
                }
                ++n2;
            }
            return res;
        }

        @Nullable
        public T doSwitch(Throwable exception) {
            CoreException coreException;
            IStatus innerStatus;
            if (exception == null) {
                return null;
            }
            T res = this.caseThrowable(exception);
            if (res != null) {
                return res;
            }
            StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
            int n = stackTraceElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                StackTraceElement element = stackTraceElementArray[n2];
                res = this.caseStackTraceElement(element);
                if (res != null) {
                    return res;
                }
                ++n2;
            }
            if (exception instanceof CoreException && (innerStatus = (coreException = (CoreException)exception).getStatus()) != null && (res = this.doSwitch(innerStatus)) != null) {
                return res;
            }
            Throwable cause = exception.getCause();
            if (cause != null && (res = this.doSwitch(cause)) != null) {
                return res;
            }
            return res;
        }

        @Nullable
        public T caseStatus(IStatus status) {
            return null;
        }

        @Nullable
        public T caseThrowable(Throwable throwable) {
            return null;
        }

        @Nullable
        public T caseStackTraceElement(StackTraceElement stackTraceElement) {
            return null;
        }
    }
}

