/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ui.utils;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.epp.internal.logging.aeri.ui.m0.Statuses;
import org.eclipse.epp.internal.logging.aeri.ui.model.ISystemSettings;
import org.eclipse.epp.internal.logging.aeri.ui.model.SendMode;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ui.IWorkbench;

public class StatusFilters {

    public static class EclipseBuildIdPresentFilter
    implements Predicate<IStatus> {
        public boolean apply(@Nullable IStatus input) {
            return !StringUtils.isEmpty((CharSequence)System.getProperty("eclipse.buildId"));
        }
    }

    public static class NoErrorStatusFilter
    implements Predicate<IStatus> {
        public boolean apply(@Nullable IStatus input) {
            return input.matches(4);
        }
    }

    public static class RecentlySeenFilter
    implements Predicate<IStatus> {
        private Cache<String, String> cache;
        private ISystemSettings system;

        public RecentlySeenFilter(ISystemSettings system) {
            this.system = system;
            this.cache = CacheBuilder.newBuilder().concurrencyLevel(1).expireAfterAccess(1L, TimeUnit.HOURS).initialCapacity(30).maximumSize(500L).build();
        }

        @VisibleForTesting
        public RecentlySeenFilter(ISystemSettings system, long timoutInMillis) {
            this.system = system;
            this.cache = CacheBuilder.newBuilder().concurrencyLevel(1).expireAfterAccess(timoutInMillis, TimeUnit.MILLISECONDS).initialCapacity(30).maximumSize(500L).build();
        }

        public boolean apply(IStatus input) {
            if (this.system.isDebugEnabled()) {
                return true;
            }
            String fp = Statuses.newThrowableFingerprint(input.getException(), false, false);
            String val = (String)this.cache.getIfPresent((Object)fp);
            if (val == null) {
                this.cache.put((Object)fp, (Object)"");
            }
            return val == null;
        }
    }

    public static class SystemEnabledFilter
    implements Predicate<IStatus> {
        private ISystemSettings settings;

        public SystemEnabledFilter(ISystemSettings settings) {
            this.settings = settings;
        }

        public boolean apply(@Nullable IStatus input) {
            return !Objects.equal((Object)((Object)SendMode.NEVER), (Object)((Object)this.settings.getSendMode()));
        }
    }

    public static class WorkbenchRunningFilter
    implements Predicate<IStatus> {
        private IWorkbench workbench;

        public WorkbenchRunningFilter(IWorkbench workbench) {
            this.workbench = workbench;
        }

        public boolean apply(@Nullable IStatus input) {
            return !this.workbench.isClosing();
        }
    }
}

