/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ui.utils;

import com.google.common.base.Predicate;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.epp.internal.logging.aeri.ui.utils.UI;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class StatusFilterActiveShell
implements Predicate<IStatus> {
    @Nullable
    private static Shell activeShell;

    public StatusFilterActiveShell() {
        Display display = (Display)UI.getDisplay().orNull();
        if (display != null) {
            display.asyncExec((Runnable)new ActiveShellTracker());
        }
    }

    public boolean apply(@Nullable IStatus input) {
        return activeShell != null;
    }

    private static final class ActiveShellTracker
    implements Runnable,
    Listener {
        private ActiveShellTracker() {
        }

        @Override
        public void run() {
            IWorkbench workbench = PlatformUI.getWorkbench();
            Display display = workbench.getDisplay();
            display.addFilter(27, (Listener)this);
            display.addFilter(26, (Listener)this);
            IWorkbenchWindow activeWindow = workbench.getActiveWorkbenchWindow();
            if (activeWindow != null) {
                activeShell = activeWindow.getShell();
            }
        }

        public void handleEvent(Event event) {
            switch (event.type) {
                case 26: {
                    if (!this.isShell(event)) break;
                    activeShell = (Shell)event.widget;
                    break;
                }
                case 27: {
                    if (!this.isShell(event)) break;
                    activeShell = null;
                }
            }
        }

        private boolean isShell(Event event) {
            return event.widget instanceof Shell;
        }
    }
}

