/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ui.utils;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.BiMap;
import com.google.common.collect.Collections2;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epp.internal.logging.aeri.ui.SystemControl;
import org.eclipse.epp.internal.logging.aeri.ui.dialogs.ServersPage;
import org.eclipse.epp.internal.logging.aeri.ui.dialogs.SetupWizard;
import org.eclipse.epp.internal.logging.aeri.ui.model.ILink;
import org.eclipse.epp.internal.logging.aeri.ui.model.IModelPackage;
import org.eclipse.epp.internal.logging.aeri.ui.model.ISendOptions;
import org.eclipse.epp.internal.logging.aeri.ui.model.IServer;
import org.eclipse.epp.internal.logging.aeri.ui.model.ISystemSettings;
import org.eclipse.epp.internal.logging.aeri.ui.utils.Constants;
import org.eclipse.epp.internal.logging.aeri.ui.utils.SetupWizardDialog;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;

public class Servers {
    private static BiMap<EAttribute, EAttribute> SYSTEM_TO_SERVER = HashBiMap.create((Map)ImmutableMap.of((Object)IModelPackage.Literals.SYSTEM_SETTINGS__REPORTER_NAME, (Object)IModelPackage.Literals.SERVER__REPORTER_NAME, (Object)IModelPackage.Literals.SYSTEM_SETTINGS__REPORTER_EMAIL, (Object)IModelPackage.Literals.SERVER__REPORTER_EMAIL, (Object)IModelPackage.Literals.SYSTEM_SETTINGS__ANONYMIZE_MESSAGES, (Object)IModelPackage.Literals.SERVER__ANONYMIZE_MESSAGES, (Object)IModelPackage.Literals.SYSTEM_SETTINGS__ANONYMIZE_STACK_TRACES, (Object)IModelPackage.Literals.SERVER__ANONYMIZE_STACK_TRACES));
    private static BiMap<EAttribute, EAttribute> SERVER_TO_SEND_OPTIONS = HashBiMap.create((Map)ImmutableMap.of((Object)IModelPackage.Literals.SERVER__REPORTER_NAME, (Object)IModelPackage.Literals.SEND_OPTIONS__REPORTER_NAME, (Object)IModelPackage.Literals.SERVER__REPORTER_EMAIL, (Object)IModelPackage.Literals.SEND_OPTIONS__REPORTER_EMAIL, (Object)IModelPackage.Literals.SERVER__ANONYMIZE_MESSAGES, (Object)IModelPackage.Literals.SEND_OPTIONS__ANONYMIZE_MESSAGES, (Object)IModelPackage.Literals.SERVER__ANONYMIZE_STACK_TRACES, (Object)IModelPackage.Literals.SEND_OPTIONS__ANONYMIZE_STACK_TRACES));
    private static BiMap<EAttribute, EAttribute> SYSTEM_TO_SEND_OPTIONS = HashBiMap.create((Map)ImmutableMap.of((Object)IModelPackage.Literals.SYSTEM_SETTINGS__REPORTER_NAME, (Object)IModelPackage.Literals.SEND_OPTIONS__REPORTER_NAME, (Object)IModelPackage.Literals.SYSTEM_SETTINGS__REPORTER_EMAIL, (Object)IModelPackage.Literals.SEND_OPTIONS__REPORTER_EMAIL, (Object)IModelPackage.Literals.SYSTEM_SETTINGS__ANONYMIZE_MESSAGES, (Object)IModelPackage.Literals.SEND_OPTIONS__ANONYMIZE_MESSAGES, (Object)IModelPackage.Literals.SYSTEM_SETTINGS__ANONYMIZE_STACK_TRACES, (Object)IModelPackage.Literals.SEND_OPTIONS__ANONYMIZE_STACK_TRACES));
    private static final Predicate<IServer> CONFIGURED = new Predicate<IServer>(){

        public boolean apply(IServer input) {
            return input.isConfigured();
        }
    };
    private static final Predicate<IServer> ENABLED = new Predicate<IServer>(){

        public boolean apply(IServer input) {
            return input.isEnabled();
        }
    };

    public static Collection<IServer> viewOfConfigured(Collection<IServer> unfiltered) {
        return Collections2.filter(unfiltered, CONFIGURED);
    }

    public static Collection<IServer> viewOfUnconfigured(Collection<IServer> unfiltered) {
        return Collections2.filter(unfiltered, (Predicate)Predicates.not(CONFIGURED));
    }

    public static Collection<IServer> viewOfEnabled(Collection<IServer> unfiltered) {
        return Collections2.filter(unfiltered, ENABLED);
    }

    public static Collection<IServer> viewOfDisabled(Collection<IServer> unfiltered) {
        return Collections2.filter(unfiltered, (Predicate)Predicates.not(ENABLED));
    }

    public static Collection<IServer> viewOfActive(Collection<IServer> unfiltered) {
        return Collections2.filter(unfiltered, (Predicate)Predicates.and(ENABLED, CONFIGURED));
    }

    public static Collection<IServer> viewOfInactive(Collection<IServer> unfiltered) {
        return Collections2.filter(unfiltered, (Predicate)Predicates.not((Predicate)Predicates.and(ENABLED, CONFIGURED)));
    }

    public static ImmutableList<IServer> copyOfConfigured(Collection<IServer> unfiltered) {
        return ImmutableList.copyOf(Servers.viewOfConfigured(unfiltered));
    }

    public static ImmutableList<IServer> copyOfUnconfigured(Collection<IServer> unfiltered) {
        return ImmutableList.copyOf(Servers.viewOfUnconfigured(unfiltered));
    }

    public static ImmutableList<IServer> copyOfEnabled(Collection<IServer> unfiltered) {
        return ImmutableList.copyOf(Servers.viewOfEnabled(unfiltered));
    }

    public static ImmutableList<IServer> copyOfDisabled(Collection<IServer> unfiltered) {
        return ImmutableList.copyOf(Servers.viewOfDisabled(unfiltered));
    }

    public static ImmutableList<IServer> copyOfActive(Collection<IServer> unfiltered) {
        return ImmutableList.copyOf(Servers.viewOfActive(unfiltered));
    }

    public static ImmutableList<IServer> copyOfInactive(Collection<IServer> unfiltered) {
        return ImmutableList.copyOf(Servers.viewOfInactive(unfiltered));
    }

    @Nullable
    public static String getLinkHref(IServer server, String rel) {
        ILink link = server.getLink(rel);
        return link != null ? link.getHref() : null;
    }

    public static void copyServerDefaultsIfUnset(IServer source, ISendOptions target) {
        Servers.copyIfUnset(source, target, SERVER_TO_SEND_OPTIONS);
    }

    public static void copySystemDefaultsIfUnset(ISystemSettings source, ISendOptions target) {
        Servers.copyIfUnset(source, target, SYSTEM_TO_SEND_OPTIONS);
    }

    public static void copySystemDefaultsIfUnset(ISystemSettings source, IServer target) {
        Servers.copyIfUnset(source, target, SYSTEM_TO_SERVER);
    }

    public static void setAsDefaults(IServer source, ISystemSettings target) {
        Servers.copyIfUnset(source, target, (Map<EAttribute, EAttribute>)SYSTEM_TO_SERVER.inverse());
    }

    private static void copyIfUnset(EObject source, EObject target, Map<EAttribute, EAttribute> mappings) {
        for (Map.Entry<EAttribute, EAttribute> entry : mappings.entrySet()) {
            EAttribute toAttr = entry.getValue();
            if (target.eIsSet((EStructuralFeature)toAttr)) continue;
            EAttribute fromAttr = entry.getKey();
            Object value = source.eGet((EStructuralFeature)fromAttr);
            target.eSet((EStructuralFeature)toAttr, value);
        }
    }

    public static boolean isOnlyEclipseServer(Collection<IServer> servers) {
        if (servers.isEmpty()) {
            return false;
        }
        for (IServer server : servers) {
            if (StringUtils.startsWith((CharSequence)server.getId(), (CharSequence)"org.eclipse")) continue;
            return false;
        }
        return true;
    }

    public static void openConfigureServersDialog() {
        IEclipseContext context = SystemControl.getSystemContext();
        Shell parentShell = (Shell)context.get("activeShell");
        List servers = (List)context.get("org.eclipse.epp.logging.aeri.ui.servers");
        SetupWizard wizard = (SetupWizard)((Object)ContextInjectionFactory.make(SetupWizard.class, (IEclipseContext)context));
        wizard.addPage((IWizardPage)new ServersPage(servers, (IEventBroker)context.get(IEventBroker.class), context));
        new SetupWizardDialog(parentShell, (IWizard)wizard).open();
    }

    public static ILink createLink(String rel, String href, String title) {
        ILink res = Constants.eFac.createLink();
        res.setRel(rel);
        res.setHref(href);
        res.setTitle(title);
        return res;
    }

    public static ILink createSubmissionLink(String href, String title) {
        return Servers.createLink("submission", href, title);
    }

    public static ILink createBugLink(String href, String title) {
        return Servers.createLink("bug", href, title);
    }
}

