/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ui.utils;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.eclipse.core.internal.runtime.Log;
import org.eclipse.core.internal.runtime.PlatformLogWriter;
import org.eclipse.core.internal.runtime.RuntimeLog;
import org.eclipse.epp.internal.logging.aeri.ui.LogListener;
import org.eclipse.epp.internal.logging.aeri.ui.utils.Statuses;

public class NoException
extends Throwable {
    private static final long serialVersionUID = 1L;
    private static final Set<String> FILTERED_CLASSES = ImmutableSet.of((Object)LogListener.class.getName(), (Object)Log.class.getName(), (Object)RuntimeLog.class.getName(), (Object)PlatformLogWriter.class.getName(), (Object)"org.eclipse.osgi.internal.log.ExtendedLogReaderServiceFactory$3", (Object)"org.eclipse.osgi.internal.log.ExtendedLogReaderServiceFactory", (Object[])new String[]{"org.eclipse.osgi.internal.log.ExtendedLogServiceFactory", "org.eclipse.osgi.internal.log.ExtendedLogServiceImpl", "org.eclipse.osgi.internal.log.LoggerImpl"});

    public NoException() {
        super("This event was logged without a stack trace. A synthetic stack trace was hence inserted.");
    }

    @Override
    public synchronized Throwable fillInStackTrace() {
        super.fillInStackTrace();
        this.filterKnownLogClasses();
        return this;
    }

    private void filterKnownLogClasses() {
        StackTraceElement[] orgTrace = this.getStackTrace();
        StackTraceElement[] newTrace = Statuses.removeClassesFromTop(orgTrace, FILTERED_CLASSES);
        this.setStackTrace(newTrace);
    }
}

