/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ui.utils;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.ExtendedMessageFormat;
import org.apache.commons.lang3.text.FormatFactory;
import org.eclipse.epp.internal.logging.aeri.ui.l10n.Logs;
import org.eclipse.epp.internal.logging.aeri.ui.model.ILink;
import org.eclipse.epp.internal.logging.aeri.ui.model.IProblemState;
import org.eclipse.epp.internal.logging.aeri.ui.model.IServer;

public class Formats {
    private static final CustomFormatFactory FACTORY = new CustomFormatFactory();
    private static final Map<String, CustomFormatFactory> REGISTRY = ImmutableMap.of((Object)"link", (Object)FACTORY, (Object)"links", (Object)FACTORY, (Object)"projects", (Object)FACTORY);

    public static String format(String pattern, Object ... args) {
        pattern = StringUtils.defaultString((String)pattern, (String)"null");
        try {
            return new ExtendedMessageFormat(pattern, REGISTRY).format((Object)args);
        }
        catch (Exception e) {
            Logs.warn("Formatting {0} with args {1} failed: {2}.", e, pattern, args, e.getMessage());
            return pattern;
        }
    }

    private static final class CustomFormatFactory
    implements FormatFactory {
        private CustomFormatFactory() {
        }

        public Format getFormat(String name, String arguments, Locale locale) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            List properties = Splitter.on((char)';').omitEmptyStrings().trimResults().splitToList((CharSequence)StringUtils.defaultString((String)arguments));
            for (String property : properties) {
                List split = Splitter.on((char)'=').omitEmptyStrings().trimResults().splitToList((CharSequence)property);
                builder.put((Object)((String)split.get(0)), (Object)(split.size() > 1 ? (String)split.get(1) : String.valueOf(true)));
            }
            ImmutableMap args = builder.build();
            switch (name) {
                case "link": {
                    return new LinkFormat((Map)args);
                }
                case "links": {
                    return new LinkCollectionFormat((Map)args);
                }
                case "projects": {
                    return new ProjectsFormat((Map)args);
                }
            }
            return null;
        }
    }

    private static class LinkCollectionFormat
    extends Format {
        private final Map<String, String> args;

        private LinkCollectionFormat(Map<String, String> args) {
            this.args = args;
        }

        @Override
        public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
            Collection list = null;
            Map map = null;
            if (obj instanceof Collection) {
                list = (Collection)obj;
                ImmutableMap.Builder b = ImmutableMap.builder();
                for (ILink link : list) {
                    b.put((Object)link.getRel(), (Object)link);
                }
                map = b.build();
            } else if (obj instanceof ILink) {
                ILink link = (ILink)obj;
                map = ImmutableMap.of((Object)link.getRel(), (Object)link);
            } else if (obj instanceof Map) {
                map = (Map)obj;
            } else if (obj instanceof IProblemState) {
                map = ((IProblemState)obj).getLinks().map();
            } else if (obj instanceof IServer) {
                map = ((IServer)obj).getLinks().map();
            } else {
                return toAppendTo;
            }
            list = map.values();
            LinkFormat format = new LinkFormat(this.args);
            ArrayList strings = Lists.newArrayList();
            for (ILink link : list) {
                String string = format.format(link);
                strings.add(string);
            }
            String separator = StringUtils.defaultString((String)this.args.get("separator"), (String)" ");
            String res = Joiner.on((String)separator).join((Iterable)strings);
            return toAppendTo.append(res);
        }

        @Override
        public Object parseObject(String source, ParsePosition pos) {
            return null;
        }
    }

    private static class LinkFormat
    extends Format {
        private final Map<String, String> args;

        private LinkFormat(Map<String, String> args) {
            this.args = args;
        }

        @Override
        public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
            String key;
            ILink link = null;
            if (obj instanceof ILink) {
                link = (ILink)obj;
            } else if (obj instanceof Map) {
                key = this.args.get("rel");
                link = (ILink)((Map)obj).get(key);
            } else if (obj instanceof IProblemState) {
                key = this.args.get("rel");
                link = (ILink)((IProblemState)obj).getLinks().get((Object)key);
            } else if (obj instanceof IServer) {
                key = this.args.get("rel");
                link = (ILink)((IServer)obj).getLinks().get((Object)key);
            } else {
                return toAppendTo;
            }
            if (link == null) {
                return toAppendTo.append("null");
            }
            if (this.useBrackets()) {
                toAppendTo.append('[');
            }
            String title = StringUtils.defaultString((String)this.args.get("title"), (String)link.getTitle());
            toAppendTo.append("<a href=\"").append(link.getHref()).append("\">").append(title).append("</a>");
            if (this.useBrackets()) {
                toAppendTo.append(']');
            }
            return toAppendTo;
        }

        private boolean useBrackets() {
            return "true".equals(this.args.get("brackets"));
        }

        @Override
        public Object parseObject(String source, ParsePosition pos) {
            return null;
        }
    }

    private static class ProjectsFormat
    extends Format {
        private final Map<String, String> args;

        private ProjectsFormat(Map<String, String> args) {
            this.args = args;
        }

        /*
         * Exception decompiling
         */
        @Override
        public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[6] lbl35 : CaseStatement: default:\u000a, @NONE, blocks:[6] lbl35 : CaseStatement: default:\u000a]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
             *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
             *     at java.base/java.util.TimSort.sort(TimSort.java:220)
             *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
             *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
             *     at java.base/java.util.Collections.sort(Collections.java:178)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private StringBuffer handleMedium(StringBuffer sb, Collection<IServer> servers) {
            int size = servers.size();
            switch (size) {
                case 0: {
                    return sb.append("Zero projects");
                }
                case 1: {
                    return sb.append(((IServer)Iterables.get(servers, (int)0)).getName());
                }
            }
            sb.append(((IServer)Iterables.get(servers, (int)0)).getName());
            return sb.append(" and ").append(size - 1).append(" more projects");
        }

        private StringBuffer handleLong(StringBuffer sb, Collection<IServer> servers) {
            int size = servers.size();
            if (size == 1) {
                return sb.append(((IServer)Iterables.get(servers, (int)0)).getName());
            }
            LinkedList cp = Lists.newLinkedList(servers);
            sb.append(Joiner.on((String)", ").join(cp.subList(0, size - 2)));
            return sb.append(" and ").append(((IServer)Iterables.getLast((Iterable)cp)).getName());
        }

        private StringBuffer handleNumbers(StringBuffer toAppendTo, Collection<IServer> servers) {
            switch (servers.size()) {
                case 0: {
                    return toAppendTo.append("Zero projects");
                }
                case 1: {
                    return toAppendTo.append("One project");
                }
                case 2: {
                    return toAppendTo.append("Two projects");
                }
                case 3: {
                    return toAppendTo.append("Three projects");
                }
            }
            return toAppendTo.append(String.valueOf(servers.size()) + " projects");
        }

        @Override
        public Object parseObject(String source, ParsePosition pos) {
            return null;
        }
    }
}

