/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ui.notifications;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.EventTopic;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.epp.internal.logging.aeri.ui.l10n.LogMessages;
import org.eclipse.epp.internal.logging.aeri.ui.l10n.Logs;
import org.eclipse.epp.internal.logging.aeri.ui.model.ILogEventGroup;
import org.eclipse.epp.internal.logging.aeri.ui.model.IServer;
import org.eclipse.epp.internal.logging.aeri.ui.notifications.LogEventGroupLoggedNotification;
import org.eclipse.epp.internal.logging.aeri.ui.notifications.LogEventGroupResponsesNotification;
import org.eclipse.epp.internal.logging.aeri.ui.notifications.NewProjectsNotification;
import org.eclipse.epp.internal.logging.aeri.ui.notifications.Notification;
import org.eclipse.epp.internal.logging.aeri.ui.notifications.WelcomeNotification;
import org.eclipse.epp.internal.logging.aeri.ui.utils.Constants;
import org.eclipse.mylyn.commons.notifications.ui.NotificationsUi;

@Singleton
public class NotificationsService {
    private Set<Notification> displayed = Sets.newConcurrentHashSet();
    private IEclipseContext context;

    @Inject
    public NotificationsService(IEventBroker broker, IEclipseContext context) {
        this.context = context;
    }

    @Inject
    @Optional
    public void notificationClosed(@EventTopic(value="org/eclipse/epp/internal/logging/aeri/ui/notifications/closed") Notification event) {
        this.displayed.remove((Object)event);
        this.context.modify("org.eclipse.epp.logging.aeri.ui.ui.notification-ongoing", (Object)(!this.displayed.isEmpty() ? 1 : 0));
    }

    @Inject
    @Optional
    public void notificationOpened(@EventTopic(value="org/eclipse/epp/internal/logging/aeri/ui/notifications/opened") Notification event) {
        this.displayed.add(event);
        this.context.modify("org.eclipse.epp.logging.aeri.ui.ui.notification-ongoing", (Object)(!this.displayed.isEmpty() ? 1 : 0));
    }

    public boolean isNotificationInProgress() {
        return !this.displayed.isEmpty();
    }

    public void showWelcomeNotification() {
        this.testIsNotificationInProgress();
        WelcomeNotification notification = (WelcomeNotification)((Object)ContextInjectionFactory.make(WelcomeNotification.class, (IEclipseContext)this.context));
        NotificationsUi.getService().notify((List)ImmutableList.of((Object)((Object)notification)));
    }

    public void showNewServersAvailable(List<IServer> servers) {
        this.testIsNotificationInProgress();
        NewProjectsNotification notification = (NewProjectsNotification)((Object)ContextInjectionFactory.make(NewProjectsNotification.class, (IEclipseContext)this.context));
        notification.setServers(servers);
        NotificationsUi.getService().notify((List)ImmutableList.of((Object)((Object)notification)));
    }

    public void showServerResponses(ILogEventGroup group) {
        this.testIsNotificationInProgress();
        IEclipseContext child = this.context.createChild("endpoint-responses-notification");
        child.set(ILogEventGroup.class, (Object)group);
        LogEventGroupResponsesNotification notification = (LogEventGroupResponsesNotification)((Object)ContextInjectionFactory.make(LogEventGroupResponsesNotification.class, (IEclipseContext)child));
        NotificationsUi.getService().notify((List)ImmutableList.of((Object)((Object)notification)));
    }

    public void showNewEventLogNotification(ILogEventGroup group) {
        this.testIsNotificationInProgress();
        Class<LogEventGroupLoggedNotification> clazz = LogEventGroupLoggedNotification.class;
        IEclipseContext child = this.context.createChild("new-log-events-notification");
        child.set(ILogEventGroup.class, (Object)group);
        LogEventGroupLoggedNotification notification = (LogEventGroupLoggedNotification)((Object)ContextInjectionFactory.make(clazz, (IEclipseContext)child));
        NotificationsUi.getService().notify((List)ImmutableList.of((Object)((Object)notification)));
    }

    private void testIsNotificationInProgress() {
        if (Constants.DEBUG && this.isNotificationInProgress()) {
            Logs.log(LogMessages.DEBUG_NOTIFICATION_IN_PROGRESS, ImmutableList.of(this.displayed));
        }
    }
}

