/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ui.notifications;

import com.google.common.base.Optional;
import java.util.Date;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.epp.internal.logging.aeri.ui.notifications.NotificationAction;
import org.eclipse.epp.internal.logging.aeri.ui.notifications.NotificationPopup;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.mylyn.commons.notifications.ui.AbstractUiNotification;
import org.eclipse.swt.graphics.Image;

public abstract class Notification
extends AbstractUiNotification {
    @Nullable
    private NotificationPopup popup;
    private boolean unhandled = true;
    protected IEventBroker broker;

    public Notification(String eventId, IEventBroker broker) {
        super(eventId);
        this.broker = broker;
    }

    public Object getAdapter(Class adapter) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    @Nullable
    public Image getNotificationImage() {
        return null;
    }

    @Nullable
    public Image getNotificationKindImage() {
        return null;
    }

    public Date getDate() {
        return new Date();
    }

    public String getTitle() {
        return "Error Reporting";
    }

    public void setPopup(NotificationPopup popup) {
        this.popup = popup;
    }

    public Optional<NotificationPopup> getPopup() {
        return Optional.fromNullable((Object)((Object)this.popup));
    }

    public abstract List<NotificationAction> getActions();

    public void open() {
        List<NotificationAction> actions = this.getActions();
        if (!actions.isEmpty()) {
            actions.get(0).execute();
        }
    }

    public void closeWithEvent(@Nullable String topic, @Nullable Object event) {
        this.unhandled = false;
        NotificationPopup popup = (NotificationPopup)((Object)this.getPopup().orNull());
        if (popup != null) {
            popup.close();
        }
        if (topic != null) {
            this.fireEvent(topic, event);
        }
    }

    public void fireEvent(String topic, @Nullable Object event) {
        this.unhandled = false;
        this.broker.post(topic, event);
    }

    public void close() {
        if (this.unhandled) {
            this.unhandled();
        }
    }

    public void unhandled() {
    }
}

