/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ui.notifications;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.text.ChoiceFormat;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.epp.internal.logging.aeri.ui.model.IServer;
import org.eclipse.epp.internal.logging.aeri.ui.notifications.Notification;
import org.eclipse.epp.internal.logging.aeri.ui.notifications.NotificationAction;

public class NewProjectsNotification
extends Notification {
    private List<IServer> servers;

    @Inject
    public NewProjectsNotification(IEventBroker broker) {
        super("org.eclipse.epp.logging.aeri.notifications.event.setup", broker);
    }

    @Override
    public List<NotificationAction> getActions() {
        NotificationAction a1 = new NotificationAction("Enable..."){

            @Override
            public void execute() {
                NewProjectsNotification.this.closeWithEvent("org/eclipse/epp/internal/logging/aeri/ui/servers/setup", null);
            }
        };
        NotificationAction a2 = new NotificationAction("Disable"){

            @Override
            public void execute() {
                NewProjectsNotification.this.closeWithEvent("org/eclipse/epp/internal/logging/aeri/ui/servers/disabled", null);
            }
        };
        return Lists.newArrayList((Object[])new NotificationAction[]{a1, a2});
    }

    @Override
    public String getTitle() {
        double[] limits = new double[]{1.0, 2.0, 3.0, 4.0};
        String[] formats = new String[]{"One project", "Two projects", "Three projects", "Several projects"};
        String start = new ChoiceFormat(limits, formats).format(this.servers.size());
        return String.valueOf(start) + " signed up to receive problem reports";
    }

    public String getLabel() {
        String name = this.servers.get(0).getName();
        double[] limits = new double[]{1.0, 2.0, 3.0, 4.0};
        String[] formats = new String[]{"", "and one more project", "and two more projects", "and several projects more"};
        String start = new ChoiceFormat(limits, formats).format(this.servers.size());
        return MessageFormat.format("{0} {1} signed up to receive problem reports. Do you want to help?", name, start);
    }

    public String getDescription() {
        LinkedList names = Lists.newLinkedList();
        for (IServer server : this.servers) {
            names.add(server.getName());
        }
        double[] limits = new double[]{1.0, 2.0};
        String[] itThey = new String[]{"it", "they"};
        String itTheyS = new ChoiceFormat(limits, itThey).format(this.servers.size());
        String[] thisThese = new String[]{"this project", "these projects"};
        String thisTheseProjects = new ChoiceFormat(limits, thisThese).format(this.servers.size());
        String projects = Joiner.on((String)", ").join((Iterable)names);
        return MessageFormat.format("{0} noticed a problem {1} would like to send to the development team. If you want to enable error reporting for {2}, click enable... below.", projects, itTheyS, thisTheseProjects);
    }

    public void setServers(List<IServer> servers) {
        this.servers = servers;
    }
}

