/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ui.notifications;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.epp.internal.logging.aeri.ui.model.ILogEvent;
import org.eclipse.epp.internal.logging.aeri.ui.model.ILogEventGroup;
import org.eclipse.epp.internal.logging.aeri.ui.model.IProblemState;
import org.eclipse.epp.internal.logging.aeri.ui.model.IServer;
import org.eclipse.epp.internal.logging.aeri.ui.notifications.Notification;
import org.eclipse.epp.internal.logging.aeri.ui.notifications.NotificationAction;
import org.eclipse.epp.internal.logging.aeri.ui.utils.UI;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.mylyn.commons.ui.compatibility.CommonColors;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;

public class LogEventGroupResponsesNotification
extends Notification {
    private ILogEventGroup group;
    private ImageRegistry registry;

    @Inject
    public LogEventGroupResponsesNotification(ILogEventGroup group, ImageRegistry registry, IEventBroker broker) {
        super("org.eclipse.epp.logging.aeri.notifications.event.responses", broker);
        this.group = group;
        this.registry = registry;
    }

    public Control createControl(Composite parent) {
        GridDataFactory asis = GridDataFactory.fillDefaults().align(4, 128);
        GridDataFactory w400 = GridDataFactory.fillDefaults().hint(400, -1).grab(false, false).align(4, 128);
        GridDataFactory w360 = GridDataFactory.fillDefaults().hint(370, -1).grab(false, false).align(4, 128);
        Composite container = new Composite(parent, 524288);
        GridLayoutFactory.fillDefaults().extendedMargins(0, 0, 0, 0).applyTo(container);
        w400.applyTo((Control)container);
        String labelText = this.getLabel();
        if (StringUtils.isNotBlank((CharSequence)labelText)) {
            Link label = new Link(container, 524352);
            label.setText(labelText);
            label.setForeground(CommonColors.TEXT_QUOTED);
            w400.applyTo((Control)label);
        }
        Link description = new Link(container, 524352);
        description.setText(this.getDescription());
        w400.applyTo((Control)description);
        Composite serverSections = new Composite(container, 524288);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).applyTo(serverSections);
        for (ILogEvent event : this.group.getEvents()) {
            IServer server = event.getServer();
            IProblemState response = event.getResponse();
            Label icon = new Label(serverSections, 524288);
            Image image = UI.decorate(server, response.getStatus(), this.registry);
            icon.setImage(image);
            asis.applyTo((Control)icon);
            Link message = new Link(serverSections, 524352);
            w360.applyTo((Control)message);
            message.setText(StringUtils.defaultString((String)response.getMessage()));
            message.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    LogEventGroupResponsesNotification.this.broker.send("org/eclipse/epp/internal/logging/aeri/ui/event/open-url", (Object)e.text);
                }
            });
        }
        return container;
    }

    @Override
    public String getTitle() {
        return "Thank you. Your report(s) were sent.";
    }

    public String getLabel() {
        return "";
    }

    public String getDescription() {
        Throwable exception = (Throwable)Preconditions.checkNotNull((Object)this.group.getStatus().getException());
        String message = String.valueOf(exception.getClass().getSimpleName()) + ": " + (String)Optional.fromNullable((Object)exception.getMessage()).or((Object)"");
        StringUtils.abbreviate((String)message, (int)80);
        return "Your reports for '" + StringUtils.abbreviate((String)this.group.getStatus().getMessage(), (int)80) + "' were delivered. See the project responses below:";
    }

    @Override
    public List<NotificationAction> getActions() {
        throw new IllegalStateException("Operation not supported");
    }
}

