/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ui.notifications;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.epp.internal.logging.aeri.ui.l10n.Messages;
import org.eclipse.epp.internal.logging.aeri.ui.model.ILogEvent;
import org.eclipse.epp.internal.logging.aeri.ui.model.ILogEventGroup;
import org.eclipse.epp.internal.logging.aeri.ui.model.IProblemState;
import org.eclipse.epp.internal.logging.aeri.ui.model.IServer;
import org.eclipse.epp.internal.logging.aeri.ui.notifications.Notification;
import org.eclipse.epp.internal.logging.aeri.ui.notifications.NotificationAction;
import org.eclipse.epp.internal.logging.aeri.ui.utils.Browsers;
import org.eclipse.epp.internal.logging.aeri.ui.utils.UI;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.mylyn.commons.ui.compatibility.CommonColors;
import org.eclipse.mylyn.commons.workbench.forms.ScalingHyperlink;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;

public class LogEventGroupLoggedNotification
extends Notification {
    private ILogEventGroup group;
    private ImageRegistry registry;

    @Inject
    public LogEventGroupLoggedNotification(ILogEventGroup group, ImageRegistry registry, IEventBroker broker) {
        super("org.eclipse.epp.logging.aeri.notifications.event.newProblem", broker);
        this.group = group;
        this.registry = registry;
    }

    public Control createControl(Composite parent) {
        GridDataFactory asis = GridDataFactory.fillDefaults().align(4, 128);
        GridDataFactory w400 = GridDataFactory.fillDefaults().hint(400, -1).grab(false, false).align(4, 128);
        GridDataFactory w360 = GridDataFactory.fillDefaults().hint(370, -1).grab(false, false).align(4, 128);
        Composite container = new Composite(parent, 524288);
        GridLayoutFactory.fillDefaults().extendedMargins(0, 0, 0, 0).applyTo(container);
        w400.applyTo((Control)container);
        Link label = new Link(container, 524352);
        label.setText(this.getLabel());
        label.setForeground(CommonColors.TEXT_QUOTED);
        w400.applyTo((Control)label);
        Link description = new Link(container, 524352);
        description.setText(this.getDescription());
        w400.applyTo((Control)description);
        Composite serverSections = new Composite(container, 524288);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).applyTo(serverSections);
        for (ILogEvent event : this.group.getEvents()) {
            IServer server = event.getServer();
            IProblemState interest = event.getPredictedProblemState();
            Label icon = new Label(serverSections, 524288);
            Image image = UI.decorate(server, interest.getStatus(), this.registry);
            icon.setImage(image);
            asis.applyTo((Control)icon);
            Link response = new Link(serverSections, 524352);
            w360.applyTo((Control)response);
            response.setText(this.getMessage(server, interest));
            response.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Browsers.openInExternalBrowser(e.text);
                }
            });
        }
        Link label2 = new Link(container, 524352);
        label2.setText("Do you want to report that error?");
        w400.applyTo((Control)label);
        this.createLinkSection(container);
        return container;
    }

    private String getMessage(IServer server, IProblemState interest) {
        String message = interest.getMessage();
        if (StringUtils.isBlank((CharSequence)message)) {
            switch (interest.getStatus()) {
                case NEW: {
                    message = String.valueOf(server.getName()) + ": new problem";
                    break;
                }
                case UNCONFIRMED: {
                    message = String.valueOf(server.getName()) + ": unconfirmed problem";
                    break;
                }
                case CONFIRMED: {
                    message = String.valueOf(server.getName()) + ": confirmed problem";
                    break;
                }
                case NEEDINFO: {
                    message = String.valueOf(server.getName()) + ": needinfo problem";
                    break;
                }
                case FIXED: {
                    message = String.valueOf(server.getName()) + ": fixed problem";
                    break;
                }
                case IGNORED: {
                    message = String.valueOf(server.getName()) + ": ignored problem";
                    break;
                }
                case INVALID: {
                    message = String.valueOf(server.getName()) + ": invalid problem";
                    break;
                }
                case FAILURE: {
                    message = String.valueOf(server.getName()) + " encountered a failure.";
                }
            }
        }
        return message;
    }

    protected void createLinkSection(Composite container) {
        Color linkColor = JFaceResources.getColorRegistry().get("HYPERLINK_COLOR");
        Composite linksComposite = new Composite(container, 524288);
        GridDataFactory.fillDefaults().align(0x1000008, 128).applyTo((Control)linksComposite);
        GridLayoutFactory.fillDefaults().numColumns(3).margins(40, 0).applyTo(linksComposite);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)new Label(linksComposite, 0));
        ScalingHyperlink showLink = new ScalingHyperlink(linksComposite, 524288);
        GridDataFactory.swtDefaults().applyTo((Control)showLink);
        showLink.setText("View Details...");
        showLink.setForeground(linkColor);
        showLink.registerMouseTrackListener();
        showLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                LogEventGroupLoggedNotification.this.closeWithEvent("org/eclipse/epp/internal/logging/aeri/ui/event/review", LogEventGroupLoggedNotification.this.group);
            }
        });
        ScalingHyperlink sendLink = new ScalingHyperlink(linksComposite, 524288);
        GridDataFactory.swtDefaults().applyTo((Control)sendLink);
        sendLink.setText("Send");
        sendLink.setForeground(linkColor);
        sendLink.registerMouseTrackListener();
        sendLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                LogEventGroupLoggedNotification.this.closeWithEvent("org/eclipse/epp/internal/logging/aeri/ui/event/send", LogEventGroupLoggedNotification.this.group);
            }
        });
    }

    protected String getResponse(IServer server, IProblemState interest) {
        StringBuilder sb = new StringBuilder();
        switch (interest.getStatus()) {
            case NEW: {
                sb.append(NLS.bind((String)Messages.NOTIFY_INTEREST_PROBLEM_NEW, (Object)server.getName(), (Object)interest.getMessage()));
                break;
            }
            case UNCONFIRMED: {
                sb.append(NLS.bind((String)Messages.NOTIFY_INTEREST_PROBLEM_UNCONFIRMED, (Object)server.getName(), (Object)interest.getMessage()));
                break;
            }
            case CONFIRMED: {
                sb.append(NLS.bind((String)Messages.NOTIFY_INTEREST_PROBLEM_CONFIRMED, (Object)server.getName(), (Object)interest.getMessage()));
                break;
            }
            case NEEDINFO: {
                sb.append(NLS.bind((String)Messages.NOTIFY_INTEREST_PROBLEM_NEEDINFO, (Object)server.getName(), (Object)interest.getMessage()));
                break;
            }
            case FIXED: {
                sb.append(NLS.bind((String)Messages.NOTIFY_INTEREST_PROBLEM_FIXED, (Object)server.getName(), (Object)interest.getMessage()));
                break;
            }
            case IGNORED: {
                sb.append(NLS.bind((String)Messages.NOTIFY_INTEREST_PROBLEM_IGNORED, (Object)server.getName(), (Object)interest.getMessage()));
                break;
            }
            case INVALID: {
                sb.append(NLS.bind((String)Messages.NOTIFY_INTEREST_PROBLEM_INVALID, (Object)server.getName(), (Object)interest.getMessage()));
                break;
            }
            case FAILURE: {
                sb.append(NLS.bind((String)Messages.NOTIFY_INTEREST_PROBLEM_FAILURE, (Object)server.getName(), (Object)interest.getMessage()));
            }
        }
        return sb.toString();
    }

    @Override
    public String getTitle() {
        return "Problem logged in " + this.group.getStatus().getPlugin();
    }

    public String getLabel() {
        return "Message: " + StringUtils.abbreviate((String)this.group.getStatus().getMessage(), (int)80);
    }

    public String getDescription() {
        Throwable exception = (Throwable)Preconditions.checkNotNull((Object)this.group.getStatus().getException());
        String message = String.valueOf(exception.getClass().getSimpleName()) + ": " + (String)Optional.fromNullable((Object)exception.getMessage()).or((Object)"");
        String exceptionHeadline = StringUtils.abbreviate((String)message, (int)80);
        return exceptionHeadline;
    }

    @Override
    public List<NotificationAction> getActions() {
        throw new IllegalStateException("Operation not supported");
    }
}

