/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ui.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Severity implements Enumerator
{
    UNKNOWN(0, "UNKNOWN", "UNKNOWN"),
    CRITICAL(1, "CRITICAL", "CRITICAL"),
    MAJOR(2, "MAJOR", "MAJOR"),
    MINOR(3, "MINOR", "MINOR"),
    ENHANCEMENT(4, "ENHANCEMENT", "ENHANCEMENT"),
    NO_BUG(5, "NO_BUG", "NO_BUG");

    public static final int UNKNOWN_VALUE = 0;
    public static final int CRITICAL_VALUE = 1;
    public static final int MAJOR_VALUE = 2;
    public static final int MINOR_VALUE = 3;
    public static final int ENHANCEMENT_VALUE = 4;
    public static final int NO_BUG_VALUE = 5;
    private static final Severity[] VALUES_ARRAY;
    public static final List<Severity> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Severity[]{UNKNOWN, CRITICAL, MAJOR, MINOR, ENHANCEMENT, NO_BUG};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Severity get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Severity result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Severity getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Severity result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Severity get(int value) {
        switch (value) {
            case 0: {
                return UNKNOWN;
            }
            case 1: {
                return CRITICAL;
            }
            case 2: {
                return MAJOR;
            }
            case 3: {
                return MINOR;
            }
            case 4: {
                return ENHANCEMENT;
            }
            case 5: {
                return NO_BUG;
            }
        }
        return null;
    }

    private Severity(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

