/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ui.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum SendMode implements Enumerator
{
    NOTIFY(0, "NOTIFY", "NOTIFY"),
    BACKGROUND(1, "BACKGROUND", "BACKGROUND"),
    NEVER(2, "NEVER", "NEVER");

    public static final int NOTIFY_VALUE = 0;
    public static final int BACKGROUND_VALUE = 1;
    public static final int NEVER_VALUE = 2;
    private static final SendMode[] VALUES_ARRAY;
    public static final List<SendMode> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new SendMode[]{NOTIFY, BACKGROUND, NEVER};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static SendMode get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SendMode result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SendMode getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SendMode result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SendMode get(int value) {
        switch (value) {
            case 0: {
                return NOTIFY;
            }
            case 1: {
                return BACKGROUND;
            }
            case 2: {
                return NEVER;
            }
        }
        return null;
    }

    private SendMode(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

