/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ui.model;

import com.google.common.base.Preconditions;
import java.util.concurrent.TimeUnit;
import org.eclipse.epp.internal.logging.aeri.ui.model.ISystemSettings;
import org.eclipse.epp.internal.logging.aeri.ui.model.ResetSendMode;
import org.eclipse.epp.internal.logging.aeri.ui.model.SendMode;
import org.eclipse.epp.internal.logging.aeri.ui.model.impl.SystemSettingsImpl;

public class CustomSystemSettings
extends SystemSettingsImpl {
    private static final boolean SYSTEM_DISABLED = Boolean.getBoolean("org.eclipse.epp.logging.aeri.ui.skipReports");

    protected CustomSystemSettings() {
    }

    public static void resetSendMode(ISystemSettings settings) {
        settings.setResetSendModeOn(0L);
        settings.setResetSendMode(ResetSendMode.KEEP);
        settings.setSendMode(SendMode.NOTIFY);
    }

    @Override
    public boolean isEnabled() {
        if (SYSTEM_DISABLED) {
            return false;
        }
        SendMode mode = this.getSendMode();
        switch (mode) {
            case NEVER: {
                ResetSendMode reset = this.getResetSendMode();
                switch (reset) {
                    case HOURS_24: {
                        long resetOn = this.getResetSendModeOn();
                        if (resetOn >= System.currentTimeMillis()) break;
                        CustomSystemSettings.resetSendMode(this);
                        return true;
                    }
                }
                return false;
            }
        }
        return true;
    }

    @Override
    public void pause(ResetSendMode when) {
        this.setSendMode(SendMode.NEVER);
        this.setResetSendMode(when);
        switch (when) {
            case HOURS_24: {
                this.setResetSendModeOn(CustomSystemSettings.in24Hours());
                break;
            }
            case RESTART: 
            case PERMANENT: {
                this.setResetSendModeOn(0L);
                break;
            }
            default: {
                Preconditions.checkState((boolean)false);
            }
        }
    }

    @Override
    public void silent(ResetSendMode when) {
        this.setSendMode(SendMode.BACKGROUND);
        this.setResetSendMode(when);
        switch (when) {
            case HOURS_24: {
                this.setResetSendModeOn(CustomSystemSettings.in24Hours());
                break;
            }
            case RESTART: 
            case PERMANENT: {
                this.setResetSendModeOn(0L);
                break;
            }
            default: {
                Preconditions.checkState((boolean)false);
            }
        }
    }

    private static long in24Hours() {
        return System.currentTimeMillis() + TimeUnit.DAYS.toMillis(1L);
    }
}

