/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ui.model;

import com.google.common.base.Throwables;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.epp.internal.logging.aeri.ui.dialogs.ConfigureServerDialog;
import org.eclipse.epp.internal.logging.aeri.ui.l10n.LogMessages;
import org.eclipse.epp.internal.logging.aeri.ui.l10n.Logs;
import org.eclipse.epp.internal.logging.aeri.ui.model.ILink;
import org.eclipse.epp.internal.logging.aeri.ui.model.IProblemState;
import org.eclipse.epp.internal.logging.aeri.ui.model.IReport;
import org.eclipse.epp.internal.logging.aeri.ui.model.IServer;
import org.eclipse.epp.internal.logging.aeri.ui.model.impl.ServerImpl;
import org.eclipse.epp.logging.aeri.ui.IServerConnection;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;

public class CustomServer
extends ServerImpl {
    @Nullable
    private Image icon16;
    @Nullable
    private Image icon32;
    @Nullable
    private Image icon64;

    protected CustomServer() {
    }

    @Override
    public synchronized Image getImage16() {
        if (this.icon16 == null) {
            this.icon16 = this.loadImage(this.getIcon16());
        }
        return this.icon16;
    }

    @Override
    public synchronized Image getImage32() {
        if (this.icon32 == null) {
            this.icon32 = this.loadImage(this.getIcon32());
        }
        return this.icon32;
    }

    @Override
    public synchronized Image getImage64() {
        if (this.icon64 == null) {
            this.icon64 = this.loadImage(this.getIcon64());
        }
        return this.icon64;
    }

    private Image loadImage(String path) {
        try {
            return AbstractUIPlugin.imageDescriptorFromPlugin((String)this.getContributor(), (String)path).createImage();
        }
        catch (Exception e) {
            Logs.log(LogMessages.WARN_SERVER_FAILURE, e, this.getId(), e.getMessage());
            return ImageDescriptor.getMissingImageDescriptor().createImage();
        }
    }

    @Override
    public IProblemState interested(IStatus status, IEclipseContext context, IProgressMonitor monitor) {
        return this.getConnection().interested(status, context, monitor);
    }

    @Override
    public IReport transform(IStatus status, IEclipseContext context) {
        return this.getConnection().transform(status, context);
    }

    @Override
    public IProblemState send(IStatus status, IEclipseContext context, IProgressMonitor monitor) throws Exception {
        return this.getConnection().submit(status, context, monitor);
    }

    @Override
    public void discarded(IStatus status, IEclipseContext context) {
        this.getConnection().discarded(status, context);
    }

    @Override
    public boolean isActive() {
        return this.isEnabled() && this.isConfigured();
    }

    @Override
    public boolean isConfigurable() {
        return StringUtils.isNotBlank((CharSequence)this.getConfigureDialogClassName());
    }

    @Nullable
    private String getConfigureDialogClassName() {
        IConfigurationElement element = this.getConfigurationElement();
        Object[] children = element.getChildren("configure");
        if (ArrayUtils.isEmpty((Object[])children)) {
            return null;
        }
        return children[0].getAttribute("dialog");
    }

    @Override
    public Dialog createConfigureDialog(IEclipseContext context) {
        String clazzName = this.getConfigureDialogClassName();
        if (clazzName == null) {
            Dialog object = (Dialog)ContextInjectionFactory.make(ConfigureServerDialog.class, (IEclipseContext)context);
            return object;
        }
        context.set(IServer.class, (Object)this);
        String contributor = this.getContributor();
        Bundle ext = Platform.getBundle((String)contributor);
        try {
            Class clazz = ext.loadClass(clazzName);
            Dialog object = (Dialog)ContextInjectionFactory.make((Class)clazz, (IEclipseContext)context);
            return object;
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public IServerConnection createConnection(IEclipseContext context) {
        String contributor = this.getContributor();
        Bundle ext = Platform.getBundle((String)contributor);
        String clazzName = this.getClazz();
        try {
            Class clazz = ext.loadClass(clazzName);
            IServerConnection object = (IServerConnection)ContextInjectionFactory.make((Class)clazz, (IEclipseContext)context);
            return object;
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public ILink getLink(String rel) {
        return (ILink)super.getLinks().get((Object)rel);
    }
}

