/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ui.m0;

import com.google.common.base.Charsets;
import com.google.common.hash.Hasher;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.epp.internal.logging.aeri.ui.m0.StatusSwitch;
import org.eclipse.epp.internal.logging.aeri.ui.utils.Reports;

public class Statuses {
    public static String newThrowableFingerprint(Throwable input, boolean includeMessages, boolean includeLineNumbers) {
        Hasher hasher = Reports.newHasher();
        new TraceFingerprintComputer(hasher, includeLineNumbers, includeMessages).doSwitch(input);
        return hasher.hash().toString();
    }

    public static String traceIdentityHash(IStatus report) {
        Hasher hasher = Reports.newHasher();
        new TraceFingerprintComputer(hasher, true, false).doSwitch(report);
        return hasher.hash().toString();
    }

    private static final class TraceFingerprintComputer
    extends StatusSwitch<Hasher> {
        private final Hasher hasher;
        private final boolean includeLineNumbers;
        private final boolean includeMessages;

        private TraceFingerprintComputer(Hasher hasher, boolean includeLineNumbers, boolean includeMessages) {
            this.hasher = hasher;
            this.includeLineNumbers = includeLineNumbers;
            this.includeMessages = includeMessages;
        }

        @Override
        public Hasher caseStackTraceElement(StackTraceElement object) {
            this.hasher.putString((CharSequence)StringUtils.stripToEmpty((String)object.getClassName()), Charsets.UTF_8);
            this.hasher.putString((CharSequence)StringUtils.stripToEmpty((String)object.getMethodName()), Charsets.UTF_8);
            if (this.includeLineNumbers) {
                this.hasher.putInt(object.getLineNumber());
            }
            return null;
        }

        @Override
        public Hasher caseThrowable(Throwable object) {
            if (this.includeMessages) {
                this.hasher.putString((CharSequence)StringUtils.stripToEmpty((String)object.getMessage()), Charsets.UTF_8);
            }
            return null;
        }
    }
}

