/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ui.m0;

import com.google.common.base.Predicate;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.epp.internal.logging.aeri.ui.m0.RemoteConfiguration;
import org.eclipse.epp.internal.logging.aeri.ui.m0.StatusSwitch;
import org.eclipse.epp.internal.logging.aeri.ui.utils.Statuses;
import org.eclipse.jdt.annotation.Nullable;

public class StatusFilters {

    public static class AcceptFreezeFilter
    implements Predicate<IStatus> {
        private boolean acceptUIFreezes;

        public AcceptFreezeFilter(boolean acceptUIFreezes) {
            this.acceptUIFreezes = acceptUIFreezes;
        }

        public boolean apply(IStatus input) {
            boolean valid;
            boolean freeze = Statuses.isUiFreeze(input);
            if (!freeze) {
                return true;
            }
            boolean bl = valid = !ArrayUtils.isEmpty((Object[])input.getChildren());
            return this.acceptUIFreezes && valid;
        }
    }

    public static class AcceptOtherPackagesPredicate
    implements Predicate<IStatus> {
        private List<Pattern> patterns;
        private boolean acceptOtherPackages;

        public AcceptOtherPackagesPredicate(List<Pattern> patterns, boolean acceptOtherPackages) {
            this.patterns = patterns;
            this.acceptOtherPackages = acceptOtherPackages;
        }

        public boolean apply(IStatus report) {
            return this.acceptOtherPackages || this.containsNoOtherClasses(report);
        }

        private boolean containsNoOtherClasses(IStatus status) {
            Boolean res = (Boolean)new StatusSwitch<Boolean>(){

                @Override
                public Boolean caseStackTraceElement(StackTraceElement object) {
                    Iterator iterator = AcceptOtherPackagesPredicate.this.patterns.iterator();
                    while (iterator.hasNext()) {
                        Pattern cfr_ignored_0 = (Pattern)iterator.next();
                        if (!Pattern.matches(object.getClassName(), object.getClassName())) continue;
                        return null;
                    }
                    return Boolean.FALSE;
                }
            }.doSwitch(status);
            return res == null;
        }
    }

    public static class AcceptedPackagesFilter
    implements Predicate<IStatus> {
        private List<Pattern> patterns;

        public AcceptedPackagesFilter(List<Pattern> patterns) {
            this.patterns = patterns;
        }

        public boolean apply(IStatus input) {
            Test res = (Test)((Object)new StatusSwitch<Test>(){

                @Override
                @Nullable
                public Test caseStackTraceElement(StackTraceElement stackTraceElement) {
                    String label = String.valueOf(stackTraceElement.getClassName()) + "." + stackTraceElement.getMethodName();
                    for (Pattern pattern : AcceptedPackagesFilter.this.patterns) {
                        if (pattern.matcher(label).matches()) continue;
                        return Test.FAIL;
                    }
                    return null;
                }
            }.doSwitch(input));
            return res != Test.FAIL;
        }
    }

    public static class AcceptedPluginsFilter
    implements Predicate<IStatus> {
        private List<Pattern> patterns;

        public AcceptedPluginsFilter(List<Pattern> patterns) {
            this.patterns = patterns;
        }

        public boolean apply(IStatus input) {
            String pluginId = input.getPlugin();
            for (Pattern pattern : this.patterns) {
                if (!pattern.matcher(pluginId).matches()) continue;
                return true;
            }
            return false;
        }
    }

    public static class AcceptedProductsFilter
    implements Predicate<IStatus> {
        private List<Pattern> patterns;

        public AcceptedProductsFilter(List<Pattern> patterns) {
            this.patterns = patterns;
        }

        public boolean apply(IStatus input) {
            String product = System.getProperty("eclipse.product");
            return product == null ? false : this.isAccepted(product);
        }

        private boolean isAccepted(String product) {
            for (Pattern pattern : this.patterns) {
                if (!pattern.matcher(product).matches()) continue;
                return true;
            }
            return false;
        }
    }

    public static class IgnorePatternsFilter
    implements Predicate<IStatus> {
        private List<RemoteConfiguration.IgnorePattern> patterns;

        public IgnorePatternsFilter(List<RemoteConfiguration.IgnorePattern> patterns) {
            this.patterns = patterns;
        }

        public boolean apply(IStatus input) {
            for (RemoteConfiguration.IgnorePattern pattern : this.patterns) {
                if (!pattern.matches(input)) continue;
                return false;
            }
            return true;
        }
    }

    private static enum Test {
        PASS,
        FAIL,
        UNDEF;

    }
}

