/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ui.m0;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.util.concurrent.AbstractIdleService;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.fluent.Executor;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.epp.internal.logging.aeri.ui.l10n.LogMessages;
import org.eclipse.epp.internal.logging.aeri.ui.l10n.Logs;
import org.eclipse.epp.internal.logging.aeri.ui.l10n.Messages;
import org.eclipse.epp.internal.logging.aeri.ui.m0.IO;
import org.eclipse.epp.internal.logging.aeri.ui.m0.LocalReportsHistory;
import org.eclipse.epp.internal.logging.aeri.ui.m0.RemoteConfiguration;
import org.eclipse.epp.internal.logging.aeri.ui.m0.RemoteProblemsHistory;
import org.eclipse.epp.internal.logging.aeri.ui.m0.StatusFilters;
import org.eclipse.epp.internal.logging.aeri.ui.model.IProblemState;
import org.eclipse.epp.internal.logging.aeri.ui.model.IReport;
import org.eclipse.epp.internal.logging.aeri.ui.model.ISendOptions;
import org.eclipse.epp.internal.logging.aeri.ui.model.IServer;
import org.eclipse.epp.internal.logging.aeri.ui.model.ISystemSettings;
import org.eclipse.epp.internal.logging.aeri.ui.model.ProblemStatus;
import org.eclipse.epp.internal.logging.aeri.ui.utils.AnonymousId;
import org.eclipse.epp.internal.logging.aeri.ui.utils.Constants;
import org.eclipse.epp.internal.logging.aeri.ui.utils.DebugFilter;
import org.eclipse.epp.internal.logging.aeri.ui.utils.Formats;
import org.eclipse.epp.internal.logging.aeri.ui.utils.Reports;
import org.eclipse.epp.internal.logging.aeri.ui.utils.Servers;
import org.eclipse.epp.logging.aeri.ui.IServerConnection;

public class ServerConnection
extends AbstractIdleService
implements IServerConnection {
    private final IServer server;
    private final ISystemSettings systemSettings;
    private final File configurationArea;
    private Predicate<IStatus> statusFilters = Predicates.alwaysFalse();
    private IO io;
    private RemoteProblemsHistory remoteHistory;
    private LocalReportsHistory localHistory;

    @Inject
    public ServerConnection(IServer descriptor, ISystemSettings system, File configurationArea) {
        this.systemSettings = (ISystemSettings)Preconditions.checkNotNull((Object)system);
        this.configurationArea = (File)Preconditions.checkNotNull((Object)configurationArea);
        this.server = (IServer)Preconditions.checkNotNull((Object)descriptor);
    }

    @PostConstruct
    private void e4Start() {
        this.startAsync();
    }

    protected void startUp() throws Exception {
        try {
            File remoteHistoryStateLocation = new File(this.configurationArea, "remote-history");
            this.remoteHistory = new RemoteProblemsHistory(remoteHistoryStateLocation);
            this.remoteHistory.startAsync();
            File localHistoryStateLocation = new File(this.configurationArea, "local-history");
            localHistoryStateLocation.mkdirs();
            this.localHistory = new LocalReportsHistory(localHistoryStateLocation);
            this.localHistory.startAsync();
            File file = new File(this.configurationArea, "server-config.json");
            this.io = new IO(Executor.newInstance(), file);
            if (file.exists()) {
                this.io.loadConfiguration();
            }
            if (this.io.isConfigurationOutdated()) {
                this.io.refreshConfiguration((String)Preconditions.checkNotNull((Object)Servers.getLinkHref(this.server, "discovery")), (IProgressMonitor)new NullProgressMonitor());
                this.io.saveConfiguration();
            }
            if (this.io.isProblemsDatabaseOutdated()) {
                new RemoteProblemsHistory.UpdateIndexJob(this.io, this.systemSettings, this.remoteHistory).schedule(TimeUnit.MINUTES.toMillis(5L));
            }
            RemoteConfiguration configuration = this.io.getConfiguration();
            Preconditions.checkNotNull((Object)configuration, (Object)"no configuration available");
            Preconditions.checkNotNull((Object)((Object)this.localHistory));
            Predicate<T>[] statusFilters = DebugFilter.decorate(new LocalReportsHistory.LocalHistorySeenFilter(this.localHistory, this.systemSettings), new StatusFilters.AcceptedProductsFilter(configuration.getAcceptedProductsPatterns()), new StatusFilters.AcceptedPluginsFilter(configuration.getAcceptedPluginsPatterns()), new StatusFilters.IgnorePatternsFilter(configuration.getIgnoredPluginMessagesPatterns()), new StatusFilters.AcceptFreezeFilter(configuration.isAcceptUiFreezes()));
            this.statusFilters = Predicates.and(statusFilters);
        }
        catch (Exception e) {
            Logs.log(LogMessages.WARN_SERVER_FAILURE, e, this.server.getId(), e.getMessage());
            this.stopAsync();
        }
    }

    @Override
    public IProblemState interested(IStatus status, IEclipseContext context, IProgressMonitor monitor) {
        if (!this.isRunning() || !this.statusFilters.apply((Object)status)) {
            IProblemState res = Constants.eFac.createProblemState();
            res.setStatus(ProblemStatus.IGNORED);
            return res;
        }
        IProblemState seen = this.remoteHistory.seen(status);
        String message = seen.getMessage();
        if (seen.getMessage() != null) {
            return seen;
        }
        switch (seen.getStatus()) {
            case IGNORED: {
                return seen;
            }
            case NEEDINFO: {
                message = this.msgNeedinfoBeforeSend(seen);
                break;
            }
            case FIXED: {
                message = this.msgFixedBeforeSend(seen);
                break;
            }
            case UNCONFIRMED: {
                message = this.msgUnconfirmedBeforeSend(seen);
                break;
            }
            default: {
                message = Formats.format("Unexpected state {0}", new Object[]{seen.getStatus()});
            }
        }
        seen.setMessage(message);
        return seen;
    }

    @Override
    public IReport transform(IStatus status, IEclipseContext context) {
        ISendOptions options = (ISendOptions)Preconditions.checkNotNull((Object)((ISendOptions)context.get(ISendOptions.class)));
        IReport report = Reports.newReport(status);
        report.setComment(options.getComment());
        report.setAnonymousId(AnonymousId.getId());
        report.setName(options.getReporterName());
        report.setEmail(options.getReporterEmail());
        report.setSeverity(options.getSeverity());
        if (options.isAnonymizeMessages()) {
            Reports.anonymizeMessages(report);
        }
        if (options.isAnonymizeStackTraces()) {
            Reports.anonymizeStackTraces(report, this.io.getConfiguration().getAcceptedPackagesPatterns());
        }
        return report;
    }

    @Override
    public IProblemState submit(IStatus status, IEclipseContext context, IProgressMonitor monitor) throws IOException {
        IReport report = this.transform(status, context);
        IProblemState response = this.io.upload(report, monitor);
        this.localHistory.remember(status);
        String message = response.getMessage();
        if (StringUtils.isNotBlank((CharSequence)message)) {
            message = Formats.format(Messages.PROBLEM_MESSAGES_FORWARD_SERVER_RESPONSE, this.server.getName(), message);
            response.setMessage(message);
            return response;
        }
        switch (response.getStatus()) {
            case NEW: {
                message = this.msgNewAfterSend(response);
                break;
            }
            case UNCONFIRMED: {
                message = this.msgUnconfirmedAfterSend(response);
                break;
            }
            case CONFIRMED: {
                message = this.msgConfirmedAfterSend(response);
                break;
            }
            case FIXED: {
                message = this.msgFixedAfterSend(response);
                break;
            }
            case NEEDINFO: {
                message = this.msgNeedinfoAfterSend(response);
                break;
            }
            case FAILURE: {
                message = "{0} encountered a failure while sending the problem report.";
                break;
            }
            case INVALID: 
            case IGNORED: {
                message = "{0} says: This message has be triaged and marked as being a (may too verbose) log message.";
            }
        }
        response.setMessage(message);
        return response;
    }

    @Override
    public void discarded(IStatus status, IEclipseContext context) {
        this.localHistory.remember(status);
    }

    protected String msgNewAfterSend(IProblemState response) {
        return Formats.format(Messages.PROBLEM_MESSAGES_NEW_AFTER_SEND, this.server.getName(), response);
    }

    protected String msgUnconfirmedBeforeSend(IProblemState cachedState) {
        return Formats.format(Messages.PROBLEM_MESSAGES_UNCONFIRMED_BEFORE_SEND, this.server.getName(), cachedState);
    }

    protected String msgUnconfirmedAfterSend(IProblemState response) {
        return Formats.format(Messages.PROBLEM_MESSAGES_UNCONFIRMED_AFTER_SEND, this.server.getName(), response);
    }

    protected String msgConfirmedAfterSend(IProblemState response) {
        if (response.hasLink("bug")) {
            return Formats.format(Messages.PROBLEM_MESSAGES_CONFIRMED_BUG_AFTER_SEND, this.server.getName(), response);
        }
        return Formats.format(Messages.PROBLEM_MESSAGES_CONFIRMED_NO_BUG_AFTER_SEND, this.server.getName(), response);
    }

    protected String msgNeedinfoBeforeSend(IProblemState cachedState) {
        if (cachedState.hasLink("bug")) {
            return Formats.format(Messages.PROBLEM_MESSAGES_NEEDINFO_BUG_BEFORE_SEND, this.server.getName(), cachedState);
        }
        return Formats.format(Messages.PROBLEM_MESSAGES_NEEDINFO_NO_BUG_BEFORE_SEND, this.server.getName(), cachedState);
    }

    protected String msgNeedinfoAfterSend(IProblemState response) {
        if (response.hasLink("bug")) {
            return Formats.format(Messages.PROBLEM_MESSAGES_NEEDINFO_BUG_AFTER_SEND, this.server.getName(), response);
        }
        return Formats.format(Messages.PROBLEM_MESSAGES_NEEDINFO_NO_BUG_AFTER_SEND, this.server.getName(), response);
    }

    protected String msgFixedBeforeSend(IProblemState cachedState) {
        if (cachedState.hasLink("bug")) {
            return Formats.format(Messages.PROBLEM_MESSAGES_FIXED_BUG_BEFORE_SEND, this.server.getName(), cachedState);
        }
        return Formats.format(Messages.PROBLEM_MESSAGES_FIXED_NO_BUG_BEFORE_SEND, this.server.getName(), cachedState);
    }

    protected String msgFixedAfterSend(IProblemState response) {
        if (response.hasLink("bug")) {
            return Formats.format(Messages.PROBLEM_MESSAGES_FIXED_BUG_AFTER_SEND, this.server.getName(), response);
        }
        return Formats.format(Messages.PROBLEM_MESSAGES_FIXED_NO_BUG_AFTER_SEND, this.server.getName(), response);
    }

    @PreDestroy
    private void diStop() throws TimeoutException {
        this.stopAsync().awaitTerminated(2L, TimeUnit.SECONDS);
    }

    protected void shutDown() throws Exception {
    }

    public String toString() {
        return String.valueOf(this.server.getId()) + " " + super.toString();
    }
}

