/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ui.m0;

import com.google.common.base.Charsets;
import com.google.common.hash.Hasher;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.epp.internal.logging.aeri.ui.model.IBundle;
import org.eclipse.epp.internal.logging.aeri.ui.model.IReport;
import org.eclipse.epp.internal.logging.aeri.ui.model.IStackTraceElement;
import org.eclipse.epp.internal.logging.aeri.ui.model.IStatus;
import org.eclipse.epp.internal.logging.aeri.ui.model.IThrowable;
import org.eclipse.epp.internal.logging.aeri.ui.model.util.ModelSwitch;
import org.eclipse.epp.internal.logging.aeri.ui.utils.Reports;

public class ReportFingerprints {
    public static String exactIdentityHash(IReport report) {
        final Hasher hasher = Reports.newHasher();
        ModelSwitch<Hasher> s = new ModelSwitch<Hasher>(){

            @Override
            public Hasher caseReport(IReport object) {
                hasher.putString((CharSequence)StringUtils.stripToEmpty((String)object.getEclipseProduct()), Charsets.UTF_8);
                hasher.putString((CharSequence)StringUtils.stripToEmpty((String)object.getEclipseBuildId()), Charsets.UTF_8);
                hasher.putString((CharSequence)StringUtils.stripToEmpty((String)object.getJavaRuntimeVersion()), Charsets.UTF_8);
                hasher.putString((CharSequence)StringUtils.stripToEmpty((String)object.getOsgiOs()), Charsets.UTF_8);
                hasher.putString((CharSequence)StringUtils.stripToEmpty((String)object.getOsgiOsVersion()), Charsets.UTF_8);
                hasher.putString((CharSequence)StringUtils.stripToEmpty((String)object.getOsgiArch()), Charsets.UTF_8);
                hasher.putString((CharSequence)StringUtils.stripToEmpty((String)object.getOsgiWs()), Charsets.UTF_8);
                return null;
            }

            @Override
            public Hasher caseStatus(IStatus object) {
                hasher.putString((CharSequence)StringUtils.stripToEmpty((String)object.getPluginId()), Charsets.UTF_8);
                hasher.putString((CharSequence)StringUtils.stripToEmpty((String)object.getPluginVersion()), Charsets.UTF_8);
                hasher.putString((CharSequence)StringUtils.stripToEmpty((String)object.getMessage()), Charsets.UTF_8);
                hasher.putInt(object.getSeverity());
                hasher.putInt(object.getCode());
                return null;
            }

            @Override
            public Hasher caseBundle(IBundle object) {
                hasher.putString((CharSequence)StringUtils.stripToEmpty((String)object.getName()), Charsets.UTF_8);
                hasher.putString((CharSequence)StringUtils.stripToEmpty((String)object.getVersion()), Charsets.UTF_8);
                return null;
            }

            @Override
            public Hasher caseStackTraceElement(IStackTraceElement object) {
                hasher.putString((CharSequence)StringUtils.stripToEmpty((String)object.getClassName()), Charsets.UTF_8);
                hasher.putString((CharSequence)StringUtils.stripToEmpty((String)object.getMethodName()), Charsets.UTF_8);
                hasher.putInt(object.getLineNumber());
                return null;
            }

            @Override
            public Hasher caseThrowable(IThrowable object) {
                hasher.putString((CharSequence)StringUtils.stripToEmpty((String)object.getClassName()), Charsets.UTF_8);
                hasher.putString((CharSequence)StringUtils.stripToEmpty((String)object.getMessage()), Charsets.UTF_8);
                return null;
            }
        };
        Reports.visit(report, s);
        String hash = hasher.hash().toString();
        return hash;
    }

    public static String traceIdentityHash(IReport report) {
        final Hasher hasher = Reports.newHasher();
        Reports.visit(report, new ModelSwitch<Hasher>(){

            @Override
            public Hasher caseStackTraceElement(IStackTraceElement element) {
                hasher.putString((CharSequence)element.getClassName(), Charsets.UTF_8);
                hasher.putString((CharSequence)element.getMethodName(), Charsets.UTF_8);
                hasher.putInt(element.getLineNumber());
                return null;
            }
        });
        String hash = hasher.hash().toString();
        return hash;
    }
}

