/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ui.m0;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.epp.internal.logging.aeri.ui.l10n.LogMessages;
import org.eclipse.epp.internal.logging.aeri.ui.l10n.Logs;
import org.eclipse.epp.internal.logging.aeri.ui.m0.WildcardRegexConverter;
import org.eclipse.jdt.annotation.Nullable;

public class RemoteConfiguration {
    private String version;
    private String title;
    private String description;
    private long timestamp;
    private long ttl;
    private String helpUrl;
    private String feedbackUrl;
    private String aboutUrl;
    private String submitUrl;
    private int maxReportSize;
    private String problemsUrl;
    private long problemsTtl;
    private String queryUrl;
    private int connectTimeout = (int)TimeUnit.SECONDS.toMillis(3L);
    private int socketTimeout = (int)TimeUnit.SECONDS.toMillis(10L);
    private List<String> acceptedProducts;
    @Nullable
    private transient List<Pattern> acceptedProductsPatterns;
    private List<String> acceptedPlugins;
    @Nullable
    private transient List<Pattern> acceptedPluginsPatterns;
    private List<String> acceptedPackages;
    @Nullable
    private transient List<Pattern> acceptedPackagesPatterns;
    private boolean acceptOtherPackages;
    private boolean acceptUiFreezes;
    private List<String> ignoredStatuses;
    @Nullable
    private transient List<IgnorePattern> ignoredPatterns;
    private long problemsZipLastDownloadTimestamp;

    public int getConnectTimeoutMs() {
        return (int)TimeUnit.MILLISECONDS.convert(this.connectTimeout, TimeUnit.SECONDS);
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int getSocketTimeoutMs() {
        return (int)TimeUnit.MILLISECONDS.convert(this.socketTimeout, TimeUnit.SECONDS);
    }

    public long getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public long getTtl() {
        return this.ttl;
    }

    public long getTtlMs() {
        return TimeUnit.MILLISECONDS.convert(this.getTtl(), TimeUnit.MINUTES);
    }

    public void setTtl(long ttlInMinutes) {
        this.ttl = ttlInMinutes;
    }

    public String getHelpUrl() {
        return this.helpUrl;
    }

    public void setHelpUrl(String helpUrl) {
        this.helpUrl = helpUrl;
    }

    public String getFeedbackUrl() {
        return this.feedbackUrl;
    }

    public void setFeedbackUrl(String feedbackUrl) {
        this.feedbackUrl = feedbackUrl;
    }

    public String getAboutUrl() {
        return this.aboutUrl;
    }

    public void setAboutUrl(String aboutUrl) {
        this.aboutUrl = aboutUrl;
    }

    public String getSubmitUrl() {
        return this.submitUrl;
    }

    public void setSubmitUrl(String submitUrl) {
        this.submitUrl = submitUrl;
    }

    public int getMaxReportSize() {
        return this.maxReportSize;
    }

    public void setMaxReportSize(int submitSizeLimit) {
        this.maxReportSize = submitSizeLimit;
    }

    public String getProblemsUrl() {
        return this.problemsUrl;
    }

    public void setProblemsUrl(String problemsUrl) {
        this.problemsUrl = problemsUrl;
    }

    public long getProblemsTtl() {
        return this.problemsTtl;
    }

    public long getProblemsTtlMs() {
        return TimeUnit.MILLISECONDS.convert(this.getProblemsTtl(), TimeUnit.MINUTES);
    }

    public void setProblemsTtl(long problemsTtlInMinutes) {
        this.problemsTtl = problemsTtlInMinutes;
    }

    public String getQueryUrl() {
        return this.queryUrl;
    }

    public void setQueryUrl(String queryUrl) {
        this.queryUrl = queryUrl;
    }

    public List<String> getAcceptedProducts() {
        return this.acceptedProducts;
    }

    public void setAcceptedProducts(List<String> acceptedProducts) {
        this.acceptedProducts = acceptedProducts;
        this.acceptedProductsPatterns = null;
    }

    public List<String> getAcceptedPlugins() {
        return this.acceptedPlugins;
    }

    public void setAcceptedPlugins(List<String> acceptedPlugins) {
        this.acceptedPlugins = acceptedPlugins;
        this.acceptedPluginsPatterns = null;
    }

    public List<Pattern> getAcceptedProductsPatterns() {
        if (this.acceptedProductsPatterns == null) {
            this.acceptedProductsPatterns = WildcardRegexConverter.convert(this.acceptedProducts);
        }
        return this.acceptedProductsPatterns;
    }

    public List<Pattern> getAcceptedPluginsPatterns() {
        if (this.acceptedPluginsPatterns == null) {
            this.acceptedPluginsPatterns = WildcardRegexConverter.convert(this.acceptedPlugins);
        }
        return this.acceptedPluginsPatterns;
    }

    public List<Pattern> getAcceptedPackagesPatterns() {
        if (this.acceptedPackagesPatterns == null) {
            this.acceptedPackagesPatterns = WildcardRegexConverter.convert(this.acceptedPackages);
        }
        return this.acceptedPackagesPatterns;
    }

    public List<String> getAcceptedPackages() {
        return this.acceptedPackages;
    }

    public void setAcceptedPackages(List<String> acceptedPackages) {
        this.acceptedPackages = acceptedPackages;
        this.acceptedPackagesPatterns = null;
    }

    public boolean isAcceptOtherPackages() {
        return this.acceptOtherPackages;
    }

    public void setAcceptOtherPackages(boolean acceptOtherPackages) {
        this.acceptOtherPackages = acceptOtherPackages;
    }

    public List<IgnorePattern> getIgnoredPluginMessagesPatterns() {
        if (this.ignoredPatterns == null) {
            this.ignoredPatterns = Lists.newArrayList();
            for (String s : this.getIgnoredStatuses()) {
                IgnorePattern pattern = IgnorePattern.fromString(s);
                if (pattern != null) {
                    this.ignoredPatterns.add(pattern);
                    continue;
                }
                Logs.log((Logs.ILogMessage)LogMessages.WARN_INVALID_PATTERN, s);
            }
        }
        return this.ignoredPatterns;
    }

    public boolean isAcceptUiFreezes() {
        return this.acceptUiFreezes;
    }

    public void setAcceptUiFreezes(boolean acceptUiFreezes) {
        this.acceptUiFreezes = acceptUiFreezes;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public long getProblemsZipLastDownloadTimestamp() {
        return this.problemsZipLastDownloadTimestamp;
    }

    public void setProblemsZipLastDownloadTimestamp(long problemsZipLastDownloadTimestamp) {
        this.problemsZipLastDownloadTimestamp = problemsZipLastDownloadTimestamp;
    }

    public List<String> getIgnoredStatuses() {
        return this.ignoredStatuses;
    }

    public void setIgnoredStatuses(List<String> ignoredStatuses) {
        this.ignoredStatuses = ignoredStatuses;
    }

    public static class IgnorePattern {
        private Pattern pluginPattern;
        private Pattern exceptionPattern;
        private Pattern messagePattern;
        private ExceptionStacktracePosition exceptionPosition;
        private StatusChainPosition statusChainPosition;

        @Nullable
        public static IgnorePattern fromString(String s) {
            String tail;
            int secondSep;
            int firstSep = s.indexOf(58);
            if (firstSep == -1) {
                return null;
            }
            String pluginPattern = s.substring(0, firstSep);
            StatusChainPosition statusChainPosition = StatusChainPosition.ANY;
            if (pluginPattern.startsWith("^")) {
                pluginPattern = pluginPattern.substring(1);
                statusChainPosition = StatusChainPosition.FIRST;
            }
            if ((secondSep = (tail = s.substring(firstSep + 1)).indexOf(58)) == -1) {
                return null;
            }
            String exceptionPattern = tail.substring(0, secondSep);
            ExceptionStacktracePosition exceptionStacktracePosition = ExceptionStacktracePosition.ANY;
            if (exceptionPattern.startsWith("^")) {
                exceptionPattern = exceptionPattern.substring(1);
                exceptionStacktracePosition = ExceptionStacktracePosition.TOP;
            } else if (exceptionPattern.startsWith("$")) {
                exceptionPattern = exceptionPattern.substring(1);
                exceptionStacktracePosition = ExceptionStacktracePosition.BOTTOM;
            }
            String messagePattern = tail.substring(secondSep + 1);
            IgnorePattern ip = new IgnorePattern();
            ip.pluginPattern = WildcardRegexConverter.convert((String)StringUtils.defaultIfEmpty((CharSequence)pluginPattern, (CharSequence)"*"));
            ip.statusChainPosition = statusChainPosition;
            ip.exceptionPattern = WildcardRegexConverter.convert((String)StringUtils.defaultIfEmpty((CharSequence)exceptionPattern, (CharSequence)"*"));
            ip.exceptionPosition = exceptionStacktracePosition;
            ip.messagePattern = WildcardRegexConverter.convert((String)StringUtils.defaultIfEmpty((CharSequence)messagePattern, (CharSequence)"*"));
            return ip;
        }

        public Pattern getPluginPattern() {
            return this.pluginPattern;
        }

        public Pattern getExceptionPattern() {
            return this.exceptionPattern;
        }

        public Pattern getMessagePattern() {
            return this.messagePattern;
        }

        public StatusChainPosition getStatusChainPosition() {
            return this.statusChainPosition;
        }

        public ExceptionStacktracePosition getExceptionPosition() {
            return this.exceptionPosition;
        }

        public boolean matches(IStatus status) {
            if (this.matches(status.getPlugin(), status.getException(), status.getMessage())) {
                return true;
            }
            if (this.statusChainPosition == StatusChainPosition.ANY) {
                IStatus[] iStatusArray = status.getChildren();
                int n = iStatusArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IStatus child = iStatusArray[n2];
                    if (this.matches(child)) {
                        return true;
                    }
                    ++n2;
                }
            }
            return false;
        }

        public boolean matches(String pluginId, Throwable exception, String message) {
            boolean pluginMatches = this.pluginPattern.matcher(pluginId).matches();
            boolean messageMatches = this.messagePattern.matcher(message).matches();
            if (pluginMatches && messageMatches) {
                switch (this.exceptionPosition) {
                    case ANY: {
                        Throwable current = exception;
                        while (current != null) {
                            if (this.exceptionPattern.matcher(current.getClass().getName()).matches()) {
                                return true;
                            }
                            current = current.getCause();
                        }
                        break;
                    }
                    case BOTTOM: {
                        Throwable current = exception;
                        while (current.getCause() != null) {
                            current = current.getCause();
                        }
                        if (!this.exceptionPattern.matcher(current.getClass().getName()).matches()) break;
                        return true;
                    }
                    case TOP: {
                        if (!this.exceptionPattern.matcher(exception.getClass().getName()).matches()) break;
                        return true;
                    }
                }
            }
            return false;
        }

        public static enum ExceptionStacktracePosition {
            TOP,
            BOTTOM,
            ANY;

        }

        public static enum StatusChainPosition {
            FIRST,
            ANY;

        }
    }
}

