/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ui.m0;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.entity.GzipCompressingEntity;
import org.apache.http.client.fluent.Executor;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.fluent.Response;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.epp.internal.logging.aeri.ui.l10n.Logs;
import org.eclipse.epp.internal.logging.aeri.ui.m0.HttpResponses;
import org.eclipse.epp.internal.logging.aeri.ui.m0.Proxies;
import org.eclipse.epp.internal.logging.aeri.ui.m0.RemoteConfiguration;
import org.eclipse.epp.internal.logging.aeri.ui.m0.RemoteResponse;
import org.eclipse.epp.internal.logging.aeri.ui.model.ILink;
import org.eclipse.epp.internal.logging.aeri.ui.model.IProblemState;
import org.eclipse.epp.internal.logging.aeri.ui.model.IReport;
import org.eclipse.epp.internal.logging.aeri.ui.model.ProblemStatus;
import org.eclipse.epp.internal.logging.aeri.ui.utils.Constants;
import org.eclipse.epp.internal.logging.aeri.ui.utils.Formats;
import org.eclipse.epp.internal.logging.aeri.ui.utils.Json;
import org.eclipse.epp.internal.logging.aeri.ui.utils.Reports;
import org.eclipse.epp.internal.logging.aeri.ui.utils.Servers;

public class IO {
    private Executor executor;
    private RemoteConfiguration configuration;
    private File configurationFile;

    public IO(Executor executor, File configurationFile) {
        this.executor = executor;
        this.configurationFile = configurationFile;
    }

    public void refreshConfiguration(String serverUrl, IProgressMonitor monitor) throws HttpResponseException, UnknownHostException, Exception {
        Response response = IO.request(IO.newURI(serverUrl), this.executor);
        String content = HttpResponses.getContentWithProgress(response, monitor);
        this.configuration = (RemoteConfiguration)Json.deserialize(content, RemoteConfiguration.class);
        this.configuration.setTimestamp(System.currentTimeMillis());
    }

    public void loadConfiguration() {
        this.configuration = (RemoteConfiguration)Json.deserialize(this.configurationFile, RemoteConfiguration.class);
    }

    public void saveConfiguration() {
        Json.serialize((Object)this.configuration, this.configurationFile);
    }

    public RemoteConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(RemoteConfiguration configuration) {
        this.configuration = configuration;
    }

    public IProblemState upload(IReport report, IProgressMonitor monitor) throws IOException {
        String body = Reports.toJson(report, false);
        StringEntity stringEntity = new StringEntity(body, ContentType.APPLICATION_OCTET_STREAM.withCharset(Charsets.UTF_8));
        GzipCompressingEntity entity = new GzipCompressingEntity(HttpResponses.decorateForProgressMonitoring((HttpEntity)stringEntity, monitor));
        String submitUrl = this.configuration.getSubmitUrl();
        URI target = IO.newURI(submitUrl);
        Request request = Request.Post((URI)target).viaProxy((HttpHost)Proxies.getProxyHost(target).orNull()).body((HttpEntity)entity).connectTimeout(this.configuration.getConnectTimeoutMs()).staleConnectionCheck(true).socketTimeout(this.configuration.getSocketTimeoutMs());
        String response = Proxies.proxyAuthentication(this.executor, target).execute(request).returnContent().asString();
        RemoteResponse raw = (RemoteResponse)Json.deserialize(response, RemoteResponse.class);
        IProblemState problemState = Constants.eFac.createProblemState();
        if (raw.isProcessed()) {
            ILink submission = Servers.createSubmissionLink((String)raw.getSubmissionUrl().orNull(), "Submission");
            problemState.addLink(submission);
        }
        if (raw.hasBug()) {
            ILink bug = Servers.createBugLink((String)raw.getBugUrl().orNull(), "Bug #" + (String)raw.getBugId().or((Object)"null"));
            problemState.addLink(bug);
        }
        problemState.setStatus(IO.tryParse(raw));
        String message = (String)raw.getInformation().orNull();
        if (message != null && !StringUtils.contains((CharSequence)message, (CharSequence)"</a>")) {
            message = String.valueOf(message) + this.appendLinks(problemState.getLinks());
        }
        problemState.setMessage(message);
        String[] keywords = (String[])raw.getKeywords().orNull();
        if (keywords != null) {
            String[] stringArray = keywords;
            int n = keywords.length;
            int n2 = 0;
            while (n2 < n) {
                String keyword = stringArray[n2];
                problemState.getNeedinfo().add((Object)keyword);
                ++n2;
            }
        }
        return problemState;
    }

    private String appendLinks(EMap<String, ILink> links) {
        if (links.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (ILink link : links.values()) {
            sb.append(Formats.format(" {0,link}", link));
        }
        return sb.toString();
    }

    private static URI newURI(String uri) throws IOException {
        try {
            return new URI(uri);
        }
        catch (URISyntaxException e) {
            throw new IOException("invalid server url: " + uri, e);
        }
    }

    public int downloadDatabase(File destination, IProgressMonitor monitor) throws IOException {
        URI target = IO.newURI(this.configuration.getProblemsUrl());
        Request request = Request.Get((URI)target).viaProxy((HttpHost)Proxies.getProxyHost(target).orNull()).connectTimeout(this.configuration.getConnectTimeoutMs()).staleConnectionCheck(true).socketTimeout(this.configuration.getSocketTimeoutMs());
        Response response = Proxies.proxyAuthentication(this.executor, target).execute(request);
        HttpResponse returnResponse = HttpResponses.getResponseWithProgress(response, monitor);
        int statusCode = returnResponse.getStatusLine().getStatusCode();
        if (statusCode == 200) {
            this.configuration.setProblemsZipLastDownloadTimestamp(System.currentTimeMillis());
            this.saveConfiguration();
            Throwable throwable = null;
            Object var9_10 = null;
            try (FileOutputStream out = new FileOutputStream(destination);){
                returnResponse.getEntity().writeTo((OutputStream)out);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return statusCode;
    }

    public boolean isProblemsDatabaseOutdated() {
        return System.currentTimeMillis() - this.configuration.getProblemsZipLastDownloadTimestamp() > this.configuration.getProblemsTtlMs();
    }

    public boolean isConfigurationOutdated() {
        if (this.configuration == null) {
            return true;
        }
        return System.currentTimeMillis() - this.configuration.getTimestamp() > this.configuration.getTtlMs();
    }

    @VisibleForTesting
    static Response request(URI target, Executor executor) throws ClientProtocolException, IOException {
        int connectTimeout = (int)TimeUnit.SECONDS.toMillis(3L);
        int socketTimeout = (int)TimeUnit.SECONDS.toMillis(10L);
        Request request = Request.Get((URI)target).viaProxy((HttpHost)Proxies.getProxyHost(target).orNull()).connectTimeout(connectTimeout).staleConnectionCheck(true).socketTimeout(socketTimeout);
        return Proxies.proxyAuthentication(executor, target).execute(request);
    }

    @VisibleForTesting
    static ProblemStatus tryParse(RemoteResponse response) {
        String resolution;
        boolean needinfo = ArrayUtils.contains((Object[])response.keywords, (Object)"needinfo");
        String status = ((String)response.getStatus().or((Object)"")).toUpperCase();
        switch (resolution = ((String)response.getResolved().or((Object)"")).toUpperCase()) {
            case "": 
            case "UNKNONW": 
            case "UNSPECIFIED": 
            case "UNDEFINED": {
                if (needinfo) {
                    return ProblemStatus.NEEDINFO;
                }
                if (response.created) {
                    return ProblemStatus.NEW;
                }
                switch (status) {
                    case "REOPEN": 
                    case "NEW": 
                    case "ASSIGNED": 
                    case "UNCONFIRMED": {
                        return ProblemStatus.CONFIRMED;
                    }
                }
                Logs.warn("Unexpected response : {} - {}", response.getStatus(), response.getResolved());
                return ProblemStatus.UNCONFIRMED;
            }
            case "INVALID": {
                return ProblemStatus.INVALID;
            }
            case "FIXED": {
                return ProblemStatus.FIXED;
            }
            case "WONTFIX": 
            case "NOT_ECLIPSE": 
            case "DUPLICATE": 
            case "MOVED": 
            case "WORKSFORME": {
                return ProblemStatus.INVALID;
            }
        }
        return ProblemStatus.UNCONFIRMED;
    }
}

