/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ui.functions;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import org.eclipse.e4.core.contexts.ContextFunction;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.epp.internal.logging.aeri.ui.SystemControl;
import org.eclipse.epp.internal.logging.aeri.ui.model.ISystemSettings;
import org.eclipse.epp.internal.logging.aeri.ui.utils.DebugFilter;
import org.eclipse.epp.internal.logging.aeri.ui.utils.StatusFilterActiveShell;
import org.eclipse.epp.internal.logging.aeri.ui.utils.StatusFilters;
import org.eclipse.ui.PlatformUI;

public class SystemStatusFiltersCreationFunction
extends ContextFunction {
    public Object compute(IEclipseContext context, String contextKey) {
        contextKey = (String)Preconditions.checkNotNull((Object)contextKey);
        ISystemSettings settings = (ISystemSettings)context.get(ISystemSettings.class);
        Predicate<T>[] statusPredicates = DebugFilter.decorate(new StatusFilters.EclipseBuildIdPresentFilter(), new StatusFilters.NoErrorStatusFilter(), new StatusFilterActiveShell(), new StatusFilters.SystemEnabledFilter(settings), new StatusFilters.RecentlySeenFilter(settings), new StatusFilters.WorkbenchRunningFilter(PlatformUI.getWorkbench()));
        Predicate statusFilters = Predicates.and(statusPredicates);
        IEclipseContext systemContext = SystemControl.getSystemContext();
        systemContext.set(contextKey, (Object)statusFilters);
        return statusFilters;
    }
}

