/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ui.functions;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.e4.core.contexts.IContextFunction;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.epp.internal.logging.aeri.ui.SystemControl;
import org.eclipse.epp.internal.logging.aeri.ui.l10n.LogMessages;
import org.eclipse.epp.internal.logging.aeri.ui.l10n.Logs;
import org.eclipse.epp.internal.logging.aeri.ui.model.CustomSystemSettings;
import org.eclipse.epp.internal.logging.aeri.ui.model.IModelPackage;
import org.eclipse.epp.internal.logging.aeri.ui.model.ISystemSettings;
import org.eclipse.epp.internal.logging.aeri.ui.model.ResetSendMode;
import org.eclipse.epp.internal.logging.aeri.ui.utils.Constants;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class SystemSettingsCreationFunction
implements IContextFunction {
    public Object compute(IEclipseContext localContext, @Nullable String contextKey) {
        contextKey = (String)Preconditions.checkNotNull((Object)contextKey);
        ISystemSettings settings = Constants.eFac.createSystemSettings();
        EClass eClass = settings.eClass();
        ScopedPreferenceStore instanceStore = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.eclipse.epp.logging.aeri.ui");
        SystemSettingsCreationFunction.loadFromPreferences(instanceStore, settings, eClass);
        SystemSettingsCreationFunction.registerPreferenceStoreChangeListener(instanceStore, settings, eClass);
        SystemSettingsCreationFunction.registerSettingsChangeListener(instanceStore, settings, new HashSet<EAttribute>());
        ScopedPreferenceStore configurationStore = new ScopedPreferenceStore(ConfigurationScope.INSTANCE, "org.eclipse.epp.logging.aeri.ui");
        SystemSettingsCreationFunction.registerSettingsChangeListener(configurationStore, settings, (Set<EAttribute>)ImmutableSet.of((Object)IModelPackage.Literals.SYSTEM_SETTINGS__REPORTER_NAME, (Object)IModelPackage.Literals.SYSTEM_SETTINGS__REPORTER_EMAIL, (Object)IModelPackage.Literals.SYSTEM_SETTINGS__ANONYMIZE_STACK_TRACES, (Object)IModelPackage.Literals.SYSTEM_SETTINGS__ANONYMIZE_MESSAGES, (Object)IModelPackage.Literals.SYSTEM_SETTINGS__DEBUG_ENABLED));
        if (ResetSendMode.RESTART == settings.getResetSendMode()) {
            CustomSystemSettings.resetSendMode(settings);
        }
        IEclipseContext systemContext = SystemControl.getSystemContext();
        systemContext.set(contextKey, (Object)settings);
        return settings;
    }

    private static void registerSettingsChangeListener(final ScopedPreferenceStore store, ISystemSettings settings, final Set<EAttribute> allowedKeys) {
        settings.eAdapters().add((Object)new AdapterImpl(){

            public void notifyChanged(Notification msg) {
                Object feature = msg.getFeature();
                if (!(feature instanceof EAttribute)) {
                    return;
                }
                EAttribute attr = (EAttribute)feature;
                EDataType type = attr.getEAttributeType();
                Object value = msg.getNewValue();
                String data = EcoreUtil.convertToString((EDataType)type, (Object)value);
                if (allowedKeys.isEmpty() || allowedKeys.contains(attr)) {
                    try {
                        store.putValue(attr.getName(), data);
                        store.save();
                    }
                    catch (Exception e) {
                        Logs.log((Logs.ILogMessage)LogMessages.ERROR_SAVE_PREFERENCES_FAILED, e);
                    }
                }
            }
        });
    }

    private static void registerPreferenceStoreChangeListener(ScopedPreferenceStore store, final ISystemSettings settings, final EClass eClass) {
        store.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                String property = event.getProperty();
                EStructuralFeature feature = eClass.getEStructuralFeature(property);
                if (feature != null && feature instanceof EAttribute) {
                    EAttribute attr = (EAttribute)feature;
                    EDataType type = attr.getEAttributeType();
                    String string = EcoreUtil.convertToString((EDataType)type, (Object)event.getNewValue());
                    Object value = EcoreUtil.createFromString((EDataType)type, (String)string);
                    settings.eSet(feature, value);
                }
            }
        });
    }

    private static void loadFromPreferences(ScopedPreferenceStore store, ISystemSettings settings, EClass eClass) {
        for (EAttribute attr : eClass.getEAllAttributes()) {
            EDataType type = attr.getEAttributeType();
            String key = attr.getName();
            if (!store.contains(key)) continue;
            String value = store.getString(key);
            try {
                if (attr.isMany()) {
                    SystemSettingsCreationFunction.convert(value);
                    for (String s : SystemSettingsCreationFunction.convert(value)) {
                        Object data = EcoreUtil.createFromString((EDataType)type, (String)s);
                        ((List)settings.eGet((EStructuralFeature)attr)).add(data);
                    }
                    continue;
                }
                Object data = EcoreUtil.createFromString((EDataType)type, (String)value);
                settings.eSet((EStructuralFeature)attr, data);
            }
            catch (Exception exception) {
                Logs.log((Logs.ILogMessage)LogMessages.ERROR_FAILED_TO_PARSE_PREFERENCE_VALUE, attr, value);
            }
        }
    }

    static List<String> convert(String string) {
        return Splitter.on((char)';').omitEmptyStrings().trimResults().splitToList((CharSequence)string);
    }

    static String convert(List<String> strings) {
        return Joiner.on((String)";").skipNulls().join(strings);
    }
}

