/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ui.functions;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.e4.core.contexts.ContextFunction;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epp.internal.logging.aeri.ui.SystemControl;
import org.eclipse.epp.internal.logging.aeri.ui.functions.ServerConfigurationAreaCreationFunction;
import org.eclipse.epp.internal.logging.aeri.ui.l10n.LogMessages;
import org.eclipse.epp.internal.logging.aeri.ui.l10n.Logs;
import org.eclipse.epp.internal.logging.aeri.ui.model.ILink;
import org.eclipse.epp.internal.logging.aeri.ui.model.IModelPackage;
import org.eclipse.epp.internal.logging.aeri.ui.model.IServer;
import org.eclipse.epp.internal.logging.aeri.ui.utils.Constants;
import org.eclipse.epp.internal.logging.aeri.ui.utils.EmfPreferences;
import org.eclipse.epp.logging.aeri.ui.IServerConnection;

public class RegistryServersCreationFunction
extends ContextFunction {
    public Object compute(IEclipseContext notused, String contextKey) {
        contextKey = (String)Preconditions.checkNotNull((Object)contextKey);
        IEclipseContext systemContext = SystemControl.getSystemContext();
        IExtensionRegistry registry = (IExtensionRegistry)systemContext.get(IExtensionRegistry.class);
        IConfigurationElement[] elements = registry.getConfigurationElementsFor("org.eclipse.epp.logging.aeri.ui.servers");
        ImmutableList.Builder b = ImmutableList.builder();
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            IServer server = Constants.eFac.createServer();
            server.setConfigurationElement(element);
            server.setClazz(element.getAttribute("class"));
            String contributor = element.getContributor().getName();
            server.setContributor(contributor);
            this.copyFromRegistry(element, server, (Set<EAttribute>)ImmutableSet.of((Object)IModelPackage.Literals.SERVER__ID, (Object)IModelPackage.Literals.SERVER__NAME, (Object)IModelPackage.Literals.SERVER__DESCRIPTION, (Object)IModelPackage.Literals.SERVER__ICON16, (Object)IModelPackage.Literals.SERVER__ICON32, (Object)IModelPackage.Literals.SERVER__ICON64, (Object[])new EAttribute[0]));
            this.readLinks(server, element);
            ImmutableSet listen = ImmutableSet.of((Object)IModelPackage.Literals.SERVER__REPORTER_EMAIL, (Object)IModelPackage.Literals.SERVER__REPORTER_NAME, (Object)IModelPackage.Literals.SERVER__ANONYMIZE_STACK_TRACES, (Object)IModelPackage.Literals.SERVER__CONFIGURED, (Object)IModelPackage.Literals.SERVER__ENABLED);
            String nodeQualifier = "org.eclipse.epp.logging.aeri.ui/endpoints/" + server.getId();
            EmfPreferences.listen(nodeQualifier, server, (Set<EAttribute>)listen);
            try {
                IEclipseContext childContext = systemContext.createChild("endpoint-ctx " + server.getId());
                childContext.set(IServer.class, (Object)server);
                childContext.set(File.class.getName(), (Object)new ServerConfigurationAreaCreationFunction());
                IServerConnection object = server.createConnection(childContext);
                server.setConnection(object);
            }
            catch (Exception e) {
                Logs.log((Logs.ILogMessage)LogMessages.WARN_EXTENSION_FAILED, e, server.getId(), e.getMessage());
            }
            b.add((Object)server);
            ++n2;
        }
        ImmutableList servers = b.build();
        systemContext.set(contextKey, (Object)servers);
        return servers;
    }

    private void readLinks(IServer server, IConfigurationElement element) {
        IConfigurationElement[] children;
        EMap<String, ILink> links = server.getLinks();
        IConfigurationElement[] iConfigurationElementArray = children = element.getChildren("link");
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement child = iConfigurationElementArray[n2];
            ILink link = Constants.eFac.createLink();
            this.copyFromRegistry(child, link, (Set<EAttribute>)ImmutableSet.of((Object)IModelPackage.Literals.LINK__REL, (Object)IModelPackage.Literals.LINK__HREF, (Object)IModelPackage.Literals.LINK__TITLE));
            links.put((Object)link.getRel(), (Object)link);
            ++n2;
        }
    }

    private void copyFromRegistry(IConfigurationElement child, EObject link, Set<EAttribute> attrs) {
        for (EAttribute attr : attrs) {
            String value = child.getAttribute(attr.getName());
            link.eSet((EStructuralFeature)attr, (Object)value);
        }
    }
}

