/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ui.dialogs;

import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.epp.internal.logging.aeri.ui.dialogs.ExternalServersEnabledAlert;
import org.eclipse.epp.internal.logging.aeri.ui.model.IServer;
import org.eclipse.epp.internal.logging.aeri.ui.model.ISystemSettings;
import org.eclipse.epp.internal.logging.aeri.ui.model.SendMode;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.wizard.Wizard;

public class SetupWizard
extends Wizard {
    private ISystemSettings systemSettings;
    private IEclipseContext parentContext;
    private List<IServer> servers;

    @Inject
    public SetupWizard(ISystemSettings systemSettings, @Named(value="org.eclipse.epp.logging.aeri.ui.servers") List<IServer> servers, ImageRegistry registry, IEclipseContext eclipseContext) {
        this.systemSettings = systemSettings;
        this.servers = servers;
        this.parentContext = eclipseContext;
        this.setHelpAvailable(false);
        this.setWindowTitle("Configure Automated Error Reporting");
        this.setNeedsProgressMonitor(false);
        this.setDefaultPageImageDescriptor(registry.getDescriptor("/icons/wizban/stacktraces_wiz.png"));
        this.parentContext.modify("org.eclipse.epp.logging.aeri.ui.ui.configure-ongoing", (Object)true);
    }

    public boolean performCancel() {
        for (IServer server : this.servers) {
            server.setConfigured(true);
            server.setEnabled(false);
        }
        this.systemSettings.setSendMode(SendMode.NEVER);
        this.systemSettings.setConfigured(true);
        this.parentContext.modify("org.eclipse.epp.logging.aeri.ui.ui.configure-ongoing", (Object)false);
        return true;
    }

    public boolean performFinish() {
        if (this.needsWarning() && this.showAlert() != 0) {
            return false;
        }
        for (IServer server : this.servers) {
            server.setConfigured(true);
        }
        this.systemSettings.setConfigured(true);
        if (!this.systemSettings.isEnabled()) {
            this.systemSettings.setSendMode(SendMode.NOTIFY);
        }
        this.parentContext.modify("org.eclipse.epp.logging.aeri.ui.ui.configure-ongoing", (Object)false);
        return true;
    }

    private int showAlert() {
        return new ExternalServersEnabledAlert(this.getShell()).open();
    }

    private boolean needsWarning() {
        for (IServer server : this.servers) {
            String id = server.getId();
            if (!server.isEnabled() || id.startsWith("org.eclipse")) continue;
            return true;
        }
        return false;
    }
}

