/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ui.dialogs;

import com.google.common.base.Objects;
import java.lang.reflect.Method;
import java.util.Collection;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epp.internal.logging.aeri.ui.l10n.Messages;
import org.eclipse.epp.internal.logging.aeri.ui.model.ILink;
import org.eclipse.epp.internal.logging.aeri.ui.model.IModelPackage;
import org.eclipse.epp.internal.logging.aeri.ui.model.IServer;
import org.eclipse.epp.internal.logging.aeri.ui.utils.Browsers;
import org.eclipse.epp.internal.logging.aeri.ui.utils.Constants;
import org.eclipse.epp.internal.logging.aeri.ui.utils.Formats;
import org.eclipse.epp.internal.logging.aeri.ui.utils.UI;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class ServersPage
extends WizardPage {
    private Collection<IServer> servers;
    private IEclipseContext parentContext;
    private DataBindingContext context;
    private IEventBroker broker;

    @Inject
    public ServersPage(@Named(value="org.eclipse.epp.logging.aeri.ui.servers") Collection<IServer> servers, IEventBroker broker, IEclipseContext parentContext) {
        super(ServersPage.class.getName());
        this.servers = servers;
        this.parentContext = parentContext;
        this.broker = broker;
        this.context = new DataBindingContext();
        this.setPageComplete(false);
        this.setTitle(Formats.format("{0,projects,style=short} signed up to receive reports", servers));
        this.setDescription("Enable Error Reporting for projects you would like to assist.");
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.setPageComplete(true);
            try {
                Method method = Dialog.class.getDeclaredMethod("getButton", Integer.TYPE);
                method.setAccessible(true);
                Button button = (Button)method.invoke((Object)this.getContainer(), 16);
                button.setFocus();
            }
            catch (Exception exception) {}
        }
    }

    public void createControl(Composite parent) {
        int preferredWidth = 400;
        Font font = JFaceResources.getDialogFont();
        int fontSize = font.getFontData()[0].getHeight();
        Font small = FontDescriptor.createFrom((Font)font).setHeight(fontSize).createFont((Device)parent.getDisplay());
        Composite container = new Composite(parent, 0);
        UI.gl().spacing(0, 3).extendedMargins(10, 0, 10, 0).applyTo(container);
        UI.gdGrabHV().applyTo((Control)container);
        Label header = new Label(container, 64);
        header.setText("The following projects request receiving problem reports for their products:\n");
        UI.gdGrabH().hint(preferredWidth, -1).applyTo((Control)header);
        ScrolledComposite scrolledComposite = new ScrolledComposite(container, 768);
        scrolledComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        UI.gl().applyTo((Composite)scrolledComposite);
        scrolledComposite.setExpandVertical(true);
        scrolledComposite.setExpandHorizontal(true);
        Composite sections = new Composite((Composite)scrolledComposite, 0);
        UI.gl().extendedMargins(3, 3, 3, 3).applyTo(sections);
        UI.gdGrabHV().hint(preferredWidth, 200).applyTo((Control)scrolledComposite);
        scrolledComposite.setContent((Control)sections);
        for (final IServer server : this.servers) {
            Composite section = new Composite(sections, 0);
            int sectionColumns = 4;
            UI.gl().numColumns(sectionColumns).margins(0, 0).spacing(10, 1).applyTo(section);
            UI.gdGrabH().applyTo((Control)section);
            Label icon = new Label(section, 0);
            icon.setImage(server.getImage32());
            UI.gd().indent(0, fontSize / 2).align(1, 1).span(1, 3).applyTo((Control)icon);
            Label headline = new Label(section, 64);
            headline.setText(server.getName());
            Font newFont = FontDescriptor.createFrom((Font)font).setStyle(1).createFont((Device)parent.getDisplay());
            headline.setFont(newFont);
            UI.gd().span(sectionColumns - 1, 1).applyTo((Control)headline);
            Link description = new Link(section, 64);
            String text = StringUtils.defaultString((String)server.getDescription(), (String)"No description available.");
            description.setText(text);
            description.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ServersPage.this.broker.send("org/eclipse/epp/internal/logging/aeri/ui/event/open-url", (Object)e.text);
                }
            });
            UI.gdGrabH().span(sectionColumns - 1, 1).hint(preferredWidth - 10, -1).applyTo((Control)description);
            ILink link = this.getProviderLink(server);
            Hyperlink provider = new Hyperlink(section, 64);
            provider.setText(NLS.bind((String)Messages.LABEL_SERVER_PROVIDER, (Object)link.getTitle(), (Object)link.getHref()));
            provider.setHref((Object)link.getHref());
            provider.setToolTipText(link.getHref());
            provider.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    Browsers.openInExternalBrowser(e.getHref());
                }
            });
            provider.setFont(small);
            provider.setUnderlined(true);
            provider.setForeground(parent.getDisplay().getSystemColor(16));
            UI.gdGrabH().align(1, 1).applyTo((Control)provider);
            Link configure = new Link(section, 64);
            configure.setText("<a>Configure</a>");
            configure.setFont(small);
            configure.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    IEclipseContext child = ServersPage.this.parentContext.createChild();
                    child.set(IServer.class, (Object)server);
                    Dialog page = server.createConfigureDialog(child);
                    page.open();
                }
            });
            UI.gd().align(0x1000008, 0x1000000).applyTo((Control)configure);
            Button enable = new Button(section, 0x800002);
            UI.gd().align(0x1000008, 0x1000000).applyTo((Control)enable);
            ISWTObservableValue swt = WidgetProperties.selection().observe((Widget)enable);
            IObservableValue emf = EMFProperties.value((EStructuralFeature)IModelPackage.Literals.SERVER__ENABLED).observe((Object)server);
            ISWTObservableValue label = WidgetProperties.text().observe((Widget)enable);
            this.context.bindValue((IObservableValue)swt, emf);
            this.context.bindValue((IObservableValue)label, emf, null, new UpdateValueStrategy().setConverter((IConverter)new BooleanToEnablementTextConverter(Boolean.class, String.class)));
        }
        Link termsAndConditions = new Link(container, 0);
        termsAndConditions.setText("By clicking 'Enable' you agree to the terms of use and privacy policies of the above selected projects.");
        UI.gdGrabH().indent(0, 10).align(4, 0x1000008).hint(preferredWidth, -1).applyTo((Control)termsAndConditions);
        Point sectionsSize = sections.computeSize(-1, -1);
        sections.setSize(sectionsSize);
        scrolledComposite.setMinSize(sectionsSize);
        Dialog.applyDialogFont((Control)container);
        this.setControl((Control)container);
    }

    private ILink getProviderLink(IServer server) {
        ILink link = server.getLink("provider");
        if (link == null) {
            link = Constants.eFac.createLink();
        }
        if (!link.eIsSet((EStructuralFeature)IModelPackage.Literals.LINK__HREF)) {
            link.setHref("http://undefined.org/");
        }
        if (!link.eIsSet((EStructuralFeature)IModelPackage.Literals.LINK__TITLE)) {
            link.setTitle("Undefined");
        }
        return link;
    }

    private ILink emptyProvider() {
        ILink link = Constants.eFac.createLink();
        link.setHref("");
        link.setRel("provider");
        link.setTitle("Missing");
        return link;
    }

    public void dispose() {
        this.context.dispose();
        super.dispose();
    }

    private final class BooleanToEnablementTextConverter
    extends Converter {
        private BooleanToEnablementTextConverter(Object fromType, Object toType) {
            super(fromType, toType);
        }

        public Object convert(Object fromObject) {
            Boolean value = (Boolean)Objects.firstNonNull((Object)((Boolean)fromObject), (Object)Boolean.FALSE);
            return value != false ? "Enabled" : "Disabled";
        }
    }
}

