/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ui.dialogs;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.e4.core.contexts.Active;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.Preference;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.epp.internal.logging.aeri.ui.model.IInternalInput;
import org.eclipse.epp.internal.logging.aeri.ui.model.ILogEvent;
import org.eclipse.epp.internal.logging.aeri.ui.model.ILogEventGroup;
import org.eclipse.epp.internal.logging.aeri.ui.model.ILogEventsQueue;
import org.eclipse.epp.internal.logging.aeri.ui.model.IModelPackage;
import org.eclipse.epp.internal.logging.aeri.ui.model.IReport;
import org.eclipse.epp.internal.logging.aeri.ui.model.IServer;
import org.eclipse.epp.internal.logging.aeri.ui.model.Severity;
import org.eclipse.epp.internal.logging.aeri.ui.model.util.ModelSwitch;
import org.eclipse.epp.internal.logging.aeri.ui.utils.Constants;
import org.eclipse.epp.internal.logging.aeri.ui.utils.Reports;
import org.eclipse.epp.internal.logging.aeri.ui.utils.UI;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.swt.WidgetValueProperty;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ReviewDialog
extends MessageDialog {
    private static final String PREF_REVIEW_DIALOG_WIDTH = "review-dialog-width";
    private SashForm reportsAndDetailsSash;
    private TableViewer reportsViewer;
    private SashForm commentAndPreviewSash;
    private ComboViewer severity;
    private StyledText comments;
    private Composite previewArea;
    private StyledText preview;
    private ToolItem anonymizeMessagesOption;
    private ToolItem anonymizeStackTraceOption;
    private Composite detailsArea;
    private ExpandableComposite previewTwistie;
    private ToolBar addonsBar;
    private ExpandableComposite commentTwistie;
    private ShowPreviewListener showPreviewListener;
    private IEclipseContext context;
    private IEclipsePreferences prefs;
    private IEventBroker broker;
    private ImageRegistry registry;
    @Nullable
    private ILogEventGroup active;
    private ILogEventsQueue queue;
    private DataBindingContext dbContext;
    private IViewerObservableValue selectedLogEvent;
    private IObservableList events;
    private IncomingEventsCopier incomingEventsCopier;

    @Inject
    public ReviewDialog(@Active @Optional ILogEventGroup active, ILogEventsQueue queue, ImageRegistry registry, @Named(value="activeShell") @Optional Shell parentShell, @Preference IEclipsePreferences prefs, IEclipseContext context, IEventBroker broker) {
        super(parentShell, "A Problem Was Found...", null, "An unexpected problem occurred. Such problems may reveal severe issues in the code, and thus, we kindly ask you to send them to the affected projects. See below which projects request your assistance.", 4, new String[]{"Send", "Don't Send"}, 0);
        this.active = active;
        this.queue = queue;
        this.registry = (ImageRegistry)Preconditions.checkNotNull((Object)registry);
        this.prefs = prefs;
        this.context = context;
        this.broker = broker;
        this.setShellStyle(3184);
        this.setBlockOnOpen(false);
        this.setupObservableList();
        context.modify("org.eclipse.epp.logging.aeri.ui.ui.review-ongoing", (Object)true);
    }

    private void setupObservableList() {
        IInternalInput input = Constants.eFac.createInternalInput();
        this.events = EMFProperties.list((EStructuralFeature)IModelPackage.Literals.INTERNAL_INPUT__INPUT).observe((Object)input);
        for (ILogEventGroup group : this.queue.getGroups()) {
            input.getInput().addAll(group.getEvents());
        }
        this.incomingEventsCopier = new IncomingEventsCopier(input);
        this.queue.eAdapters().add((Object)this.incomingEventsCopier);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setSize(this.prefs.getInt(PREF_REVIEW_DIALOG_WIDTH, 600), 300);
    }

    public void create() {
        super.create();
    }

    protected boolean customShouldTakeFocus() {
        return false;
    }

    public Composite createCustomArea(Composite parent) {
        this.createReportsAndDetailsSash(parent);
        this.createEventsTree((Composite)this.reportsAndDetailsSash);
        this.createDetailsArea((Composite)this.reportsAndDetailsSash);
        this.reportsAndDetailsSash.setWeights(new int[]{1, 3});
        this.createPreferencesLink(parent);
        this.createDatabindings();
        if (this.active != null) {
            EList<ILogEvent> events = this.active.getEvents();
            ILogEvent event = (ILogEvent)events.get(0);
            this.selectedLogEvent.setValue((Object)event);
        }
        UI.gdGrabHV().indent(0, 10).applyTo((Control)this.reportsAndDetailsSash);
        return this.reportsAndDetailsSash;
    }

    private void createDetailsArea(Composite parent) {
        final int height = Math.max(19, parent.getFont().getFontData()[0].getHeight());
        this.detailsArea = new Composite((Composite)this.reportsAndDetailsSash, 0);
        this.commentTwistie = new ExpandableComposite(this.detailsArea, 0);
        this.commentTwistie.setText("Comment");
        this.commentTwistie.setExpanded(true);
        this.commentTwistie.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                if (e.getState()) {
                    ReviewDialog.this.commentAndPreviewSash.setMaximizedControl(null);
                    Control control = ReviewDialog.this.commentAndPreviewSash.getChildren()[0];
                    if (control.getSize().y < 30) {
                        ReviewDialog.this.commentAndPreviewSash.setWeights(new int[]{1, 3});
                    }
                } else {
                    ReviewDialog.this.commentAndPreviewSash.setMaximizedControl((Control)ReviewDialog.this.previewArea);
                    if (!ReviewDialog.this.previewTwistie.isExpanded()) {
                        ReviewDialog.this.previewTwistie.setExpanded(true);
                        ReviewDialog.this.showPreviewListener.showPreview();
                    }
                }
            }
        });
        this.severity = new ComboViewer(this.detailsArea);
        this.severity.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.severity.setInput(Severity.VALUES);
        this.severity.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return element == Severity.UNKNOWN ? "This problem's severity is..." : StringUtils.capitalize((String)StringUtils.lowerCase((String)StringUtils.replaceChars((String)element.toString(), (char)'_', (char)' ')));
            }
        });
        this.commentAndPreviewSash = new SashForm(this.detailsArea, 512);
        this.commentAndPreviewSash.setSashWidth(10);
        this.createCommentArea((Composite)this.commentAndPreviewSash);
        this.createPreviewArea((Composite)this.commentAndPreviewSash);
        this.commentAndPreviewSash.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                if (!ReviewDialog.this.preview.isVisible()) {
                    int height2 = ((ReviewDialog)ReviewDialog.this).commentAndPreviewSash.getClientArea().height;
                    ReviewDialog.this.commentAndPreviewSash.setWeights(new int[]{height2, height + 5 + ReviewDialog.this.commentAndPreviewSash.getSashWidth()});
                }
            }
        });
        UI.gl().margins(0, 0).spacing(0, 0).numColumns(2).applyTo(this.detailsArea);
        UI.gdGrabHV().span(2, 1).applyTo((Control)this.commentAndPreviewSash);
        GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).applyTo((Control)this.commentTwistie);
        GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).applyTo(this.severity.getControl());
    }

    private void createReportsAndDetailsSash(Composite parent) {
        this.reportsAndDetailsSash = new SashForm(parent, 256);
        this.reportsAndDetailsSash.setSashWidth(10);
        UI.gdGrabHV().applyTo((Control)this.reportsAndDetailsSash);
    }

    private void createEventsTree(Composite parent) {
        Composite container = new Composite(parent, 0);
        Label label = new Label(container, 0);
        label.setText("Events");
        this.reportsViewer = new TableViewer(container);
        this.reportsViewer.setContentProvider((IContentProvider)new ObservableListContentProvider());
        this.reportsViewer.setLabelProvider((IBaseLabelProvider)new ReportsViewerLabelprovider());
        this.reportsViewer.getControl().addKeyListener((KeyListener)new ReportsViewerDeleteListener());
        UI.gl().applyTo(container);
        UI.gdGrabH().align(1, 0x1000008).applyTo((Control)label);
        UI.gdGrabHV().applyTo((Control)container);
        UI.gdGrabHV().applyTo(this.reportsViewer.getControl());
    }

    private void createCommentArea(Composite parent) {
        this.comments = new StyledText(parent, 2626);
        this.comments.setToolTipText("Please provide concrete steps to reproduce or key information about your environment.");
        this.comments.setAlwaysShowScrollBars(false);
        UI.gdGrabHV().applyTo((Control)this.comments);
    }

    private void createPreviewArea(Composite parent) {
        this.previewArea = new Composite(parent, 0);
        this.previewTwistie = new ExpandableComposite(this.previewArea, 0);
        this.previewTwistie.setText("Preview");
        this.showPreviewListener = new ShowPreviewListener();
        this.previewTwistie.addExpansionListener((IExpansionListener)this.showPreviewListener);
        this.addonsBar = new ToolBar(this.previewArea, 0x800000);
        this.anonymizeMessagesOption = new ToolItem(this.addonsBar, 32);
        Image icon3 = this.getImageFromRegistry("icons/obj16/usr-no.png");
        this.anonymizeMessagesOption.setImage(icon3);
        this.anonymizeMessagesOption.setToolTipText("Enable 'anonymize all\nmessages' for this report.");
        Image icon4 = this.getImageFromRegistry("icons/obj16/stcktrc-no.png");
        this.anonymizeStackTraceOption = new ToolItem(this.addonsBar, 32);
        this.anonymizeStackTraceOption.setImage(icon4);
        this.anonymizeStackTraceOption.setToolTipText("Enable 'anonymize all 3rd party\nstack trace elements' for this report.");
        this.preview = new StyledText(this.previewArea, 2816);
        this.preview.setEditable(false);
        this.preview.setMargins(2, 2, 2, 2);
        this.preview.setFont(JFaceResources.getFont((String)"org.eclipse.jface.textfont"));
        this.preview.setForeground(parent.getDisplay().getSystemColor(16));
        this.preview.setVisible(false);
        UI.gl().numColumns(2).applyTo(this.previewArea);
        UI.gdGrabH().align(0x1000008, 0x1000000).applyTo((Control)this.addonsBar);
        UI.gdGrabHV().span(2, 1).hint(-1, 300).applyTo((Control)this.preview);
    }

    private Image getImageFromRegistry(String path) {
        Image res = this.registry.get(path);
        if (res == null) {
            ImageDescriptor desc = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.epp.logging.aeri.ui", (String)path);
            this.registry.put(path, desc);
            res = this.registry.get(path);
        }
        return res;
    }

    protected void createPreferencesLink(Composite parent) {
        Link link = new Link(parent, 0);
        link.setText("Change <a>sending preferences...</a>");
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn(null, (String)"org.eclipse.epp.logging.aeri.ui.preferencePages.root", null, null);
                dialog.open();
            }
        });
        UI.gdGrabHV().indent(0, 10).minSize(-1, 20).applyTo((Control)link);
    }

    private void createDatabindings() {
        this.dbContext = new DataBindingContext();
        this.selectedLogEvent = ViewerProperties.singlePostSelection().observe((Viewer)this.reportsViewer);
        this.reportsViewer.setInput((Object)this.events);
        IObservableValue emf = EMFProperties.value((FeaturePath)FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{IModelPackage.Literals.LOG_EVENT__OPTIONS, IModelPackage.Literals.SEND_OPTIONS__COMMENT})).observeDetail((IObservableValue)this.selectedLogEvent);
        ISWTObservableValue swt = WidgetProperties.text((int)24).observeDelayed(300, (Widget)this.comments);
        this.dbContext.bindValue((IObservableValue)swt, emf);
        emf = EMFProperties.value((FeaturePath)FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{IModelPackage.Literals.LOG_EVENT__OPTIONS, IModelPackage.Literals.SEND_OPTIONS__ANONYMIZE_STACK_TRACES})).observeDetail((IObservableValue)this.selectedLogEvent);
        swt = ToolItemProperty.toolItemSelection().observe((Widget)this.anonymizeStackTraceOption);
        this.dbContext.bindValue((IObservableValue)swt, emf);
        emf = EMFProperties.value((FeaturePath)FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{IModelPackage.Literals.LOG_EVENT__OPTIONS, IModelPackage.Literals.SEND_OPTIONS__ANONYMIZE_MESSAGES})).observeDetail((IObservableValue)this.selectedLogEvent);
        swt = ToolItemProperty.toolItemSelection().observe((Widget)this.anonymizeMessagesOption);
        this.dbContext.bindValue((IObservableValue)swt, emf);
        emf = EMFProperties.value((FeaturePath)FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{IModelPackage.Literals.LOG_EVENT__OPTIONS, IModelPackage.Literals.SEND_OPTIONS__SEVERITY})).observeDetail((IObservableValue)this.selectedLogEvent);
        IViewerObservableValue jface = ViewerProperties.singleSelection().observe((Viewer)this.severity);
        this.dbContext.bindValue((IObservableValue)jface, emf);
        this.addChangeListenerToBindings(this.dbContext);
    }

    private void addChangeListenerToBindings(DataBindingContext context) {
        for (Object o : context.getBindings()) {
            Binding b = (Binding)o;
            b.getModel().addChangeListener(new IChangeListener(){

                public void handleChange(ChangeEvent event) {
                    ILogEvent logEvent = (ILogEvent)ReviewDialog.this.selectedLogEvent.getValue();
                    if (logEvent != null) {
                        IServer server = logEvent.getServer();
                        IReport report = server.transform(logEvent.getStatus(), logEvent.getContext());
                        String text = "The following report will be sent to " + server.getName() + ":\n\n" + Reports.toPrettyString(report);
                        ReviewDialog.this.preview.setText(text);
                    }
                }
            });
        }
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.okPressed();
        } else if (1 == buttonId) {
            this.cancelPressed();
        }
    }

    public boolean close() {
        this.context.modify("org.eclipse.epp.logging.aeri.ui.ui.review-ongoing", (Object)false);
        this.dbContext.dispose();
        this.prefs.putInt(PREF_REVIEW_DIALOG_WIDTH, this.getShell().getSize().x);
        this.queue.eAdapters().remove((Object)this.incomingEventsCopier);
        return super.close();
    }

    protected void okPressed() {
        super.okPressed();
        this.broker.post("org/eclipse/epp/internal/logging/aeri/ui/event/send", (Object)this.queue);
    }

    protected void cancelPressed() {
        super.cancelPressed();
        this.broker.post("org/eclipse/epp/internal/logging/aeri/ui/events/clear", (Object)this.queue);
    }

    private final class IncomingEventsCopier
    extends AdapterImpl {
        private final IInternalInput input;

        private IncomingEventsCopier(IInternalInput input) {
            this.input = input;
        }

        public void notifyChanged(Notification msg) {
            EList<ILogEvent> input2 = this.input.getInput();
            switch (msg.getEventType()) {
                case 3: {
                    ILogEventGroup group = (ILogEventGroup)msg.getNewValue();
                    for (ILogEvent event : group.getEvents()) {
                        IServer server = event.getServer();
                        if (!server.isConfigured()) continue;
                        input2.add((Object)event);
                    }
                    break;
                }
                case 4: {
                    ILogEventGroup group = (ILogEventGroup)msg.getOldValue();
                    input2.removeAll(group.getEvents());
                }
            }
        }
    }

    private final class ReportsViewerDeleteListener
    extends KeyAdapter {
        private ReportsViewerDeleteListener() {
        }

        public void keyPressed(KeyEvent e) {
            if (e.keyCode == 127 || e.keyCode == 8) {
                this.deleteSelection();
            }
        }

        private void deleteSelection() {
            IStructuredSelection selection = (IStructuredSelection)ReviewDialog.this.reportsViewer.getSelection();
            List elements = selection.toList();
            ReviewDialog.this.events.removeAll((Collection)elements);
            for (ILogEvent event : elements) {
                ILogEventGroup group = (ILogEventGroup)event.eContainer();
                EcoreUtil.delete((EObject)event);
                if (!group.getEvents().isEmpty()) continue;
                EcoreUtil.remove((EObject)group);
            }
        }
    }

    private final class ReportsViewerLabelprovider
    extends LabelProvider {
        private ReportsViewerLabelprovider() {
        }

        public String getText(Object element) {
            return (String)new ModelSwitch<String>(){

                @Override
                public String caseLogEvent(ILogEvent object) {
                    return object.getLabel();
                }
            }.doSwitch((EObject)element);
        }

        public Image getImage(Object element) {
            return (Image)new ModelSwitch<Image>(){

                @Override
                public Image caseLogEvent(ILogEvent object) {
                    return UI.decorate(object.getServer(), object.getStatus(), ReviewDialog.this.registry);
                }
            }.doSwitch((EObject)element);
        }
    }

    private final class ShowPreviewListener
    extends ExpansionAdapter {
        private Point collapsedShellSize;
        private int collapsedUpperHeight;
        private int collapsedlowerHeight;

        private ShowPreviewListener() {
        }

        public void expansionStateChanged(ExpansionEvent e) {
            if (e.getState()) {
                this.showPreview();
            } else {
                this.hidePreview();
            }
        }

        public void hidePreview() {
            Shell shell = ReviewDialog.this.getShell();
            ReviewDialog.this.preview.setVisible(false);
            Point current = shell.getSize();
            ReviewDialog.this.commentAndPreviewSash.setWeights(new int[]{this.collapsedUpperHeight, this.collapsedlowerHeight});
            shell.setSize(current.x, Math.max(300, current.y - 300));
        }

        public void showPreview() {
            Shell shell = ReviewDialog.this.getShell();
            ReviewDialog.this.preview.setVisible(true);
            this.collapsedShellSize = shell.getSize();
            this.collapsedUpperHeight = ((ReviewDialog)ReviewDialog.this).commentAndPreviewSash.getChildren()[0].getSize().y;
            this.collapsedlowerHeight = ((ReviewDialog)ReviewDialog.this).commentAndPreviewSash.getChildren()[1].getSize().y;
            ReviewDialog.this.commentAndPreviewSash.setWeights(new int[]{this.collapsedUpperHeight, 300 + this.collapsedlowerHeight});
            shell.setSize(this.collapsedShellSize.x, this.collapsedShellSize.y + 300);
        }
    }

    public static class ToolItemProperty
    extends WidgetValueProperty {
        public static ToolItemProperty toolItemSelection() {
            return new ToolItemProperty();
        }

        public ToolItemProperty() {
            super(13);
        }

        public Object getValueType() {
            return Boolean.TYPE;
        }

        protected Object doGetValue(Object source) {
            ToolItem item = (ToolItem)source;
            boolean value = item.getSelection();
            return value;
        }

        protected void doSetValue(Object source, @Nullable Object value) {
            if (value == null) {
                value = Boolean.FALSE;
            }
            ToolItem item = (ToolItem)source;
            item.setSelection(((Boolean)value).booleanValue());
        }
    }
}

