/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ui.dialogs;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epp.internal.logging.aeri.ui.SystemControl;
import org.eclipse.epp.internal.logging.aeri.ui.l10n.Messages;
import org.eclipse.epp.internal.logging.aeri.ui.model.IModelPackage;
import org.eclipse.epp.internal.logging.aeri.ui.model.ISystemSettings;
import org.eclipse.epp.internal.logging.aeri.ui.model.SendMode;
import org.eclipse.epp.internal.logging.aeri.ui.utils.Browsers;
import org.eclipse.epp.internal.logging.aeri.ui.utils.SendModeLabelProvider;
import org.eclipse.epp.internal.logging.aeri.ui.utils.Servers;
import org.eclipse.epp.internal.logging.aeri.ui.utils.UI;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class PreferencePage
extends org.eclipse.jface.preference.PreferencePage
implements IWorkbenchPreferencePage,
IModelPackage.Literals {
    private DataBindingContext context = new DataBindingContext();
    private ISystemSettings systemSettings = SystemControl.getSystemSettings();

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        Group defaults = new Group(container, 0);
        defaults.setText("Default Reporter Preferences");
        Composite reporterDefaults = this.createPersonalControl((Composite)defaults);
        Group anonymizeDefaults = this.createAnonymizeControl((Composite)defaults);
        UI.gl().margins(5, 5).applyTo((Composite)defaults);
        UI.gd().applyTo((Control)defaults);
        UI.gdGrabH().indent(10, 0).applyTo((Control)reporterDefaults);
        UI.gdGrabH().indent(0, 10).applyTo((Control)anonymizeDefaults);
        Composite sendModeDefaults = this.createSendModeControl(container);
        this.addConfigureButton(container);
        Button debug = UI.createCheckButton(container, Messages.FIELD_LABEL_ENABLE_DEBUG, Messages.TOOLTIP_SETTINGS_MAKE_MESSAGES_ANONYMOUS);
        ISWTObservableValue swt = WidgetProperties.selection().observe((Widget)debug);
        IObservableValue emf = EMFProperties.value((EStructuralFeature)SYSTEM_SETTINGS__DEBUG_ENABLED).observe((Object)this.systemSettings);
        this.context.bindValue((IObservableValue)swt, emf);
        this.addLinks(container);
        UI.gl().margins(5, 5).applyTo(container);
        UI.gd().applyTo((Control)container);
        UI.gd().applyTo((Control)sendModeDefaults);
        this.applyDialogFont(container);
        return container;
    }

    private Composite createSendModeControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        Label label = new Label(container, 0);
        label.setText("Send Mode:");
        label.setToolTipText(Messages.TOOLTIP_SEND_MODE);
        ComboViewer sendMode = new ComboViewer(container);
        sendMode.getControl().setToolTipText(Messages.TOOLTIP_SEND_MODE);
        sendMode.setContentProvider((IContentProvider)new ArrayContentProvider());
        sendMode.setInput(SendMode.VALUES);
        sendMode.setLabelProvider((IBaseLabelProvider)new SendModeLabelProvider());
        IViewerObservableValue jface = ViewersObservables.observeSinglePostSelection((StructuredViewer)sendMode);
        IObservableValue emf = EMFProperties.value((EStructuralFeature)SYSTEM_SETTINGS__SEND_MODE).observe((Object)this.systemSettings);
        this.context.bindValue((IObservableValue)jface, emf);
        UI.gl().numColumns(2).applyTo(container);
        UI.gd().align(1, 0x1000000).applyTo((Control)label);
        UI.gdGrabH().align(0x1000008, 0x1000000).applyTo((Control)sendMode.getCombo());
        return container;
    }

    private Composite createPersonalControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        UI.gl().numColumns(2).applyTo(container);
        Text name = UI.createLabelWithText(container, Messages.FIELD_LABEL_NAME, Messages.FIELD_MESSAGE_NAME, Messages.FIELD_MESSAGE_NAME);
        ISWTObservableValue swt = WidgetProperties.text((int)16).observe((Widget)name);
        IObservableValue emf = EMFProperties.value((EStructuralFeature)SYSTEM_SETTINGS__REPORTER_NAME).observe((Object)this.systemSettings);
        this.context.bindValue((IObservableValue)swt, emf);
        String tooltip = String.valueOf(Messages.FIELD_MESSAGE_SETTINGS_EMAIL) + '\n' + Messages.TOOLTIP_SETTINGS_EMAIL;
        Text email = UI.createLabelWithText(container, Messages.FIELD_LABEL_EMAIL, Messages.FIELD_MESSAGE_SETTINGS_EMAIL, tooltip);
        ISWTObservableValue swt2 = WidgetProperties.text((int)24).observe((Widget)email);
        IObservableValue emf2 = EMFProperties.value((EStructuralFeature)SYSTEM_SETTINGS__REPORTER_EMAIL).observe((Object)this.systemSettings);
        this.context.bindValue((IObservableValue)swt2, emf2);
        return container;
    }

    private Group createAnonymizeControl(Composite parent) {
        Group container = new Group(parent, 92);
        container.setLayout((Layout)new RowLayout(512));
        container.setText(Messages.CONFIGURATIONDIALOG_ANONYMIZATION);
        Button stackTraces = UI.createCheckButton((Composite)container, Messages.FIELD_LABEL_ANONYMIZE_STACKTRACES, Messages.TOOLTIP_SETTINGS_MAKE_STACKTRACE_ANONYMOUS);
        stackTraces.setFocus();
        ISWTObservableValue swt = WidgetProperties.selection().observe((Widget)stackTraces);
        IObservableValue emf = EMFProperties.value((EStructuralFeature)SYSTEM_SETTINGS__ANONYMIZE_STACK_TRACES).observe((Object)this.systemSettings);
        this.context.bindValue((IObservableValue)swt, emf);
        Button messages = UI.createCheckButton((Composite)container, Messages.FIELD_LABEL_ANONYMIZE_MESSAGES, Messages.TOOLTIP_SETTINGS_MAKE_MESSAGES_ANONYMOUS);
        swt = WidgetProperties.selection().observe((Widget)messages);
        emf = EMFProperties.value((EStructuralFeature)SYSTEM_SETTINGS__ANONYMIZE_MESSAGES).observe((Object)this.systemSettings);
        this.context.bindValue((IObservableValue)swt, emf);
        return container;
    }

    private void addConfigureButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("Servers...");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Servers.openConfigureServersDialog();
            }
        });
        UI.gd().align(0x1000008, 0x1000000).applyTo((Control)button);
    }

    private void addLinks(Composite parent) {
        Composite links = new Composite(parent, 0);
        links.setLayout((Layout)new RowLayout(512));
        GridDataFactory.fillDefaults().span(2, 1).grab(true, false).applyTo((Control)links);
        this.createNotificationsLabelAndLink(links);
    }

    private void createNotificationsLabelAndLink(Composite links) {
        Link link = new Link(links, 0);
        link.setText("Notifications are configured on the <a>Notifications</a> preference page.");
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencesUtil.createPreferenceDialogOn((Shell)PreferencePage.this.getShell(), (String)"org.eclipse.mylyn.commons.notifications.preferencePages.Notifications", null, null);
            }
        });
    }

    private Link createAndConfigureLink(Composite parent, String text, final String url) {
        Link link = new Link(parent, 0);
        link.setText(text);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Browsers.openInExternalBrowser(url);
            }
        });
        return link;
    }

    private static String[][] createModeLabelAndValues() {
        SendMode[] modes = SendMode.values();
        String[][] labelAndValues = new String[modes.length][2];
        int i = 0;
        while (i < modes.length) {
            SendMode mode = modes[i];
            labelAndValues[i][0] = PreferencePage.descriptionForMode(mode);
            labelAndValues[i][1] = mode.name();
            ++i;
        }
        return labelAndValues;
    }

    private static String descriptionForMode(SendMode mode) {
        return new SendModeLabelProvider().getText((Object)mode);
    }

    public boolean performOk() {
        return super.performOk();
    }
}

