/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ui.dialogs;

import java.util.concurrent.TimeUnit;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epp.internal.logging.aeri.ui.l10n.Messages;
import org.eclipse.epp.internal.logging.aeri.ui.model.IModelPackage;
import org.eclipse.epp.internal.logging.aeri.ui.model.IServer;
import org.eclipse.epp.internal.logging.aeri.ui.model.ISystemSettings;
import org.eclipse.epp.internal.logging.aeri.ui.model.SendMode;
import org.eclipse.epp.internal.logging.aeri.ui.utils.Browsers;
import org.eclipse.epp.internal.logging.aeri.ui.utils.SendModeLabelProvider;
import org.eclipse.epp.internal.logging.aeri.ui.utils.Servers;
import org.eclipse.epp.internal.logging.aeri.ui.utils.UI;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.window.DefaultToolTip;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class EclipseServerPage
extends WizardPage {
    private static final Point TOOLTIP_DISPLACEMENT = new Point(5, 20);
    private static final int TOOLTIP_HIDE_DELAY = (int)TimeUnit.SECONDS.toMillis(20L);
    private ISystemSettings systemSettings;
    private IServer server;
    private DataBindingContext context;

    public EclipseServerPage(IServer server, ISystemSettings systemSettings) {
        super(EclipseServerPage.class.getName());
        this.server = server;
        this.systemSettings = systemSettings;
        this.context = new DataBindingContext();
        Servers.copySystemDefaultsIfUnset(systemSettings, server);
        this.setTitle("Thank you for enabling Automated Error Reporting for Eclipse");
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        Composite reporterDefaults = this.createPersonalControl(container);
        Group anonymizeDefaults = this.createAnonymizeControl(container);
        Composite sendModeDefaults = this.createSendModeControl(container);
        Composite links = this.createLinksControl(container);
        UI.gl().margins(5, 5).applyTo(container);
        UI.gd().applyTo((Control)container);
        UI.gdGrabH().indent(10, 0).applyTo((Control)reporterDefaults);
        UI.gd().indent(0, 10).applyTo((Control)anonymizeDefaults);
        UI.gd().align(131072, 0x1000000).applyTo((Control)sendModeDefaults);
        UI.gdGrabV().align(1, 0x1000008).applyTo((Control)links);
        Dialog.applyDialogFont((Control)container);
        this.setControl((Control)container);
    }

    private Composite createLinksControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        UI.gl().numColumns(2).applyTo(container);
        Link learnMore = new Link(container, 0);
        learnMore.setText("<a>Learn more...</a>");
        learnMore.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Browsers.openInExternalBrowser("https://wiki.eclipse.org/EPP/Logging");
            }
        });
        return container;
    }

    public void setVisible(boolean visible) {
        this.setDescription("Please take a moment for the initial configuration.\nAll values can be changed in the preferences at any time.");
        super.setVisible(visible);
    }

    private Composite createPersonalControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        UI.gl().numColumns(2).applyTo(container);
        Text name = this.createLabelWithText(container, Messages.FIELD_LABEL_NAME, Messages.FIELD_MESSAGE_NAME, Messages.FIELD_MESSAGE_NAME);
        ISWTObservableValue swt = WidgetProperties.text((int)16).observe((Widget)name);
        IObservableValue emf = EMFProperties.value((EStructuralFeature)IModelPackage.Literals.SERVER__REPORTER_NAME).observe((Object)this.server);
        this.context.bindValue((IObservableValue)swt, emf);
        String tooltip = String.valueOf(Messages.FIELD_MESSAGE_EMAIL) + '\n' + Messages.FIELD_DESC_EMAIL;
        Text email = this.createLabelWithText(container, Messages.FIELD_LABEL_EMAIL, Messages.FIELD_MESSAGE_EMAIL, tooltip);
        ISWTObservableValue swt2 = WidgetProperties.text((int)24).observe((Widget)email);
        IObservableValue emf2 = EMFProperties.value((EStructuralFeature)IModelPackage.Literals.SERVER__REPORTER_EMAIL).observe((Object)this.server);
        this.context.bindValue((IObservableValue)swt2, emf2);
        return container;
    }

    private Text createLabelWithText(Composite parent, String labelText, String textMessage, String toolTip) {
        Label label = new Label(parent, 0);
        label.setText(labelText);
        this.calibrateTooltip(new DefaultToolTip((Control)label), toolTip);
        Text text = new Text(parent, 2048);
        text.setMessage(textMessage);
        this.calibrateTooltip(new DefaultToolTip((Control)text), toolTip);
        UI.gdGrabH().applyTo((Control)text);
        return text;
    }

    private Group createAnonymizeControl(Composite parent) {
        Group container = new Group(parent, 92);
        container.setLayout((Layout)new RowLayout(512));
        container.setText(Messages.CONFIGURATIONDIALOG_ANONYMIZATION);
        Button stackTraces = this.createGroupCheckButton(container, Messages.FIELD_LABEL_ANONYMIZE_STACKTRACES, Messages.TOOLTIP_MAKE_STACKTRACE_ANONYMOUS);
        stackTraces.setFocus();
        ISWTObservableValue swt = WidgetProperties.selection().observe((Widget)stackTraces);
        IObservableValue emf = EMFProperties.value((EStructuralFeature)IModelPackage.Literals.SERVER__ANONYMIZE_STACK_TRACES).observe((Object)this.server);
        this.context.bindValue((IObservableValue)swt, emf);
        Button messages = this.createGroupCheckButton(container, Messages.FIELD_LABEL_ANONYMIZE_MESSAGES, Messages.TOOLTIP_MAKE_MESSAGES_ANONYMOUS);
        swt = WidgetProperties.selection().observe((Widget)messages);
        emf = EMFProperties.value((EStructuralFeature)IModelPackage.Literals.SERVER__ANONYMIZE_MESSAGES).observe((Object)this.server);
        this.context.bindValue((IObservableValue)swt, emf);
        return container;
    }

    private Button createGroupCheckButton(Group group, String buttonText, String toolTipText) {
        Button button = new Button((Composite)group, 32);
        button.setText(buttonText);
        this.calibrateTooltip(new DefaultToolTip((Control)button), toolTipText);
        return button;
    }

    private Composite createSendModeControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        ComboViewer sendMode = new ComboViewer(container);
        sendMode.getControl().setToolTipText(Messages.TOOLTIP_SEND_MODE);
        sendMode.setContentProvider((IContentProvider)new ArrayContentProvider());
        sendMode.setInput(SendMode.VALUES);
        sendMode.setLabelProvider((IBaseLabelProvider)new SendModeLabelProvider());
        IViewerObservableValue jface = ViewersObservables.observeSinglePostSelection((StructuredViewer)sendMode);
        IObservableValue emf = EMFProperties.value((EStructuralFeature)IModelPackage.Literals.SYSTEM_SETTINGS__SEND_MODE).observe((Object)this.systemSettings);
        this.context.bindValue((IObservableValue)jface, emf);
        UI.gl().numColumns(2).applyTo(container);
        UI.gdGrabH().align(0x1000008, 0x1000000).span(2, 1).applyTo((Control)container);
        return container;
    }

    private void calibrateTooltip(DefaultToolTip toolTip, String toolTipText) {
        toolTip.setText(toolTipText);
        toolTip.setFont(JFaceResources.getDialogFont());
        toolTip.setShift(TOOLTIP_DISPLACEMENT);
        toolTip.setHideDelay(TOOLTIP_HIDE_DELAY);
    }

    public void dispose() {
        Servers.setAsDefaults(this.server, this.systemSettings);
        this.context.dispose();
        super.dispose();
    }
}

