/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ui;

import com.google.common.base.Preconditions;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.epp.internal.logging.aeri.ui.EventsController;
import org.eclipse.epp.internal.logging.aeri.ui.LogListener;
import org.eclipse.epp.internal.logging.aeri.ui.dialogs.ReviewDialog;
import org.eclipse.epp.internal.logging.aeri.ui.functions.EventsControllerCreationFunction;
import org.eclipse.epp.internal.logging.aeri.ui.functions.ImageRegistryCreationFunction;
import org.eclipse.epp.internal.logging.aeri.ui.functions.LogEventsQueueCreationFunction;
import org.eclipse.epp.internal.logging.aeri.ui.functions.LogListenerCreationFunction;
import org.eclipse.epp.internal.logging.aeri.ui.functions.NotificationsServiceCreationFunction;
import org.eclipse.epp.internal.logging.aeri.ui.functions.RegistryServersCreationFunction;
import org.eclipse.epp.internal.logging.aeri.ui.functions.ReviewDialogCreationFunction;
import org.eclipse.epp.internal.logging.aeri.ui.functions.SystemSettingsCreationFunction;
import org.eclipse.epp.internal.logging.aeri.ui.functions.SystemStatusFiltersCreationFunction;
import org.eclipse.epp.internal.logging.aeri.ui.model.ILogEventsQueue;
import org.eclipse.epp.internal.logging.aeri.ui.model.IServer;
import org.eclipse.epp.internal.logging.aeri.ui.model.ISystemSettings;
import org.eclipse.epp.internal.logging.aeri.ui.notifications.NotificationsService;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

public class SystemControl {
    public static final String PREFERENCE_PAGE_ID = "org.eclipse.epp.logging.aeri.ui.preferencePages.root";
    public static final String SERVERS = "org.eclipse.epp.logging.aeri.ui.servers";
    public static final String STATE_LOCATION = "org.eclipse.epp.logging.aeri.ui.stateLocation";
    public static final String STATUS_FILTER = "org.eclipse.epp.logging.aeri.ui.statusFilters";
    @Nullable
    private static IEclipseContext SYSTEM_CONTEXT;

    private static IEclipseContext createDefaultContext() {
        IEclipseContext parent = (IEclipseContext)PlatformUI.getWorkbench().getService(IEclipseContext.class);
        IEclipseContext context = parent.createChild("AeriUIContext");
        Bundle bundle = Platform.getBundle((String)"org.eclipse.epp.logging.aeri.ui");
        context.set(Bundle.class, (Object)bundle);
        context.set(ISystemSettings.class.getName(), (Object)new SystemSettingsCreationFunction());
        context.set(STATE_LOCATION, (Object)Platform.getStateLocation((Bundle)bundle));
        context.set(STATUS_FILTER, (Object)new SystemStatusFiltersCreationFunction());
        context.set(SERVERS, (Object)new RegistryServersCreationFunction());
        context.set(LogListener.class.getName(), (Object)new LogListenerCreationFunction());
        context.set(NotificationsService.class.getName(), (Object)new NotificationsServiceCreationFunction());
        context.set(EventsController.class.getName(), (Object)new EventsControllerCreationFunction());
        context.set(ILogEventsQueue.class.getName(), (Object)new LogEventsQueueCreationFunction());
        context.set(ReviewDialog.class.getName(), (Object)new ReviewDialogCreationFunction());
        context.set(ImageRegistry.class.getName(), (Object)new ImageRegistryCreationFunction());
        context.set("org.eclipse.epp.logging.aeri.ui.ui.review-ongoing", (Object)false);
        context.declareModifiable("org.eclipse.epp.logging.aeri.ui.ui.review-ongoing");
        context.set("org.eclipse.epp.logging.aeri.ui.ui.configure-ongoing", (Object)false);
        context.declareModifiable("org.eclipse.epp.logging.aeri.ui.ui.configure-ongoing");
        context.set("org.eclipse.epp.logging.aeri.ui.ui.notification-ongoing", (Object)false);
        context.declareModifiable("org.eclipse.epp.logging.aeri.ui.ui.notification-ongoing");
        return context;
    }

    public static IEclipseContext getSystemContext() {
        if (SYSTEM_CONTEXT == null) {
            SYSTEM_CONTEXT = SystemControl.createDefaultContext();
        }
        return (IEclipseContext)Preconditions.checkNotNull((Object)SYSTEM_CONTEXT);
    }

    public static ISystemSettings getSystemSettings() {
        return (ISystemSettings)Preconditions.checkNotNull((Object)SystemControl.get(ISystemSettings.class));
    }

    public static List<IServer> getServers() {
        List servers = (List)SystemControl.get(SERVERS);
        return (List)Preconditions.checkNotNull((Object)servers);
    }

    public static void configure(@Nullable IEclipseContext context) {
        SYSTEM_CONTEXT = context;
    }

    @Nullable
    public static <T> T get(String key) {
        return (T)SYSTEM_CONTEXT.get(key);
    }

    @Nullable
    public static <T> T get(Class<T> key) {
        return (T)SYSTEM_CONTEXT.get(key);
    }
}

